package csbsju.cs160;

/**
 * Represents an integer of infinite precision. That is, the
 * representation grows as the user types more. This is simply
 * a front-end to the standard Java library
 * <code>java.math.BigInteger</code>.
 *
 * @author  Carl Burch
 * @version 30 September 2001
 */
public class BigInteger {
	private java.math.BigInteger me;

	private BigInteger(java.math.BigInteger val) { me = val; }

	/** Constructs a <code>BigInteger</code> representing the number
	 * <code>value</code>. */
	public BigInteger(int value) {
		me = new java.math.BigInteger(String.valueOf(value));
	}

	/** Constructs a <code>BigInteger</code> representing the value
	 * represented in <code>str</code>. */
	public BigInteger(String str) {
		me = new java.math.BigInteger(str);
	}

	/** Returns a new <code>BigInteger</code> representing the value of
	 * adding the object's represented value to <code>other</code>'s
	 * represented value. */
	public BigInteger add(BigInteger other) {
		return new BigInteger(me.add(other.me));
	}

	/** Returns a new <code>BigInteger</code> representing the value of
	 * subtracting <code>other</code>'s represented value to the
	 * object's represented value. */
	public BigInteger subtract(BigInteger other) {
		return new BigInteger(me.subtract(other.me));
	}

	/** Returns a new <code>BigInteger</code> representing the value of
	 * multiplying the object's represented value to <code>other</code>'s
	 * represented value. */
	public BigInteger multiply(BigInteger other) {
		return new BigInteger(me.multiply(other.me));
	}

	/** Returns a new <code>BigInteger</code> representing the value of
	 * dividing the object's represented value by <code>other</code>'s
	 * represented value. Any remainder is ignored. */
	public BigInteger divide(BigInteger other) {
		return new BigInteger(me.divide(other.me));
	}

	/** Returns a new <code>BigInteger</code> representing the remainder
	 * when dividing the value of
	 * dividing the object's represented value by <code>other</code>'s
	 * represented value. */
	public BigInteger remainder(BigInteger other) {
		return new BigInteger(me.remainder(other.me));
	}

	/** Returns -1, if the object represents a value less than what
	 * <code>other</code> represents, 0 if the values are equal, and
	 * 1 if the object's represented value is greater than what
	 * <code>other</code> represents. */
	public int compareTo(BigInteger other) { return me.compareTo(other.me); }

	/** Returns <code>true</code> if the object and <code>other</code>
	 * represent identical values. */
	public boolean equals(BigInteger other) { return me.equals(other.me); }

	/** Returns a string representation of the
	 * object value in decimal. */
	public String toString() { return me.toString(); }

	/** Returns a <code>double</code> holding an approximation of the
	 * object value. */
	public double doubleValue() { return me.doubleValue(); }

}
