package csbsju.cs160;

import java.util.*;

/**
 * Provides a set of static methods for printing and reading
 * from the console.
 *
 * @author  Carl Burch
 * @version 28 August 2001
 */
public class Console {
	private static final boolean DR_JAVA = false;

	private static InputBuffer buffer
		= new InputBuffer();

	private Console() { }

	private static class InputBuffer {
		public static final String skipchars = " \n\r\t";
		private java.io.BufferedReader reader
			= new java.io.BufferedReader(
				new java.io.InputStreamReader(System.in));

		private String buf = null;

		private void getBuffer() {
			if(buf == null) {
				try {
					buf = reader.readLine();
				} catch(java.io.IOException e) {}
			}
		}

		private void toNextWord() {
			int[] pos = new int[skipchars.length()];
			if(buf != null) {
				// find first occurrence of character not in skipchars
				int i;
				for(i = 0; i < buf.length(); i++) {
					if(skipchars.indexOf(buf.charAt(i)) < 0) break;
				}

				// trim off everything up to this character
				buf = buf.substring(i);
			}
			while(buf == null || buf.equals("")) {
				buf = null;
				getBuffer();

				// find first occurrence of character not in skipchars
				int i;
				for(i = 0; i < buf.length(); i++) {
					if(skipchars.indexOf(buf.charAt(i)) < 0) break;
				}

				// trim off everything up to this character
				buf = buf.substring(i);
			}
		}

		public String getLine() {
			if(buf != null && buf.equals("")) buf = null;
			getBuffer();
			String ret = buf;
			buf = null;
			return ret;
		}

		public char getChar() {
			getBuffer();
			if(buf.equals("")) {
				buf = null;
				return '\n';
			} else {
				char ret = buf.charAt(0);
				buf = buf.substring(1);
				return ret;
			}
		}

		public String getWord() {
			toNextWord();

			int pos = 0;
			while(pos < buf.length()
					&& skipchars.indexOf(buf.charAt(pos)) < 0) {
				++pos;
			}

			String ret = buf.substring(0, pos);
			buf = buf.substring(pos);
			return ret;
		}

		public boolean getBoolean() {
			return getWord().equalsIgnoreCase("true");
		}

		public int getInt() {
			toNextWord();

			int pos = 0;
			if(pos < buf.length() + 1 && buf.charAt(pos) == '-'
					&& Character.isDigit(buf.charAt(pos + 1))) {
				++pos;
			}
			while(pos < buf.length()
					&& Character.isDigit(buf.charAt(pos))) {
				++pos;
			}

			if(pos == 0) {
				buf = buf.substring(1);
				return Integer.MIN_VALUE;
			} else {
				int ret = Integer.parseInt(buf.substring(0, pos));
				buf = buf.substring(pos);
				return ret;
			}
		}

		public double getDouble() {
			toNextWord();

			int last = -1;
			int state = 0;
			for(int pos = 0; pos < buf.length() && state >= 0; pos++) {
				char c = buf.charAt(pos);
				int oldstate = state;
				state = -1;
				switch(oldstate) {
				case 0:
					if(Character.isDigit(c))      state = 2;
					else if(c == '+' || c == '-') state = 1;
					else if(c == '.')             state = 3;
					break;
				case 1:
					if(Character.isDigit(c))      state = 2;
					else if(c == '.')             state = 3;
					break;
				case 2:
					if(Character.isDigit(c))      state = 2;
					else if(c == '.')             state = 4;
					else if(c == 'e' || c == 'E') state = 5;
					break;
				case 3:
					if(Character.isDigit(c))      state = 4;
					break;
				case 4:
					if(Character.isDigit(c))      state = 4;
					else if(c == 'e' || c == 'E') state = 5;
					break;
				case 5:
					if(Character.isDigit(c))      state = 7;
					else if(c == '-' || c == '+') state = 6;
					break;
				case 6:
					if(Character.isDigit(c))      state = 7;
					break;
				case 7:
					if(Character.isDigit(c))      state = 7;
					break;
				}
				if(state == 2 || state == 4 || state == 7) {
					last = pos + 1;
				}
			}

			if(last < 0) {
				buf = buf.substring(1);
				return Double.NaN;
			} else {
				double ret = Double.parseDouble(buf.substring(0, last));
				buf = buf.substring(last);
				return ret;
			}
		}
	}

//	private static java.io.BufferedReader in =
//		new java.io.BufferedReader(
//			new java.io.InputStreamReader(System.in), 1);

	/**
	 * Prints the object's value indicated onto the console,
	 * without terminating the current line of output.
	 */
	public static void print(Object text) {
		System.out.print(text.toString());
		System.out.flush();
	}

	/**
	 * Prints the integer value indicated onto the console,
	 * without terminating the current line of output.
	 */
	public static void print(int i) { print(Integer.toString(i)); }

	/**
	 * Prints the double-precision value indicated onto the console,
	 * without terminating the current line of output.
	 */
	public static void print(double i) { print(Double.toString(i)); }

	/**
	 * Prints the Boolean value indicated onto the console,
	 * without terminating the current line of output.
	 */
	public static void print(boolean i) { print("" + i); }

	/**
	 * Prints the character value indicated onto the console,
	 * without terminating the current line of output.
	 */
	public static void print(char i) { print("" + i); }

	/**
	 * Terminates the current line of output.
	 */
	public static void println() {
		System.out.println();
		System.out.flush();
	}

	/**
	 * Prints the object's value indicated onto the console,
	 * then terminates the current line of output.
	 */
	public static void println(Object text) {
		System.out.println(text.toString());
		System.out.flush();
	}

	/**
	 * Prints the integer value indicated onto the console,
	 * then terminates the current line of output.
	 */
	public static void println(int i) { println(Integer.toString(i)); }

	/**
	 * Prints the double-precision value indicated onto the console,
	 * then terminates the current line of output.
	 */
	public static void println(double i) { println(Double.toString(i)); }
	/**
	 * Prints the Boolean value indicated onto the console,
	 * then terminates the current line of output.
	 */
	public static void println(boolean i) { println("" + i); }

	/**
	 * Prints the character value indicated onto the console,
	 * then terminates the current line of output.
	 */
	public static void println(char i) { println("" + i); }

	/**
	 * Returns the next line
	 * the user types into the window. Any terminating
	 * end-of-line characters are omitted.
	 */
	public static String readLine() {
		if(DR_JAVA) {
			println("IO.readLine() is unavailable.\n");
			return "";
		}
		return buffer.getLine();
	}

	/**
	 * Returns the next
	 * character the user types into the window. This will be
	 * '\n' when the user reaches the end of a line.
	 */
	public static char readChar() {
		if(DR_JAVA) {
			println("IO.readChar() is unavailable.\n");
			return ' ';
		}
		return buffer.getChar();
	}

	/**
	 * Returns the next
	 * integer the user types into the window, skipping any
	 * whitespace characters. If the next non-whitespace letters don't
	 * appear to represent an integer, it eats a single
	 * non-whitespace character and returns Double.NaN.
	 */
	public static int readInt() {
		if(DR_JAVA) {
			println("IO.readInt() is unavailable.\n");
			return Integer.MIN_VALUE;
		}
		return buffer.getInt();
	}

	/**
	 * Returns the next
	 * real number the user types into the window, skipping any
	 * whitespace characters.
	 * It supports both regular doubles (like 6.1 or -4)
	 * and scientific notation (like 3e8).
	 * If the next non-whitespace characters
	 * don't appear to represent a real number, it eats a single
	 * non-whitespace character and returns Double.NaN.
	 */
	public static double readDouble() {
		if(DR_JAVA) {
			println("IO.readDouble() is unavailable.\n");
			return Double.NaN;
		}
		return buffer.getDouble();
	}

	/**
	 * Returns the next
	 * real number the user types into the window, skipping any
	 * whitespace characters. This will be true if the user
	 * types the word ``true'' (case is insignificant here).
	 * If the next non-whitespace letters don't appear to represent
	 * a Boolean, it return false.
	 */
	public static boolean readBoolean() {
		if(DR_JAVA) {
			println("IO.readBoolean() is unavailable.\n");
			return false;
		}
		return buffer.getBoolean();
	}

	/**
	 * Returns the next
	 * string of non-whitespace characters the user types into the
	 * window.
	 */
	public static String readString() {
		if(DR_JAVA) {
			println("IO.readString() is unavailable.\n");
			return "";
		}
		return buffer.getWord();
	}

}
