package csbsju.cs160;

/** Provides static methods for converting between various types. */
public class Convert {

	private Convert() { }

	/** Returns the nearest <code>double</code> value to <code>val</code>. */
	public static double toDouble(int val) {
		return (double) val;
	}
	/** Returns the <code>double</code> value represented in
	 * <code>val</code>. If <code>val</code> is not formatted correctly,
	 * the method returns <code>Double.MIN_VALUE</code>. */
	public static double toDouble(String val) {
		try {
			return Double.parseDouble(val);
		} catch(NumberFormatException e) {
			return Double.MIN_VALUE;
		}
	}
	/** Returns the nearest integer value to <code>val</code>. */
	public static int toInt(double val) {
		return (int) Math.rint(val);
	}
	/** Returns the integer value represented in
	 * <code>val</code>. If <code>val</code> is not formatted correctly,
	 * the method returns <code>Integer.MIN_VALUE</code>. */
	public static int toInt(String val) {
		try {
			return Integer.parseInt(val);
		} catch(NumberFormatException e) {
			return Integer.MIN_VALUE;
		}
	}
	/** Returns a string representation of <code>val</code>. */
	public static String toString(double val) {
		return String.valueOf(val);
	}
	/** Returns a string representation of <code>val</code>. */
	public static String toString(int val) {
		return String.valueOf(val);
	}
}
