package csbsju.cs160;

/**
 * Represents a fraction represented in reduced, improper form
 * (like 7/6). Both the numerator and the denominator are limited by the
 * size of the machine's <tt>int</tt> representation (typically 32
 * bits).
 */
public class Fraction {
	/** Holds a <code>Fraction</code> representing the number 0. */
	public static final Fraction ZERO = new Fraction(0, 1);

	/** Holds a <code>Fraction</code> representing the number 1. */
	public static final Fraction ONE = new Fraction(1, 1);

	private int num;
	private int den;

	/**
	 * Constructs a new fraction with the given numerator and
	 * denominator. The numerator and denominator are reduced to their
	 * lowest form.
	 */
	public Fraction(int numerator, int denominator) {
		if(denominator < 0) {
			numerator *= -1;
			denominator *= -1;
		}

		int div = gcd(numerator, denominator);
		num = numerator / div;
		den = denominator / div;
	}

	private static int gcd(int a, int b) {
		if(a == 0) return b;
		if(b == 0) return a;

		while(b != 0) {
			int r = a % b;
			a = b;
			b = r;
		}
		return a;
	}

	/**
	 * Returns the closest <tt>double</tt> approximation to the
	 * fraction's value.
	 */
	public double doubleValue() {
		return (double) num / den;
	}

	/**
	 * Returns a new fraction holding the sum of this fraction and
	 * <code>other</code>.
	 */
	public Fraction add(Fraction other) {
		return new Fraction(num * other.den + den * other.num,
			den * other.den);
	}

	/**
	 * Returns a new fraction holding the difference of this fraction and
	 * <code>other</code>.
	 */
	public Fraction subtract(Fraction other) {
		return new Fraction(num * other.den - den * other.num,
			den * other.den);
	}

	/**
	 * Returns a new fraction holding the product of this fraction and
	 * <code>other</code>.
	 */
	public Fraction multiply(Fraction other) {
		return new Fraction(num * other.num, den * other.den);
	}

	/**
	 * Returns a new fraction holding the quotient of this fraction and
	 * <code>other</code>.
	 */
	public Fraction divide(Fraction other) {
		return new Fraction(num * other.den, den * other.num);
	}

	/**
	 * Returns -1 if this fraction is less than <code>other</code>,
	 * 0 if they are equal, and 1 if this fraction is more.
	 */
	public int compareTo(Fraction other) {
		// first check if they are equal
		if(num == other.num && den == other.den) return 0;

		// otherwise see which is less
		int first = num * other.den;
		int second = other.num * den;
		if(first < second) return -1;
		else return 1;
	}

	/**
	 * Returns <code>true</code> if <code>other</code> represents the
	 * same fraction.
	 */
	public boolean equals(Object other) {
		if(!(other instanceof Fraction)) return false;
		return this.compareTo((Fraction) other) == 0;
	}

	/**
	 * Returns a string representation of the object.
	 */
	public String toString() {
		if(den == 1) {
			return "" + num;
		} else {
			return num + "/" + den;
		}
	}

	/**
	 * Returns the fraction represented by <code>str</code>.
	 */
	public static Fraction parseFraction(String str) {
		int numer; // numerator of new fraction
		int denom; // denominator of new fraction

		int slash = str.indexOf("/");
		if(slash < 0) { // the string contains only an integer
			numer = Integer.parseInt(str);
			denom = 1;
		} else {
			numer = Integer.parseInt(str.substring(0, slash));
			denom = Integer.parseInt(str.substring(slash + 1));
		}

		return new Fraction(numer, denom);
	}
}
