package csbsju.cs160;

/**
 * Maintains information about the current drawing
 * context. You use this object whenever you wish to
 * draw graphics.
 *
 * In the coordinate system used here, the first
 * coordinate gives the column , and the second
 * coordinate gives the row. The top left pixel
 * of the canvas is (0,0), and coordinates
 * increase as you move right and downward.
 *
 * @author  Carl Burch
 * @version 28 August 2001
 */
public class Graphics {
	private java.awt.Graphics g;
	private javax.swing.JComponent comp;

	Graphics(java.awt.Graphics g, javax.swing.JComponent comp) {
		this.g = g;
		this.comp = comp;
	}
	java.awt.Graphics getGraphics() { return g; }

	/**
	 * Clears the drawing canvas, replacing it with the
	 * current background color.
	 */
	public void clearAll() {
		java.awt.Color cur = g.getColor();
		g.setColor(comp.getBackground());
		g.fillRect(0, 0, comp.getWidth(), comp.getHeight());
		g.setColor(cur);
		comp.repaint();
	}

	/**
	 * Sets the current foreground color for this Graphics
	 * object.
	 */
	public void setColor(Color color) {
		g.setColor(color.getColor());
	}

	/**
	 * Draws a line from the point (<code>x0</code>,
	 * <code>y0</code>) to the point (<code>x1</code>,
	 * <code>y1</code>). (Coordinates are numbered beginning
	 * with (0,0) at the top left corner and increasing down
	 * and to the right.)
	 */
	public void drawLine(int x0, int y0, int x1, int y1) {
		g.drawLine(x0, y0, x1, y1);
		comp.repaint();
	}

	/**
	 * Draws the outline of an oval whose rectangular boundary
	 * begins at the top left corner (<code>x</code>,
	 * <code>y</code>) and extends <code>width</code> pixels
	 * to the right and <code>height</code> pixels down.
	 * (Coordinates are numbered beginning
	 * with (0,0) at the top left corner and increasing down
	 * and to the right.)
	 */
	public void drawOval(int x, int y, int width, int height) {
		g.drawOval(x, y, width, height);
		comp.repaint();
	}

	/**
	 * Draws a filled oval whose rectangular boundary
	 * begins at the top left corner (<code>x</code>,
	 * <code>y</code>) and extends <code>width</code> pixels
	 * to the right and <code>height</code> pixels down.
	 * (Coordinates are numbered beginning
	 * with (0,0) at the top left corner and increasing down
	 * and to the right.)
	 */
	public void fillOval(int x, int y, int width, int height) {
		g.fillOval(x, y, width, height);
		comp.repaint();
	}

	/**
	 * Draws the outline of a rectangle whose top left
	 * corner is at (<code>x</code>,
	 * <code>y</code>) and extends <code>width</code> pixels
	 * to the right and <code>height</code> pixels down.
	 * (Coordinates are numbered beginning
	 * with (0,0) at the top left corner and increasing down
	 * and to the right.)
	 */
	public void drawRect(int x, int y, int width, int height) {
		g.drawRect(x, y, width, height);
		comp.repaint();
	}

	/**
	 * Draws a filled rectangle whose top left
	 * corner is at (<code>x</code>,
	 * <code>y</code>) and extends <code>width</code> pixels
	 * to the right and <code>height</code> pixels down.
	 * (Coordinates are numbered beginning
	 * with (0,0) at the top left corner and increasing down
	 * and to the right.)
	 */
	public void fillRect(int x, int y, int width, int height) {
		g.fillRect(x, y, width, height);
		comp.repaint();
	}

	/**
	 * Draws text into the canvas, with the baseline starting
	 * at the point (<code>x</code>, <code>y</code>) and
	 * proceeding right.
	 * (Coordinates are numbered beginning
	 * with (0,0) at the top left corner and increasing down
	 * and to the right.)
	 */
	public void drawString(String str, int x, int y) {
		g.drawString(str, x, y);
		comp.repaint();
	}
}
