package csbsju.cs160;

import java.io.IOException;

/**
 * Provides a class to represent a file that has been opened
 * for reading.
 *
 * @author  Carl Burch
 * @version 26 Sep 2001
 */
public class InputFile {
	private class InputBuffer {
		public static final String skipchars = " \n\r\t";

		private String buf = null;

		private void getBuffer() throws IOException {
			if(buf != null) return;
			if(reader == null) throw new IOException("file not open");
			buf = reader.readLine();
		}

		private void toNextWord() throws IOException {
			int[] pos = new int[skipchars.length()];
			if(buf != null) {
				// find first occurrence of character not in skipchars
				int i;
				for(i = 0; i < buf.length(); i++) {
					if(skipchars.indexOf(buf.charAt(i)) < 0) break;
				}

				// trim off everything up to this character
				buf = buf.substring(i);
			}
			while(buf == null || buf.equals("")) {
				buf = null;
				getBuffer();

				// find first occurrence of character not in skipchars
				int i;
				for(i = 0; i < buf.length(); i++) {
					if(skipchars.indexOf(buf.charAt(i)) < 0) break;
				}

				// trim off everything up to this character
				buf = buf.substring(i);
			}
		}

		public String getLine() throws IOException {
			if(buf != null && buf.equals("")) buf = null;
			getBuffer();
			String ret = buf;
			buf = null;
			return ret;
		}

		public char getChar() throws IOException {
			getBuffer();
			if(buf.equals("")) {
				buf = null;
				return '\n';
			} else {
				char ret = buf.charAt(0);
				buf = buf.substring(1);
				return ret;
			}
		}

		public String getWord() throws IOException {
			toNextWord();

			int pos = 0;
			while(pos < buf.length()
					&& skipchars.indexOf(buf.charAt(pos)) < 0) {
				++pos;
			}

			String ret = buf.substring(0, pos);
			buf = buf.substring(pos);
			return ret;
		}

		public boolean getBoolean() throws IOException {
			return getWord().equalsIgnoreCase("true");
		}

		public int getInt() throws IOException {
			toNextWord();

			int pos = 0;
			if(pos < buf.length() + 1 && buf.charAt(pos) == '-'
					&& Character.isDigit(buf.charAt(pos + 1))) {
				++pos;
			}
			while(pos < buf.length()
					&& Character.isDigit(buf.charAt(pos))) {
				++pos;
			}

			if(pos == 0) {
				buf = buf.substring(1);
				return Integer.MIN_VALUE;
			} else {
				int ret = Integer.parseInt(buf.substring(0, pos));
				buf = buf.substring(pos);
				return ret;
			}
		}

		public double getDouble() throws IOException {
			toNextWord();

			int last = -1;
			int state = 0;
			for(int pos = 0; pos < buf.length() && state >= 0; pos++) {
				char c = buf.charAt(pos);
				int oldstate = state;
				state = -1;
				switch(oldstate) {
				case 0:
					if(Character.isDigit(c))      state = 2;
					else if(c == '+' || c == '-') state = 1;
					else if(c == '.')             state = 3;
					break;
				case 1:
					if(Character.isDigit(c))      state = 2;
					else if(c == '.')             state = 3;
					break;
				case 2:
					if(Character.isDigit(c))      state = 2;
					else if(c == '.')             state = 4;
					else if(c == 'e' || c == 'E') state = 5;
					break;
				case 3:
					if(Character.isDigit(c))      state = 4;
					break;
				case 4:
					if(Character.isDigit(c))      state = 4;
					else if(c == 'e' || c == 'E') state = 5;
					break;
				case 5:
					if(Character.isDigit(c))      state = 7;
					else if(c == '-' || c == '+') state = 6;
					break;
				case 6:
					if(Character.isDigit(c))      state = 7;
					break;
				case 7:
					if(Character.isDigit(c))      state = 7;
					break;
				}
				if(state == 2 || state == 4 || state == 7) {
					last = pos + 1;
				}
			}

			if(last < 0) {
				buf = buf.substring(1);
				return Double.NaN;
			} else {
				double ret = Double.parseDouble(buf.substring(0, last));
				buf = buf.substring(last);
				return ret;
			}
		}
	}

	private java.io.FileReader file_reader;
	private java.io.BufferedReader reader;
	private InputBuffer buffer = new InputBuffer();

	/**
	 * Opens the file <code>filename</code> for input.
	 */
	public InputFile(String filename) {
		String home_dir = System.getProperty("user.home");

		try {
			java.io.File f = new java.io.File(filename);
			boolean exists = true;
			try {
				exists = f.exists();
			} catch(Exception e) {}
			if(!exists) {
				f = new java.io.File(home_dir, filename);
			}
			file_reader = new java.io.FileReader(f);
			reader = new java.io.BufferedReader(file_reader);
		} catch(IOException e) {
			file_reader = null;
			reader = null;
			if(home_dir == null) {
				throw new Error("Could not open file " + filename + ": "
					+ e.getMessage());
			} else {
				throw new Error("Could not open file " + filename
					+ " in " + home_dir + ": " + e.getMessage());
			}
		}
	}

	/**
	 * Closes the file.
	 */
	public void close() {
		if(file_reader == null) return;
		try {
			file_reader.close();
		} catch(IOException e) { }
		file_reader = null;
		reader = null;
	}

	/**
	 * Returns the next line
	 * found in the file. Any terminating
	 * end-of-line characters are omitted.
	 */
	public String readLine() {
		try {
			return buffer.getLine();
		} catch(IOException e) {
			return null;
		}
	}

	/**
	 * Returns the next
	 * character found in the file. This will be
	 * '\n' when the user reaches the end of a line.
	 */
	public char readChar() {
		try {
			return buffer.getChar();
		} catch(IOException e) {
			return '\0';
		}
	}

	/**
	 * Returns the next
	 * integer found in the file, skipping any
	 * whitespace characters. If the next non-whitespace letters don't
	 * appear to represent an integer, it eats a single
	 * non-whitespace character and returns Integer.MIN_VALUE.
	 */
	public int readInt() {
		try {
			return buffer.getInt();
		} catch(IOException e) {
			return Integer.MIN_VALUE;
		}
	}

	/**
	 * Returns the next
	 * real number found in the file, skipping any
	 * whitespace characters.
	 * It supports both regular doubles (like 6.1 or -4)
	 * and scientific notation (like 3e8).
	 * If the next non-whitespace characters
	 * don't appear to represent a real number, it eats a single
	 * non-whitespace character and returns Double.NaN.
	 */
	public double readDouble() {
		try {
			return buffer.getDouble();
		} catch(IOException e) {
			return Double.NaN;
		}
	}

	/**
	 * Returns the next
	 * Boolean value found in the file, skipping any
	 * whitespace characters. This will be true if the next word
	 * of the file is ``true'' (case is insignificant here).
	 * If the next non-whitespace letters don't appear to represent
	 * a Boolean, it return false.
	 */
	public boolean readBoolean() {
		try {
			return buffer.getBoolean();
		} catch(IOException e) {
			return false;
		}
	}

	/**
	 * Returns the next
	 * string of non-whitespace characters found in the file.
	 */
	public String readString() {
		try {
			return buffer.getWord();
		} catch(IOException e) {
			return null;
		}
	}

}
