/*
 * Decompiled with CFR 0.152.
 */
package csbsju.cs160;

import csbsju.cs160.Color;
import csbsju.cs160.Graphics;
import csbsju.cs160.Pen;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;

public class DrawableFrame {
    private MyFrame frame = null;
    private JMenuBar menubar = new JMenuBar();
    private LinkedList menus = new LinkedList();
    private DrawablePanel panel = null;

    public DrawableFrame() {
        this(200, 200);
    }

    public DrawableFrame(int n, int n2) {
        this.frame = new MyFrame("Drawable Frame");
        this.frame.setJMenuBar(this.menubar);
        JMenu jMenu = new JMenu("File");
        this.menus.add(jMenu);
        this.menubar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem("Quit");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DrawableFrame.this.dispose();
            }
        });
        this.panel = new DrawablePanel(n, n2);
        this.frame.getContentPane().add(this.panel);
        this.frame.pack();
    }

    public int getWidth() {
        return this.panel.getWidth();
    }

    public int getHeight() {
        return this.panel.getHeight();
    }

    public void setBackground(Color color) {
        this.frame.setBackground(color.getColor());
        this.panel.setBackground(color.getColor());
    }

    public Graphics getGraphics() {
        return new Graphics(this.panel.getGraphicsContext(), this.panel);
    }

    public Pen getPen(double d, double d2) {
        return new Pen(this.getGraphics(), d, d2);
    }

    public void mouseDragging(int n, int n2, int n3, int n4) {
    }

    public void mouseDragged(int n, int n2, int n3, int n4) {
    }

    public void keyPressed(char c) {
    }

    public void show() {
        this.frame.pack();
        this.frame.show();
        new Thread(this.frame).start();
        this.panel.grabFocus();
    }

    public void dispose() {
        this.frame.dispose();
    }

    public void setTitle(String string) {
        this.frame.setTitle(string);
    }

    public void addMenu(String string) {
        JMenu jMenu = new JMenu(string);
        this.menus.add(jMenu);
        this.menubar.add(jMenu);
    }

    public void addMenuItem(String string, String string2) {
        FrameMenuItem frameMenuItem = new FrameMenuItem(string2);
        JMenu jMenu = null;
        Iterator iterator = this.menus.iterator();
        while (jMenu == null && iterator.hasNext()) {
            JMenu jMenu2 = (JMenu)iterator.next();
            if (!string.equals(jMenu2.getText())) continue;
            jMenu = jMenu2;
        }
        if (jMenu == null) {
            throw new Error("Menu `" + string + "' doesn't exist.");
        }
        jMenu.add(frameMenuItem);
    }

    public void menuItemSelected(String string) {
    }

    public synchronized void run() {
    }

    private class DrawablePanel
    extends JPanel
    implements MouseListener,
    MouseMotionListener,
    KeyListener {
        Image buffer = null;
        Dimension lastSize = null;
        private int last_x;
        private int last_y;

        public DrawablePanel(int n, int n2) {
            this.setPreferredSize(new Dimension(n, n2));
            this.setBackground(java.awt.Color.white);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.addKeyListener(this);
        }

        public void setBackground(java.awt.Color color) {
            super.setBackground(color);
            this.buffer = null;
        }

        public java.awt.Graphics getGraphicsContext() {
            Dimension dimension = this.getSize();
            if (this.lastSize == null || dimension.width != this.lastSize.width || dimension.height != this.lastSize.height) {
                this.lastSize = new Dimension(dimension);
                Image image = this.createImage(dimension.width, dimension.height);
                java.awt.Graphics graphics = image.getGraphics();
                graphics.setColor(java.awt.Color.white);
                graphics.fillRect(0, 0, dimension.width, dimension.height);
                graphics.setColor(java.awt.Color.black);
                if (this.buffer != null) {
                    graphics.drawImage(this.buffer, 0, 0, null);
                }
                this.buffer = image;
            }
            this.repaint();
            return this.buffer.getGraphics();
        }

        public void paintComponent(java.awt.Graphics graphics) {
            super.paintComponent(graphics);
            Dimension dimension = this.getSize();
            if (this.buffer != null) {
                graphics.drawImage(this.buffer, 0, 0, null);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.grabFocus();
            this.last_x = mouseEvent.getX();
            this.last_y = mouseEvent.getY();
            DrawableFrame.this.mouseDragging(this.last_x, this.last_y, this.last_x, this.last_y);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            DrawableFrame.this.mouseDragged(this.last_x, this.last_y, mouseEvent.getX(), mouseEvent.getY());
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            DrawableFrame.this.mouseDragging(this.last_x, this.last_y, mouseEvent.getX(), mouseEvent.getY());
        }

        public void keyPressed(KeyEvent keyEvent) {
            DrawableFrame.this.keyPressed(keyEvent.getKeyChar());
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }
    }

    private class FrameMenuItem
    extends JMenuItem
    implements ActionListener {
        public FrameMenuItem(String string) {
            super(string);
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DrawableFrame.this.menuItemSelected(this.getText());
        }
    }

    private class MyFrame
    extends JFrame
    implements WindowListener,
    Runnable {
        public MyFrame(String string) {
            super(string);
            this.addWindowListener(this);
            this.setBackground(java.awt.Color.white);
        }

        public void run() {
            DrawableFrame.this.run();
        }

        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowClosed(WindowEvent windowEvent) {
            System.exit(0);
        }

        public void windowClosing(WindowEvent windowEvent) {
            this.dispose();
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowOpened(WindowEvent windowEvent) {
        }
    }
}

