/*
 * Decompiled with CFR 0.152.
 */
package csbsju.cs160;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class EchoConsole {
    private static final boolean DR_JAVA = false;
    private static InputBuffer buffer = new InputBuffer();

    private EchoConsole() {
    }

    public static void print(Object object) {
        System.out.print(object.toString());
        System.out.flush();
    }

    public static void print(int n) {
        EchoConsole.print(Integer.toString(n));
    }

    public static void print(double d) {
        EchoConsole.print(Double.toString(d));
    }

    public static void print(boolean bl) {
        EchoConsole.print("" + bl);
    }

    public static void print(char c) {
        EchoConsole.print("" + c);
    }

    public static void println() {
        System.out.println();
        System.out.flush();
    }

    public static void println(Object object) {
        System.out.println(object.toString());
        System.out.flush();
    }

    public static void println(int n) {
        EchoConsole.println(Integer.toString(n));
    }

    public static void println(double d) {
        EchoConsole.println(Double.toString(d));
    }

    public static void println(boolean bl) {
        EchoConsole.println("" + bl);
    }

    public static void println(char c) {
        EchoConsole.println("" + c);
    }

    public static String readLine() {
        return buffer.getLine();
    }

    public static char readChar() {
        return buffer.getChar();
    }

    public static int readInt() {
        return buffer.getInt();
    }

    public static double readDouble() {
        return buffer.getDouble();
    }

    public static boolean readBoolean() {
        return buffer.getBoolean();
    }

    public static String readString() {
        return buffer.getWord();
    }

    private static class InputBuffer {
        public static final String skipchars = " \n\r\t";
        private BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        private String buf = null;

        private InputBuffer() {
        }

        private void getBuffer() {
            if (this.buf == null) {
                try {
                    this.buf = this.reader.readLine();
                    System.out.println(this.buf);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        private void toNextWord() {
            int n;
            int[] nArray = new int[skipchars.length()];
            if (this.buf != null) {
                n = 0;
                while (n < this.buf.length()) {
                    if (skipchars.indexOf(this.buf.charAt(n)) < 0) break;
                    ++n;
                }
                this.buf = this.buf.substring(n);
            }
            while (this.buf == null || this.buf.equals("")) {
                this.buf = null;
                this.getBuffer();
                n = 0;
                while (n < this.buf.length()) {
                    if (skipchars.indexOf(this.buf.charAt(n)) < 0) break;
                    ++n;
                }
                this.buf = this.buf.substring(n);
            }
        }

        public String getLine() {
            if (this.buf != null && this.buf.equals("")) {
                this.buf = null;
            }
            this.getBuffer();
            String string = this.buf;
            this.buf = null;
            return string;
        }

        public char getChar() {
            this.getBuffer();
            if (this.buf.equals("")) {
                this.buf = null;
                return '\n';
            }
            char c = this.buf.charAt(0);
            this.buf = this.buf.substring(1);
            return c;
        }

        public String getWord() {
            this.toNextWord();
            int n = 0;
            while (n < this.buf.length() && skipchars.indexOf(this.buf.charAt(n)) < 0) {
                ++n;
            }
            String string = this.buf.substring(0, n);
            this.buf = this.buf.substring(n);
            return string;
        }

        public boolean getBoolean() {
            return this.getWord().equalsIgnoreCase("true");
        }

        public int getInt() {
            this.toNextWord();
            int n = 0;
            if (n < this.buf.length() + 1 && this.buf.charAt(n) == '-' && Character.isDigit(this.buf.charAt(n + 1))) {
                ++n;
            }
            while (n < this.buf.length() && Character.isDigit(this.buf.charAt(n))) {
                ++n;
            }
            if (n == 0) {
                this.buf = this.buf.substring(1);
                return Integer.MIN_VALUE;
            }
            int n2 = Integer.parseInt(this.buf.substring(0, n));
            this.buf = this.buf.substring(n);
            return n2;
        }

        public double getDouble() {
            this.toNextWord();
            int n = -1;
            int n2 = 0;
            int n3 = 0;
            while (n3 < this.buf.length() && n2 >= 0) {
                char c = this.buf.charAt(n3);
                int n4 = n2;
                n2 = -1;
                switch (n4) {
                    case 0: {
                        if (Character.isDigit(c)) {
                            n2 = 2;
                            break;
                        }
                        if (c == '+' || c == '-') {
                            n2 = 1;
                            break;
                        }
                        if (c != '.') break;
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        if (Character.isDigit(c)) {
                            n2 = 2;
                            break;
                        }
                        if (c != '.') break;
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        if (Character.isDigit(c)) {
                            n2 = 2;
                            break;
                        }
                        if (c == '.') {
                            n2 = 4;
                            break;
                        }
                        if (c != 'e' && c != 'E') break;
                        n2 = 5;
                        break;
                    }
                    case 3: {
                        if (!Character.isDigit(c)) break;
                        n2 = 4;
                        break;
                    }
                    case 4: {
                        if (Character.isDigit(c)) {
                            n2 = 4;
                            break;
                        }
                        if (c != 'e' && c != 'E') break;
                        n2 = 5;
                        break;
                    }
                    case 5: {
                        if (Character.isDigit(c)) {
                            n2 = 7;
                            break;
                        }
                        if (c != '-' && c != '+') break;
                        n2 = 6;
                        break;
                    }
                    case 6: {
                        if (!Character.isDigit(c)) break;
                        n2 = 7;
                        break;
                    }
                    case 7: {
                        if (!Character.isDigit(c)) break;
                        n2 = 7;
                    }
                }
                if (n2 == 2 || n2 == 4 || n2 == 7) {
                    n = n3 + 1;
                }
                ++n3;
            }
            if (n < 0) {
                this.buf = this.buf.substring(1);
                return Double.NaN;
            }
            double d = Double.parseDouble(this.buf.substring(0, n));
            this.buf = this.buf.substring(n);
            return d;
        }
    }
}

