/*
 * Decompiled with CFR 0.152.
 */
package csbsju.cs160;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class InputFile {
    private FileReader file_reader;
    private BufferedReader reader;
    private InputBuffer buffer = new InputBuffer();

    public InputFile(String string) {
        String string2 = System.getProperty("user.home");
        try {
            File file = new File(string);
            boolean bl = true;
            try {
                bl = file.exists();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!bl) {
                file = new File(string2, string);
            }
            this.file_reader = new FileReader(file);
            this.reader = new BufferedReader(this.file_reader);
        }
        catch (IOException iOException) {
            this.file_reader = null;
            this.reader = null;
            if (string2 == null) {
                throw new Error("Could not open file " + string + ": " + iOException.getMessage());
            }
            throw new Error("Could not open file " + string + " in " + string2 + ": " + iOException.getMessage());
        }
    }

    public void close() {
        if (this.file_reader == null) {
            return;
        }
        try {
            this.file_reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.file_reader = null;
        this.reader = null;
    }

    public String readLine() {
        try {
            return this.buffer.getLine();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public char readChar() {
        try {
            return this.buffer.getChar();
        }
        catch (IOException iOException) {
            return '\u0000';
        }
    }

    public int readInt() {
        try {
            return this.buffer.getInt();
        }
        catch (IOException iOException) {
            return Integer.MIN_VALUE;
        }
    }

    public double readDouble() {
        try {
            return this.buffer.getDouble();
        }
        catch (IOException iOException) {
            return Double.NaN;
        }
    }

    public boolean readBoolean() {
        try {
            return this.buffer.getBoolean();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public String readString() {
        try {
            return this.buffer.getWord();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private class InputBuffer {
        public static final String skipchars = " \n\r\t";
        private String buf = null;

        private InputBuffer() {
        }

        private void getBuffer() throws IOException {
            if (this.buf != null) {
                return;
            }
            if (InputFile.this.reader == null) {
                throw new IOException("file not open");
            }
            this.buf = InputFile.this.reader.readLine();
        }

        private void toNextWord() throws IOException {
            int n;
            int[] nArray = new int[skipchars.length()];
            if (this.buf != null) {
                n = 0;
                while (n < this.buf.length()) {
                    if (skipchars.indexOf(this.buf.charAt(n)) < 0) break;
                    ++n;
                }
                this.buf = this.buf.substring(n);
            }
            while (this.buf == null || this.buf.equals("")) {
                this.buf = null;
                this.getBuffer();
                n = 0;
                while (n < this.buf.length()) {
                    if (skipchars.indexOf(this.buf.charAt(n)) < 0) break;
                    ++n;
                }
                this.buf = this.buf.substring(n);
            }
        }

        public String getLine() throws IOException {
            if (this.buf != null && this.buf.equals("")) {
                this.buf = null;
            }
            this.getBuffer();
            String string = this.buf;
            this.buf = null;
            return string;
        }

        public char getChar() throws IOException {
            this.getBuffer();
            if (this.buf.equals("")) {
                this.buf = null;
                return '\n';
            }
            char c = this.buf.charAt(0);
            this.buf = this.buf.substring(1);
            return c;
        }

        public String getWord() throws IOException {
            this.toNextWord();
            int n = 0;
            while (n < this.buf.length() && skipchars.indexOf(this.buf.charAt(n)) < 0) {
                ++n;
            }
            String string = this.buf.substring(0, n);
            this.buf = this.buf.substring(n);
            return string;
        }

        public boolean getBoolean() throws IOException {
            return this.getWord().equalsIgnoreCase("true");
        }

        public int getInt() throws IOException {
            this.toNextWord();
            int n = 0;
            if (n < this.buf.length() + 1 && this.buf.charAt(n) == '-' && Character.isDigit(this.buf.charAt(n + 1))) {
                ++n;
            }
            while (n < this.buf.length() && Character.isDigit(this.buf.charAt(n))) {
                ++n;
            }
            if (n == 0) {
                this.buf = this.buf.substring(1);
                return Integer.MIN_VALUE;
            }
            int n2 = Integer.parseInt(this.buf.substring(0, n));
            this.buf = this.buf.substring(n);
            return n2;
        }

        public double getDouble() throws IOException {
            this.toNextWord();
            int n = -1;
            int n2 = 0;
            int n3 = 0;
            while (n3 < this.buf.length() && n2 >= 0) {
                char c = this.buf.charAt(n3);
                int n4 = n2;
                n2 = -1;
                switch (n4) {
                    case 0: {
                        if (Character.isDigit(c)) {
                            n2 = 2;
                            break;
                        }
                        if (c == '+' || c == '-') {
                            n2 = 1;
                            break;
                        }
                        if (c != '.') break;
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        if (Character.isDigit(c)) {
                            n2 = 2;
                            break;
                        }
                        if (c != '.') break;
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        if (Character.isDigit(c)) {
                            n2 = 2;
                            break;
                        }
                        if (c == '.') {
                            n2 = 4;
                            break;
                        }
                        if (c != 'e' && c != 'E') break;
                        n2 = 5;
                        break;
                    }
                    case 3: {
                        if (!Character.isDigit(c)) break;
                        n2 = 4;
                        break;
                    }
                    case 4: {
                        if (Character.isDigit(c)) {
                            n2 = 4;
                            break;
                        }
                        if (c != 'e' && c != 'E') break;
                        n2 = 5;
                        break;
                    }
                    case 5: {
                        if (Character.isDigit(c)) {
                            n2 = 7;
                            break;
                        }
                        if (c != '-' && c != '+') break;
                        n2 = 6;
                        break;
                    }
                    case 6: {
                        if (!Character.isDigit(c)) break;
                        n2 = 7;
                        break;
                    }
                    case 7: {
                        if (!Character.isDigit(c)) break;
                        n2 = 7;
                    }
                }
                if (n2 == 2 || n2 == 4 || n2 == 7) {
                    n = n3 + 1;
                }
                ++n3;
            }
            if (n < 0) {
                this.buf = this.buf.substring(1);
                return Double.NaN;
            }
            double d = Double.parseDouble(this.buf.substring(0, n));
            this.buf = this.buf.substring(n);
            return d;
        }
    }
}

