/*
 * Decompiled with CFR 0.152.
 */
package csbsju.cs160;

import csbsju.cs160.Color;
import csbsju.cs160.Graphics;

public class Pen {
    private Graphics g;
    private Color color = Color.black;
    private boolean pen_down = true;
    private double cur_x = 0.0;
    private double cur_y = 0.0;
    private double angle = 0.0;

    public Pen(Graphics graphics, double d, double d2) {
        this.g = graphics;
        this.cur_x = d;
        this.cur_y = d2;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void moveTo(double d, double d2) {
        this.cur_x = d;
        this.cur_y = d2;
    }

    public void lineTo(double d, double d2) {
        this.g.setColor(this.color);
        this.g.drawLine(this.round(this.cur_x), this.round(this.cur_y), this.round(d), this.round(d2));
        this.cur_x = d;
        this.cur_y = d2;
    }

    public void forward(double d) {
        if (this.pen_down) {
            this.lineTo(this.cur_x + d * Math.cos(this.angle), this.cur_y - d * Math.sin(this.angle));
        } else {
            this.moveTo(this.cur_x + d * Math.cos(this.angle), this.cur_y - d * Math.sin(this.angle));
        }
    }

    public void turnLeft(double d) {
        this.angle += d * Math.PI / 180.0;
    }

    public void turnRight(double d) {
        this.angle -= d * Math.PI / 180.0;
    }

    public void raisePen() {
        this.pen_down = false;
    }

    public void lowerPen() {
        this.pen_down = true;
    }

    private int round(double d) {
        return (int)(d + 0.5);
    }
}

