/*
 * HtmlTagFactory.java is a generated file. You should edit
 * HtmlTagFactory.lex and use JFlex to generate HtmlTagFactory.java.
 * <a href=http://jflex.de>JFlex</a> is available at
 * <a href=http://jflex.de><em>http://jflex.de/</em></a>.
 */
 
/**
 * Implements a scanner for parsing an HTML tag. This is for use
 * within HtmlTag only.
 *
 * @author Carl Burch
 * @version 0.1 2005-05-31
 */

package com.cburch.editor.scanners;

import java.io.IOException;
import java.io.StringReader;

%%

%class HtmlTagFactory
%function nextToken
%type Object

%unicode
%char

%{
	/**
	 * Parses the given text and returns an object containing
	 * all relevant information for the tag. This is the only method
	 * that should be used within this class.
	 *
	 * @param text  the text containing the HTML tag.
	 * @return a newly created tag containing all related information.
	 */
	public static HtmlTag create(String text) {
		HtmlTag dest = new HtmlTag();
		
		// ensure that we are enclosed with angle brackets
		text = text.trim();
		if(text.charAt(0) != '<') {
			dest.setError("Tag must begin with \"<\".");
			return dest;
		}
		if(text.charAt(text.length() - 1) != '>') {
			dest.setError("Tag must end with \">\".");
			return dest;
		}
		
		// take off the initial and final slashes if present
		int start = 1;
		int stop = text.length() - 1;
		if(text.charAt(1) == '/') {
			dest.setStartTag(false);
			dest.setEndTag(true);
			start = 2;
		} else if(text.charAt(stop - 1) == '/') {
			dest.setEndTag(true);
			stop--;
		}

		// trim off the angle brackets and parse		
		StringReader reader = new StringReader(text.substring(start, stop));
		HtmlTagFactory scanner = new HtmlTagFactory(reader);
		scanner.tag = dest;
		try {
			scanner.nextToken();
		} catch(IOException e) { }
		return dest;
	}
	
	/** The tag where we should store all of our information. */
	private HtmlTag tag;
	
	/** The current attribute we are parsing, used within the
	 * ATTRIBUTE_VALUE state so that we know to what attribute
	 * to assign the value seen. */
	private String curAttribute = null;
%}

%state ATTRIBUTE_VALUE

Whitespace=([\ \n\t\r\f])

%%

<YYINITIAL> ([:letter:]+) {
	// If we haven't seen the name yet, this is the name;
	// otherwise it is an attribute.
	if(tag.getName() == null) {
		tag.setName(yytext());
	} else {
		if(!tag.isStartTag()) tag.setError("Ending tag cannot have attributes.");
		curAttribute = yytext();
		tag.addAttribute(curAttribute);
	}
}

<YYINITIAL> ("=") {
	if(curAttribute == null) tag.setError("Cannot use \"=\" without an attribute name before it.");
	else yybegin(ATTRIBUTE_VALUE);
}

<ATTRIBUTE_VALUE> (\"[^\"]*\"|\'[^\']*\') {
	String text = yytext();
	tag.setAttribute(curAttribute, text.substring(1, text.length() - 1));
	curAttribute = null;
	yybegin(YYINITIAL);
}

<ATTRIBUTE_VALUE> (([a-zA-Z0-9\-\.\_\:])+) {
	tag.setAttribute(curAttribute, yytext());
	curAttribute = null;
	yybegin(YYINITIAL);
}

<YYINITIAL, ATTRIBUTE_VALUE> ({Whitespace}) { }

<YYINITIAL> . {
	tag.setError("Unrecognized character: " + yytext() + ".");
}
<ATTRIBUTE_VALUE> . {
	tag.setError("Unrecognized character for attribute value: " + yytext() + ".");
}