/*
 * Copyright (c) 2005, Carl Burch.
 * 
 * This file is part of the com.cburch.editor package. The latest
 * version is available at http://www.cburch.com/proj/editor/.
 *
 * The com.cburch.editor package is free software; you can redistribute
 * it and/or modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * The com.cburch.editor package is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the com.cburch.editor package; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */
 
 package com.cburch.editor.demo;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

import com.cburch.editor.EditorPanel;

/**
 * Implements the Help menu.
 * 
 * @author Carl Burch
 * @version 0.1 2005-05-31
 */
class HelpMenu extends JMenu {
    /** Listens for user selections of menu items. */
    private class MyListener implements ActionListener {
        public void actionPerformed(ActionEvent event) {
            Object source = event.getSource();
            if(source == about) {
                doAbout();
            }
        }
    }
    
    private EditorPanel editorPanel;
    private MyListener myListener = new MyListener();
    private JMenuItem about = new JMenuItem("About...");

    /**
     * Constructs the Help menu.
     * 
     * @param editorPanel  the editor this menu is controlling.
     */
    public HelpMenu(EditorPanel editorPanel) {
        super("Help");
        this.editorPanel = editorPanel;
        
        add(about);   about.addActionListener(myListener);
    }
    
    /** Displays a dialog talking about this program. */
    private void doAbout() {
        JTextArea text = new JTextArea(
                "Copyright (c) 2005, Carl Burch." +
                "\n\n" +
                "This program demonstrates the capabilities of the com.cburch.editor " +
                "package. You can extract the code and accompanying Javadocs from the " +
                "distributed JAR file. The latest version is available at " +
                "http://www.cburch.com/proj/editor/." +
                "\n\n" +
                "The com.cburch.editor package is free software; you can redistribute " +
                "it and/or modify it under the terms of the GNU General Public License " +
                "as published by the Free Software Foundation; either version 2 of the " +
                "License, or (at your option) any later version." +
                "\n\n" +
                "The com.cburch.editor package is distributed in the hope that it will " +
                "be useful, but WITHOUT ANY WARRANTY; without even the implied warranty " +
                "of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the " +
                "GNU General Public License for more details." +
                "\n\n" +
                "You should have received a copy of the GNU General Public License " +
                "along with the com.cburch.editor package; if not, write to the Free " +
                "Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA " +
                "02110-1301  USA");
        text.setLineWrap(true);
        text.setWrapStyleWord(true);
        text.setEditable(false);
        
        JScrollPane pane = new JScrollPane(text);
        pane.setPreferredSize(new Dimension(400, 250));
                 
        JOptionPane.showMessageDialog(editorPanel,
                pane,
                Main.VERSION,
                JOptionPane.PLAIN_MESSAGE);
    }
}
