/*
 * Copyright (c) 2005, Carl Burch.
 * 
 * This file is part of the com.cburch.editor package. The latest
 * version is available at http://www.cburch.com/proj/editor/.
 *
 * The com.cburch.editor package is free software; you can redistribute
 * it and/or modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * The com.cburch.editor package is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the com.cburch.editor package; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */
 
 package com.cburch.editor.demo;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.WindowConstants;

import com.cburch.editor.EditorPanel;

/**
 * Shows a window that demonstrates all of the capabilities of the
 * <code>com.cburch.editor</code> package.
 * 
 * @author Carl Burch
 * @version 0.1 2005-05-31
 */
public class Main extends JFrame {
    /** Contains the version number for this program. */
    public static final String VERSION = "Editor 0.1.1";
    
    /** Listens for actions with the window. */
    private class MyListener extends WindowAdapter {
        /** Clickin the close box is treated like a Quit request. */
        public void windowClosing(WindowEvent e) {
            if(fileMenu.confirmClose("Quit")) {
                System.exit(0);
            }
        }
        /** Bring focus into the editor whenever window is activated. */
        public void windowActivated(WindowEvent e) {
            editorPanel.getEditor().requestFocus();
        }
    }

    /** The File menu. */
    private FileMenu fileMenu;

    /** The Edit menu. */
    private EditMenu editMenu;
    
    /** The Options menu. */
    private OptionsMenu optionsMenu;
    
    /** The Help menu. */
    private HelpMenu helpMenu;

    /** The panel containing the editor. */
    private EditorPanel editorPanel = new EditorPanel();

    /**
     * Constructs a new window containing the editor.
     */
    public Main() {
        // initial set up that sets the title
        super("Programmers' Editor");
        setDefaultCloseOperation(WindowConstants.DO_NOTHING_ON_CLOSE);
        addWindowListener(new MyListener());

        JMenuBar menubar = new JMenuBar();
        fileMenu    = new FileMenu(editorPanel);    menubar.add(fileMenu);
        editMenu    = new EditMenu(editorPanel);    menubar.add(editMenu);
        optionsMenu = new OptionsMenu(editorPanel); menubar.add(optionsMenu);
        helpMenu    = new HelpMenu(editorPanel);    menubar.add(helpMenu);
        setJMenuBar(menubar);

        // Add the editor into the frame.
        editorPanel.setPreferredSize(new Dimension(620, 460));
        editorPanel.getEditor().setFont(new Font("Monospaced", 0, 16));
        editorPanel.getEditor().setErrorToolTipsEnabled(true);
        getContentPane().add(editorPanel);
    }

    /**
     * Displays the editor window and leaves it for the user to
     * interact with.
     * 
     * @param args  ignored
     */
    public static void main(String[] args) {
        Main frame = new Main();
        frame.pack();
        frame.setVisible(true);
    }
}
