/*
 * Copyright (c) 2005, Carl Burch.
 * 
 * This file is part of the com.cburch.editor package. The latest
 * version is available at http://www.cburch.com/proj/editor/.
 *
 * The com.cburch.editor package is free software; you can redistribute
 * it and/or modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * The com.cburch.editor package is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the com.cburch.editor package; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */
 
 /* The following code was generated by JFlex 1.4.1 on 7/5/05 8:15 AM */

/*
 * HtmlLexer is a generated file. You should edit HtmlLexer
 * and use JFlex to generate HtmlLexer.
 * <a href=http://jflex.de>JFlex</a> is available at
 * <a href=http://jflex.de><em>http://jflex.de/</em></a>.
 */
 
/*
 * This file is loosely based on Stephen Ostermiller's
 * <a href=http://ostermiller.org/syntax/>syntax highlighting package</a>
 * at <a href=http://ostermiller.org/syntax/><em>http://ostermiller.org/syntax/</em></a>.
 * My changes may well have introduced errors that Ostermiller did not
 * have. -Carl Burch 
 */
 
/**
 * Implements a scanner for retrieving HTML tokens from a
 * stream.
 *
 * @author Carl Burch
 * @version 0.1 2005-05-31
 */

package com.cburch.editor.scanners;

import java.io.Reader;
import java.io.StringReader;

import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.BadLocationException;

import com.cburch.editor.Token;
import com.cburch.editor.Scanner;
import com.cburch.editor.util.DocumentReader;


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.1
 * on 7/5/05 8:15 AM from the specification file
 * <tt>HtmlScanner.lex</tt>
 */
public class HtmlScanner implements Scanner<Token> {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int ANCHOR = 1;
  public static final int YYINITIAL = 0;

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\2\1\1\0\2\1\22\0\1\1\1\6\1\3\1\14\2\0"+
    "\1\12\1\2\5\0\1\7\2\0\12\10\1\0\1\16\1\5\1\0"+
    "\1\4\2\0\6\11\21\13\1\15\2\13\6\0\6\11\21\13\1\15"+
    "\2\13\57\0\1\13\12\0\1\13\4\0\1\13\5\0\27\13\1\0"+
    "\37\13\1\0\u013f\13\31\0\162\13\4\0\14\13\16\0\5\13\11\0"+
    "\1\13\213\0\1\13\13\0\1\13\1\0\3\13\1\0\1\13\1\0"+
    "\24\13\1\0\54\13\1\0\46\13\1\0\5\13\4\0\202\13\10\0"+
    "\105\13\1\0\46\13\2\0\2\13\6\0\20\13\41\0\46\13\2\0"+
    "\1\13\7\0\47\13\110\0\33\13\5\0\3\13\56\0\32\13\5\0"+
    "\13\13\25\0\12\10\4\0\2\13\1\0\143\13\1\0\1\13\17\0"+
    "\2\13\7\0\2\13\12\10\3\13\2\0\1\13\20\0\1\13\1\0"+
    "\36\13\35\0\3\13\60\0\46\13\13\0\1\13\u0152\0\66\13\3\0"+
    "\1\13\22\0\1\13\7\0\12\13\4\0\12\10\25\0\10\13\2\0"+
    "\2\13\2\0\26\13\1\0\7\13\1\0\1\13\3\0\4\13\3\0"+
    "\1\13\36\0\2\13\1\0\3\13\4\0\12\10\2\13\23\0\6\13"+
    "\4\0\2\13\2\0\26\13\1\0\7\13\1\0\2\13\1\0\2\13"+
    "\1\0\2\13\37\0\4\13\1\0\1\13\7\0\12\10\2\0\3\13"+
    "\20\0\11\13\1\0\3\13\1\0\26\13\1\0\7\13\1\0\2\13"+
    "\1\0\5\13\3\0\1\13\22\0\1\13\17\0\2\13\4\0\12\10"+
    "\25\0\10\13\2\0\2\13\2\0\26\13\1\0\7\13\1\0\2\13"+
    "\1\0\5\13\3\0\1\13\36\0\2\13\1\0\3\13\4\0\12\10"+
    "\1\0\1\13\21\0\1\13\1\0\6\13\3\0\3\13\1\0\4\13"+
    "\3\0\2\13\1\0\1\13\1\0\2\13\3\0\2\13\3\0\3\13"+
    "\3\0\10\13\1\0\3\13\55\0\11\10\25\0\10\13\1\0\3\13"+
    "\1\0\27\13\1\0\12\13\1\0\5\13\46\0\2\13\4\0\12\10"+
    "\25\0\10\13\1\0\3\13\1\0\27\13\1\0\12\13\1\0\5\13"+
    "\3\0\1\13\40\0\1\13\1\0\2\13\4\0\12\10\25\0\10\13"+
    "\1\0\3\13\1\0\27\13\1\0\20\13\46\0\2\13\4\0\12\10"+
    "\25\0\22\13\3\0\30\13\1\0\11\13\1\0\1\13\2\0\7\13"+
    "\72\0\60\13\1\0\2\13\14\0\7\13\11\0\12\10\47\0\2\13"+
    "\1\0\1\13\2\0\2\13\1\0\1\13\2\0\1\13\6\0\4\13"+
    "\1\0\7\13\1\0\3\13\1\0\1\13\1\0\1\13\2\0\2\13"+
    "\1\0\4\13\1\0\2\13\11\0\1\13\2\0\5\13\1\0\1\13"+
    "\11\0\12\10\2\0\2\13\42\0\1\13\37\0\12\10\26\0\10\13"+
    "\1\0\42\13\35\0\4\13\164\0\42\13\1\0\5\13\1\0\2\13"+
    "\25\0\12\10\6\0\6\13\112\0\46\13\12\0\51\13\7\0\132\13"+
    "\5\0\104\13\5\0\122\13\6\0\7\13\1\0\77\13\1\0\1\13"+
    "\1\0\4\13\2\0\7\13\1\0\1\13\1\0\4\13\2\0\47\13"+
    "\1\0\1\13\1\0\4\13\2\0\37\13\1\0\1\13\1\0\4\13"+
    "\2\0\7\13\1\0\1\13\1\0\4\13\2\0\7\13\1\0\7\13"+
    "\1\0\27\13\1\0\37\13\1\0\1\13\1\0\4\13\2\0\7\13"+
    "\1\0\47\13\1\0\23\13\16\0\11\10\56\0\125\13\14\0\u026c\13"+
    "\2\0\10\13\12\0\32\13\5\0\113\13\25\0\15\13\1\0\4\13"+
    "\16\0\22\13\16\0\22\13\16\0\15\13\1\0\3\13\17\0\64\13"+
    "\43\0\1\13\4\0\1\13\3\0\12\10\46\0\12\10\6\0\130\13"+
    "\10\0\51\13\127\0\35\13\51\0\12\10\36\13\2\0\5\13\u038b\0"+
    "\154\13\224\0\234\13\4\0\132\13\6\0\26\13\2\0\6\13\2\0"+
    "\46\13\2\0\6\13\2\0\10\13\1\0\1\13\1\0\1\13\1\0"+
    "\1\13\1\0\37\13\2\0\65\13\1\0\7\13\1\0\1\13\3\0"+
    "\3\13\1\0\7\13\3\0\4\13\2\0\6\13\4\0\15\13\5\0"+
    "\3\13\1\0\7\13\164\0\1\13\15\0\1\13\202\0\1\13\4\0"+
    "\1\13\2\0\12\13\1\0\1\13\3\0\5\13\6\0\1\13\1\0"+
    "\1\13\1\0\1\13\1\0\4\13\1\0\3\13\1\0\7\13\3\0"+
    "\3\13\5\0\5\13\u0ebb\0\2\13\52\0\5\13\5\0\2\13\4\0"+
    "\126\13\6\0\3\13\1\0\132\13\1\0\4\13\5\0\50\13\4\0"+
    "\136\13\21\0\30\13\70\0\20\13\u0200\0\u19b6\13\112\0\u51a6\13\132\0"+
    "\u048d\13\u0773\0\u2ba4\13\u215c\0\u012e\13\2\0\73\13\225\0\7\13\14\0"+
    "\5\13\5\0\1\13\1\0\12\13\1\0\15\13\1\0\5\13\1\0"+
    "\1\13\1\0\2\13\1\0\2\13\1\0\154\13\41\0\u016b\13\22\0"+
    "\100\13\2\0\66\13\50\0\14\13\164\0\5\13\1\0\207\13\23\0"+
    "\12\10\7\0\32\13\6\0\32\13\13\0\131\13\3\0\6\13\2\0"+
    "\6\13\2\0\6\13\2\0\3\13\43\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\1\1\1\2\1\1\1\3\1\4\1\2\1\4\1\0"+
    "\1\3\2\0\1\5\1\3\3\4\1\0\2\4\2\0"+
    "\1\3\1\4\1\6\2\4\2\0\2\4\2\0\1\7"+
    "\1\4\2\0\1\4\1\0\3\7\1\3\4\0\4\7"+
    "\3\10";

  private static int [] zzUnpackAction() {
    int [] result = new int[53];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\17\0\36\0\55\0\74\0\113\0\132\0\151"+
    "\0\170\0\207\0\226\0\245\0\264\0\303\0\322\0\341"+
    "\0\360\0\377\0\u010e\0\u011d\0\u012c\0\u013b\0\u014a\0\245"+
    "\0\u0159\0\u0168\0\u0177\0\u0186\0\u0195\0\u01a4\0\u01b3\0\u01c2"+
    "\0\u01d1\0\u01e0\0\u01ef\0\u01fe\0\u020d\0\u021c\0\u022b\0\u023a"+
    "\0\u0249\0\u0258\0\u0267\0\u0276\0\u0285\0\u0294\0\u02a3\0\u02b2"+
    "\0\u02c1\0\u02d0\0\245\0\207\0\226";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[53];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\5\3\1\4\4\3\1\5\4\3\5\6\1\4\4\6"+
    "\1\7\4\6\5\3\1\0\4\3\1\10\4\3\2\11"+
    "\1\12\1\13\1\14\1\11\1\15\10\11\11\16\1\17"+
    "\1\16\1\17\1\20\1\17\1\0\5\6\1\0\4\6"+
    "\1\21\4\6\11\16\1\22\1\16\1\22\1\23\1\22"+
    "\12\0\1\24\1\0\1\24\1\25\1\24\1\0\2\11"+
    "\1\12\1\13\1\14\12\11\2\12\1\11\14\12\3\13"+
    "\1\11\13\13\17\0\2\11\1\12\1\13\1\14\2\11"+
    "\1\26\7\11\16\27\1\30\11\27\1\17\1\27\1\17"+
    "\1\27\1\17\1\3\10\27\1\31\4\27\1\32\1\30"+
    "\11\0\1\33\1\0\1\33\1\34\1\33\1\0\11\27"+
    "\1\22\1\27\1\22\1\27\1\22\1\6\10\27\1\35"+
    "\4\27\1\36\1\30\11\0\1\24\1\0\1\24\1\0"+
    "\1\24\1\3\10\0\1\37\4\0\1\40\1\0\2\11"+
    "\1\12\1\13\1\14\2\11\1\41\7\11\16\27\1\0"+
    "\10\27\1\31\5\27\1\3\10\27\2\42\4\27\12\0"+
    "\1\33\1\0\1\33\1\0\1\33\1\6\10\0\1\43"+
    "\4\0\1\44\1\0\10\27\1\35\5\27\1\6\10\27"+
    "\2\45\4\27\11\0\1\37\5\0\1\3\10\0\2\46"+
    "\5\0\2\41\1\47\1\50\1\51\2\41\1\52\7\41"+
    "\10\27\2\42\4\27\1\3\10\0\1\43\5\0\1\6"+
    "\10\0\2\53\5\0\10\27\2\45\4\27\1\6\10\0"+
    "\2\46\4\0\1\3\2\47\1\41\4\47\1\54\7\47"+
    "\3\50\1\41\3\50\1\55\7\50\7\51\1\56\7\51"+
    "\2\41\1\47\1\50\1\51\2\41\1\57\7\41\10\0"+
    "\2\53\4\0\1\6\2\47\1\41\4\47\1\60\7\47"+
    "\3\50\1\41\3\50\1\61\7\50\7\51\1\62\7\51"+
    "\1\11\1\57\1\12\1\13\1\63\12\11\1\12\1\60"+
    "\1\11\1\12\1\64\12\12\1\13\1\61\1\13\1\11"+
    "\1\65\12\13\1\0\1\62\2\0\1\63\12\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[735];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\7\1\1\0\1\1\2\0\1\11\4\1\1\0\2\1"+
    "\2\0\2\1\1\11\2\1\2\0\2\1\2\0\2\1"+
    "\2\0\1\1\1\0\4\1\4\0\4\1\1\11\2\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[53];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the textposition at the last state to be included in yytext */
  private int zzPushbackPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /* user code: */
    /**
     * Represents a token from an HTML file. Because the scanner has state,
     * we need each token to remember that state so that the scanner can
     * be reset to that token appropriately.
     */
    private static class HtmlToken extends Token {
        // Because the HtmlScanner uses state, we'll need to store
        // that information within each token.
        private int state;
        
        public HtmlToken(HtmlTokenType type, Position offset, String text,
                int state, Object data) {
            super(type, offset, text, data);
            this.state = state;
        }
        
        public HtmlToken(HtmlTokenType type, Position offset, String text,
                int state) {
            super(type, offset, text);
            this.state = state;
        }
        
        // We also need the state to be taken into account in
        // testing for equality, so that the tokenizer won't stop
        // on a similar token if it has a different state.
        public boolean equals(Object other) {
            if(!(other instanceof HtmlToken)) return false;
            return super.equals(other)
                && this.state == ((HtmlToken) other).state;
        }
    }

    /**
     * Remembers the current document being edited.
     */
    private Document document = null;
    
    /**
     * Constructs an HtmlScanner reading a null document. This
     * null document will never be used; the tokenizer will always
     * initialize the reader through a <code>reset</code> method
     * before ever reading any tokens.
     */
    public HtmlScanner() {
        this(new StringReader(""));
    }

    public void reset(Reader reader, Token token) {
        if(reader instanceof DocumentReader) {
            document = ((DocumentReader) reader).getDocument();
        } else {
            document = null;
        }
        HtmlToken ht = (HtmlToken) token;
        yyreset(reader);
        this.yychar = ht.getEndOffset();
        yybegin(ht.state);
    }
    
    public void reset(Reader reader) {
        if(reader instanceof DocumentReader) {
            document = ((DocumentReader) reader).getDocument();
        } else {
            document = null;
        }
        yyreset(reader);
    }

    /**
     * Creates a token for the given type. This simplifies
     * the code for handling individual tokens.
     *
     * @param type  the type to associate with the created token.
     * @return the created token.
     */
    private HtmlToken token(HtmlTokenType type) {
        String text = yytext();
        int endOffs = yychar + text.length();
        
        Position pos = null;
        if(document != null) {
            try { pos = document.createPosition(endOffs); } catch(BadLocationException e) { }
        }
        return new HtmlToken(type, pos, text, yystate());
    }
    
    /**
     * Creates a token for the given type. This simplifies
     * the code for handling individual tokens.
     *
     * @param type  the type to associate with the created token.
     * @param data  the data to associate with the created token.
     * @return the created token.
     */
    private HtmlToken token(HtmlTokenType type, Object data) {
        String text = yytext();
        int endOffs = yychar + text.length();
        
        Position pos = null;
        if(document != null) {
            try { pos = document.createPosition(endOffs); } catch(BadLocationException e) { }
        }
        return new HtmlToken(type, pos, text, yystate(), data);
    }
    
    /**
     * Creates an error token with the given error message associated
     * with it.
     *
     * @param message  the error message to associate with the token.
     * @return the created token
     */
    private HtmlToken errorToken(String message) {
        HtmlToken ret = token(HtmlTokenType.ERROR);
        ret.setErrorMessage(message);
        return ret;
    }


  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public HtmlScanner(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public HtmlScanner(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 1232) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzPushbackPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead < 0) {
      return true;
    }
    else {
      zzEndRead+= numRead;
      return false;
    }
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = zzPushbackPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public HtmlToken nextToken() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      yychar+= zzMarkedPosL-zzStartRead;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = zzLexicalState;


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 7: 
          { return errorToken("Comment must be closed with \"-->\".");
          }
        case 9: break;
        case 4: 
          { return errorToken("Character reference must be closed with \";\".");
          }
        case 10: break;
        case 1: 
          { return token(HtmlTokenType.TEXT);
          }
        case 11: break;
        case 2: 
          { return token(HtmlTokenType.ANCHOR_TEXT);
          }
        case 12: break;
        case 3: 
          { return errorToken("Tag must be closed with \">\".");
          }
        case 13: break;
        case 8: 
          { return token(HtmlTokenType.COMMENT);
          }
        case 14: break;
        case 6: 
          { return errorToken("Character reference is invalid.");
          }
        case 15: break;
        case 5: 
          { HtmlTag tag = HtmlTag.create(yytext());
    if(tag.getError() != null) return errorToken(tag.getError());
    if(!tag.isKnown()) {
        HtmlToken ret = token(HtmlTokenType.UNKNOWN_TAG);
        ret.setErrorMessage(tag.getName() + " tag is not defined in HTML 4.0.");
        return ret;
    }
    if(tag.isDeprecated()) {
        HtmlToken ret = token(HtmlTokenType.DEPRECATED_TAG);
        ret.setErrorMessage(tag.getName() + " tag is deprecated in HTML 4.0.");
        return ret;
    }
    if(tag.getName().equals("A")) {
        if(tag.isEndTag()) yybegin(YYINITIAL);
        else if(tag.containsAttribute("HREF")) yybegin(ANCHOR);
    }
    return token(HtmlTokenType.TAG, tag.getName());
          }
        case 16: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            return null;
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
