/*
 * Copyright (c) 2005, Carl Burch.
 * 
 * This file is part of the com.cburch.editor package. The latest
 * version is available at http://www.cburch.com/proj/editor/.
 *
 * The com.cburch.editor package is free software; you can redistribute
 * it and/or modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * The com.cburch.editor package is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the com.cburch.editor package; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */
 
 /* The following code was generated by JFlex 1.4.1 on 7/5/05 8:15 AM */

/*
 * JavaScanner.java is a generated file. You should edit JavaScanner.lex
 * and use JFlex to generate JavaScanner.java.
 * <a href=http://jflex.de>JFlex</a> is available at
 * <a href=http://jflex.de><em>http://jflex.de/</em></a>.
 */
 
/*
 * This file is loosely based on Stephen Ostermiller's
 * <a href=http://ostermiller.org/syntax/>syntax highlighting package</a>
 * at <a href=http://ostermiller.org/syntax/><em>http://ostermiller.org/syntax/</em></a>.
 * My changes may well have introduced errors that Ostermiller did not
 * have. -Carl Burch 
 */
 
/**
 * Implements a scanner for retrieving Java tokens from a
 * stream.
 *
 * @author Carl Burch
 * @version 0.1 2005-05-31
 */

package com.cburch.editor.scanners;

import java.io.Reader;
import java.io.StringReader;

import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.BadLocationException;

import com.cburch.editor.Token;
import com.cburch.editor.Scanner;
import com.cburch.editor.util.DocumentReader;


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.1
 * on 7/5/05 8:15 AM from the specification file
 * <tt>JavaScanner.lex</tt>
 */
public class JavaScanner implements Scanner<Token> {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int YYINITIAL = 0;

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\22\1\7\1\11\1\0\1\7\1\11\16\22\4\0\1\7\1\47"+
    "\1\20\1\0\1\21\1\12\1\54\1\17\1\34\1\35\1\24\1\53"+
    "\1\43\1\25\1\33\1\23\1\4\3\6\4\3\2\5\1\52\1\42"+
    "\1\46\1\44\1\45\1\51\1\0\3\2\1\32\1\30\1\31\5\21"+
    "\1\26\13\21\1\27\2\21\1\40\1\10\1\41\1\56\1\21\1\0"+
    "\1\2\1\15\1\2\1\32\1\30\1\16\5\21\1\26\1\21\1\14"+
    "\3\21\1\14\1\21\1\14\1\13\2\21\1\27\2\21\1\36\1\55"+
    "\1\37\1\50\41\22\2\0\4\21\4\0\1\21\2\0\1\22\7\0"+
    "\1\21\4\0\1\21\5\0\27\21\1\0\37\21\1\0\u013f\21\31\0"+
    "\162\21\4\0\14\21\16\0\5\21\11\0\1\21\21\0\130\22\5\0"+
    "\23\22\12\0\1\21\13\0\1\21\1\0\3\21\1\0\1\21\1\0"+
    "\24\21\1\0\54\21\1\0\46\21\1\0\5\21\4\0\202\21\1\0"+
    "\4\22\3\0\105\21\1\0\46\21\2\0\2\21\6\0\20\21\41\0"+
    "\46\21\2\0\1\21\7\0\47\21\11\0\21\22\1\0\27\22\1\0"+
    "\3\22\1\0\1\22\1\0\2\22\1\0\1\22\13\0\33\21\5\0"+
    "\3\21\15\0\4\22\14\0\6\22\13\0\32\21\5\0\13\21\16\22"+
    "\7\0\12\1\4\0\2\21\1\22\143\21\1\0\1\21\10\22\1\0"+
    "\6\22\2\21\2\22\1\0\4\22\2\21\12\1\3\21\2\0\1\21"+
    "\17\0\1\22\1\21\1\22\36\21\33\22\2\0\3\21\60\0\46\21"+
    "\13\22\1\21\u014f\0\3\22\66\21\2\0\1\22\1\21\20\22\2\0"+
    "\1\21\4\22\3\0\12\21\2\22\2\0\12\1\21\0\3\22\1\0"+
    "\10\21\2\0\2\21\2\0\26\21\1\0\7\21\1\0\1\21\3\0"+
    "\4\21\2\0\1\22\1\21\7\22\2\0\2\22\2\0\3\22\11\0"+
    "\1\22\4\0\2\21\1\0\3\21\2\22\2\0\12\1\4\21\15\0"+
    "\3\22\1\0\6\21\4\0\2\21\2\0\26\21\1\0\7\21\1\0"+
    "\2\21\1\0\2\21\1\0\2\21\2\0\1\22\1\0\5\22\4\0"+
    "\2\22\2\0\3\22\13\0\4\21\1\0\1\21\7\0\12\1\2\22"+
    "\3\21\14\0\3\22\1\0\11\21\1\0\3\21\1\0\26\21\1\0"+
    "\7\21\1\0\2\21\1\0\5\21\2\0\1\22\1\21\10\22\1\0"+
    "\3\22\1\0\3\22\2\0\1\21\17\0\2\21\2\22\2\0\12\1"+
    "\1\0\1\21\17\0\3\22\1\0\10\21\2\0\2\21\2\0\26\21"+
    "\1\0\7\21\1\0\2\21\1\0\5\21\2\0\1\22\1\21\6\22"+
    "\3\0\2\22\2\0\3\22\10\0\2\22\4\0\2\21\1\0\3\21"+
    "\4\0\12\1\1\0\1\21\20\0\1\22\1\21\1\0\6\21\3\0"+
    "\3\21\1\0\4\21\3\0\2\21\1\0\1\21\1\0\2\21\3\0"+
    "\2\21\3\0\3\21\3\0\10\21\1\0\3\21\4\0\5\22\3\0"+
    "\3\22\1\0\4\22\11\0\1\22\17\0\11\1\11\0\1\21\7\0"+
    "\3\22\1\0\10\21\1\0\3\21\1\0\27\21\1\0\12\21\1\0"+
    "\5\21\4\0\7\22\1\0\3\22\1\0\4\22\7\0\2\22\11\0"+
    "\2\21\4\0\12\1\22\0\2\22\1\0\10\21\1\0\3\21\1\0"+
    "\27\21\1\0\12\21\1\0\5\21\2\0\1\22\1\21\7\22\1\0"+
    "\3\22\1\0\4\22\7\0\2\22\7\0\1\21\1\0\2\21\4\0"+
    "\12\1\22\0\2\22\1\0\10\21\1\0\3\21\1\0\27\21\1\0"+
    "\20\21\4\0\6\22\2\0\3\22\1\0\4\22\11\0\1\22\10\0"+
    "\2\21\4\0\12\1\22\0\2\22\1\0\22\21\3\0\30\21\1\0"+
    "\11\21\1\0\1\21\2\0\7\21\3\0\1\22\4\0\6\22\1\0"+
    "\1\22\1\0\10\22\22\0\2\22\15\0\60\21\1\22\2\21\7\22"+
    "\4\0\10\21\10\22\1\0\12\1\47\0\2\21\1\0\1\21\2\0"+
    "\2\21\1\0\1\21\2\0\1\21\6\0\4\21\1\0\7\21\1\0"+
    "\3\21\1\0\1\21\1\0\1\21\2\0\2\21\1\0\4\21\1\22"+
    "\2\21\6\22\1\0\2\22\1\21\2\0\5\21\1\0\1\21\1\0"+
    "\6\22\2\0\12\1\2\0\2\21\42\0\1\21\27\0\2\22\6\0"+
    "\12\1\13\0\1\22\1\0\1\22\1\0\1\22\4\0\2\22\10\21"+
    "\1\0\42\21\6\0\24\22\1\0\2\22\4\21\4\0\10\22\1\0"+
    "\44\22\11\0\1\22\71\0\42\21\1\0\5\21\1\0\2\21\1\0"+
    "\7\22\3\0\4\22\6\0\12\1\6\0\6\21\4\22\106\0\46\21"+
    "\12\0\51\21\7\0\132\21\5\0\104\21\5\0\122\21\6\0\7\21"+
    "\1\0\77\21\1\0\1\21\1\0\4\21\2\0\7\21\1\0\1\21"+
    "\1\0\4\21\2\0\47\21\1\0\1\21\1\0\4\21\2\0\37\21"+
    "\1\0\1\21\1\0\4\21\2\0\7\21\1\0\1\21\1\0\4\21"+
    "\2\0\7\21\1\0\7\21\1\0\27\21\1\0\37\21\1\0\1\21"+
    "\1\0\4\21\2\0\7\21\1\0\47\21\1\0\23\21\16\0\11\1"+
    "\56\0\125\21\14\0\u026c\21\2\0\10\21\12\0\32\21\5\0\113\21"+
    "\3\0\3\21\17\0\15\21\1\0\4\21\3\22\13\0\22\21\3\22"+
    "\13\0\22\21\2\22\14\0\15\21\1\0\3\21\1\0\2\22\14\0"+
    "\64\21\40\22\3\0\1\21\3\0\2\21\1\22\2\0\12\1\41\0"+
    "\3\22\2\0\12\1\6\0\130\21\10\0\51\21\1\22\126\0\35\21"+
    "\3\0\14\22\4\0\14\22\12\0\12\1\36\21\2\0\5\21\u038b\0"+
    "\154\21\224\0\234\21\4\0\132\21\6\0\26\21\2\0\6\21\2\0"+
    "\46\21\2\0\6\21\2\0\10\21\1\0\1\21\1\0\1\21\1\0"+
    "\1\21\1\0\37\21\2\0\65\21\1\0\7\21\1\0\1\21\3\0"+
    "\3\21\1\0\7\21\3\0\4\21\2\0\6\21\4\0\15\21\5\0"+
    "\3\21\1\0\7\21\17\0\4\22\32\0\5\22\20\0\2\21\23\0"+
    "\1\21\13\0\4\22\6\0\6\22\1\0\1\21\15\0\1\21\40\0"+
    "\22\21\36\0\15\22\4\0\1\22\3\0\6\22\27\0\1\21\4\0"+
    "\1\21\2\0\12\21\1\0\1\21\3\0\5\21\6\0\1\21\1\0"+
    "\1\21\1\0\1\21\1\0\4\21\1\0\3\21\1\0\7\21\3\0"+
    "\3\21\5\0\5\21\26\0\44\21\u0e81\0\3\21\31\0\11\21\6\22"+
    "\1\0\5\21\2\0\5\21\4\0\126\21\2\0\2\22\2\0\3\21"+
    "\1\0\137\21\5\0\50\21\4\0\136\21\21\0\30\21\70\0\20\21"+
    "\u0200\0\u19b6\21\112\0\u51a6\21\132\0\u048d\21\u0773\0\u2ba4\21\u215c\0\u012e\21"+
    "\2\0\73\21\225\0\7\21\14\0\5\21\5\0\1\21\1\22\12\21"+
    "\1\0\15\21\1\0\5\21\1\0\1\21\1\0\2\21\1\0\2\21"+
    "\1\0\154\21\41\0\u016b\21\22\0\100\21\2\0\66\21\50\0\15\21"+
    "\3\0\20\22\20\0\4\22\17\0\2\21\30\0\3\21\31\0\1\21"+
    "\6\0\5\21\1\0\207\21\2\0\1\22\4\0\1\21\13\0\12\1"+
    "\7\0\32\21\4\0\1\21\1\0\32\21\12\0\132\21\3\0\6\21"+
    "\2\0\6\21\2\0\6\21\2\0\3\21\3\0\2\21\3\0\2\21"+
    "\22\0\3\22\4\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\1\0\1\1\1\2\1\3\2\4\1\5\1\6\1\7"+
    "\1\10\1\11\1\12\1\13\1\14\1\15\1\16\1\17"+
    "\1\20\1\21\1\22\1\23\1\24\1\25\1\26\1\27"+
    "\1\30\1\31\1\32\1\33\1\34\1\35\1\36\1\37"+
    "\1\2\1\40\1\2\2\41\1\42\2\4\1\43\2\2"+
    "\2\44\1\45\1\7\1\0\1\46\1\10\1\47\1\50"+
    "\1\51\1\52\1\53\2\4\1\54\1\55\1\0\1\41"+
    "\1\44\1\56\1\57\1\60\1\61\1\62\1\63\1\64"+
    "\1\65\1\66\1\67\1\70\1\71\1\72\1\41\1\0"+
    "\1\4\1\44\1\0\1\7\1\0\1\73\3\7\2\10"+
    "\1\74\2\51\1\42\2\0\1\40\1\0\1\41\1\43"+
    "\1\0\1\44\1\75\1\76\1\77\1\41\1\44\1\7"+
    "\1\74\1\10\2\0\2\51\1\100\1\101\1\7\1\10"+
    "\1\0\1\102\1\7\1\10\3\0";

  private static int [] zzUnpackAction() {
    int [] result = new int[124];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\57\0\136\0\215\0\274\0\353\0\u011a\0\u0149"+
    "\0\u0178\0\u01a7\0\u01d6\0\u0205\0\u0234\0\u0263\0\u0292\0\u0292"+
    "\0\u0292\0\u0292\0\u0292\0\u0292\0\u0292\0\u0292\0\u02c1\0\u02f0"+
    "\0\u031f\0\u034e\0\u0292\0\u0292\0\u0292\0\u037d\0\u03ac\0\u03db"+
    "\0\u040a\0\u0439\0\u0439\0\u0468\0\u0439\0\u0497\0\u0439\0\u04c6"+
    "\0\u04f5\0\u0439\0\u0524\0\u0553\0\u0439\0\u0582\0\u0292\0\u05b1"+
    "\0\u05e0\0\u0292\0\u060f\0\u0292\0\u063e\0\u066d\0\u0292\0\u0292"+
    "\0\u069c\0\u06cb\0\u06fa\0\u0292\0\u06fa\0\u0729\0\u0758\0\u0292"+
    "\0\u0292\0\u0787\0\u0292\0\u07b6\0\u0292\0\u0292\0\u06fa\0\u0292"+
    "\0\u0292\0\u0292\0\u0292\0\u0292\0\u07e5\0\u0814\0\u0843\0\u0872"+
    "\0\u08a1\0\u08d0\0\u08ff\0\u0292\0\u092e\0\u095d\0\u098c\0\u09bb"+
    "\0\u09ea\0\u0a19\0\u0a48\0\u0a77\0\u0292\0\u0aa6\0\u06cb\0\u0292"+
    "\0\u0ad5\0\u0292\0\u0292\0\u0b04\0\u0292\0\u0292\0\u0b33\0\u0292"+
    "\0\u0b62\0\u0b91\0\u0bc0\0\u0292\0\u0bef\0\u0a19\0\u0c1e\0\u0c4d"+
    "\0\u0c7c\0\u0292\0\u0292\0\u0cab\0\u0cda\0\u0d09\0\u0292\0\u0d38"+
    "\0\u0d67\0\u0d96\0\u0dc5\0\u0df4";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[124];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\2\1\3\1\4\1\5\1\6\2\5\1\7\1\2"+
    "\1\7\1\10\4\4\1\11\1\12\1\4\1\2\1\13"+
    "\1\14\1\15\5\4\1\16\1\17\1\20\1\21\1\22"+
    "\1\23\1\24\1\25\1\26\1\27\1\30\1\31\1\32"+
    "\1\33\1\34\1\35\1\36\1\37\1\40\1\41\7\2"+
    "\1\0\1\2\2\0\4\2\2\0\2\2\3\0\5\2"+
    "\24\0\1\42\1\3\1\42\4\3\1\0\1\42\2\0"+
    "\3\42\1\43\2\0\2\42\3\0\2\42\1\44\1\43"+
    "\1\45\1\46\23\0\1\2\6\4\1\0\1\2\2\0"+
    "\4\4\2\0\2\4\3\0\5\4\24\0\1\42\1\5"+
    "\1\42\4\5\1\0\1\42\2\0\3\42\1\43\2\0"+
    "\2\42\3\0\1\47\1\42\1\44\1\43\1\45\1\46"+
    "\23\0\1\42\1\3\1\42\1\50\1\51\1\3\1\50"+
    "\1\0\1\42\2\0\3\42\1\52\2\0\2\42\3\0"+
    "\1\47\1\53\1\54\1\52\1\55\1\56\32\0\1\7"+
    "\1\0\1\7\111\0\1\57\12\0\10\60\1\61\1\0"+
    "\5\60\1\62\37\60\10\12\1\63\1\0\6\12\1\64"+
    "\36\12\23\0\1\65\1\66\17\0\1\67\56\0\1\70"+
    "\15\0\1\71\1\72\2\71\16\0\1\73\16\0\1\74"+
    "\6\0\1\75\4\0\1\76\1\0\1\76\1\77\2\76"+
    "\173\0\1\100\56\0\1\101\1\102\55\0\1\103\1\0"+
    "\1\104\54\0\1\105\15\0\1\71\1\72\2\71\16\0"+
    "\1\75\16\0\1\106\6\0\1\107\47\0\1\110\7\0"+
    "\1\111\46\0\1\112\10\0\1\113\45\0\1\114\12\0"+
    "\7\42\1\0\1\42\2\0\4\42\2\0\2\42\3\0"+
    "\6\42\23\0\1\42\1\115\1\42\4\115\1\0\1\42"+
    "\2\0\4\42\2\0\2\42\2\0\1\116\6\42\17\0"+
    "\1\116\3\0\1\42\1\46\1\42\4\46\1\0\1\42"+
    "\2\0\3\42\1\43\2\0\2\42\3\0\2\42\1\44"+
    "\1\43\1\45\1\42\23\0\1\42\1\3\1\42\2\50"+
    "\1\3\1\50\1\0\1\42\2\0\3\42\1\43\2\0"+
    "\2\42\3\0\1\47\1\42\1\44\1\43\1\45\1\46"+
    "\23\0\1\42\1\3\1\42\1\50\1\51\1\3\1\50"+
    "\1\0\1\42\2\0\3\42\1\52\2\0\2\42\3\0"+
    "\1\47\1\42\1\54\1\52\1\55\1\56\23\0\1\42"+
    "\6\117\1\0\1\42\2\0\2\42\2\117\2\0\2\42"+
    "\3\0\2\42\3\117\1\42\23\0\1\42\1\120\1\42"+
    "\4\120\1\0\1\42\2\0\4\42\2\0\2\42\2\0"+
    "\1\121\6\42\17\0\1\121\3\0\1\42\1\46\1\42"+
    "\1\46\1\56\2\46\1\0\1\42\2\0\3\42\1\52"+
    "\2\0\2\42\3\0\2\42\1\54\1\52\1\55\1\42"+
    "\23\0\10\122\1\123\1\0\5\122\1\124\42\122\1\125"+
    "\1\126\1\122\1\126\1\122\1\60\1\0\1\122\1\127"+
    "\5\60\36\122\3\130\2\12\1\130\1\12\1\130\1\12"+
    "\1\0\1\130\1\131\4\12\1\132\36\130\11\65\1\0"+
    "\45\65\24\133\1\134\32\133\1\0\1\71\1\0\4\71"+
    "\17\0\1\135\56\0\1\135\33\0\1\136\1\137\2\136"+
    "\51\0\1\76\1\0\4\76\7\0\1\140\11\0\1\141"+
    "\1\140\1\142\25\0\1\76\1\0\1\76\1\77\2\76"+
    "\7\0\1\143\11\0\1\144\1\143\1\145\70\0\1\146"+
    "\1\147\55\0\1\150\12\0\1\42\1\115\1\42\4\115"+
    "\1\0\1\42\2\0\3\42\1\43\2\0\2\42\3\0"+
    "\3\42\1\43\1\45\1\42\24\0\1\151\1\0\4\151"+
    "\50\0\1\42\6\117\1\0\1\42\2\0\2\42\2\117"+
    "\2\0\2\42\3\0\1\47\1\42\3\117\1\42\23\0"+
    "\1\42\1\120\1\42\4\120\1\0\1\42\2\0\3\42"+
    "\1\52\2\0\2\42\3\0\3\42\1\52\1\55\1\42"+
    "\24\0\1\152\1\0\4\152\50\0\10\122\1\123\1\0"+
    "\5\122\1\62\50\122\1\0\50\122\2\60\1\122\1\60"+
    "\1\122\1\123\1\0\5\122\1\124\42\122\2\125\1\122"+
    "\1\125\1\122\1\123\1\0\5\122\1\124\40\122\6\153"+
    "\1\122\1\123\1\0\3\122\2\153\1\62\10\122\3\153"+
    "\24\122\11\130\1\0\6\130\1\154\37\130\6\155\2\130"+
    "\1\0\3\130\2\155\1\130\1\154\7\130\3\155\24\130"+
    "\10\156\1\157\1\0\6\156\1\64\36\156\24\133\1\160"+
    "\32\133\23\161\1\162\1\134\32\161\1\0\1\136\1\0"+
    "\4\136\17\0\1\135\31\0\1\151\1\0\4\151\16\0"+
    "\1\116\25\0\1\116\4\0\1\152\1\0\4\152\16\0"+
    "\1\121\25\0\1\121\47\0\1\163\13\0\1\151\1\0"+
    "\4\151\7\0\1\140\12\0\1\140\1\142\25\0\1\152"+
    "\1\0\4\152\7\0\1\143\12\0\1\143\1\145\24\0"+
    "\1\122\6\164\1\122\1\123\1\0\3\122\2\164\1\62"+
    "\10\122\3\164\24\122\1\130\6\165\2\130\1\0\3\130"+
    "\2\165\1\130\1\154\7\130\3\165\24\130\3\0\2\156"+
    "\1\0\1\156\1\0\1\156\2\0\1\166\5\156\36\0"+
    "\23\133\1\167\1\160\32\133\24\161\1\134\32\161\1\122"+
    "\6\170\1\122\1\123\1\0\3\122\2\170\1\62\10\122"+
    "\3\170\24\122\1\130\6\171\2\130\1\0\3\130\2\171"+
    "\1\130\1\154\7\130\3\171\24\130\1\0\6\172\6\0"+
    "\2\172\11\0\3\172\24\0\1\122\6\60\1\122\1\123"+
    "\1\0\3\122\2\60\1\62\10\122\3\60\24\122\1\130"+
    "\6\12\2\130\1\0\3\130\2\12\1\130\1\154\7\130"+
    "\3\12\24\130\1\0\6\173\6\0\2\173\11\0\3\173"+
    "\25\0\6\174\6\0\2\174\11\0\3\174\25\0\6\156"+
    "\6\0\2\156\11\0\3\156\24\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[3619];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\1\0\15\1\10\11\4\1\3\11\21\1\1\11\1\1"+
    "\1\0\1\11\1\1\1\11\2\1\2\11\3\1\1\11"+
    "\1\0\2\1\2\11\1\1\1\11\1\1\2\11\1\1"+
    "\5\11\1\1\1\0\2\1\1\0\1\1\1\0\1\11"+
    "\10\1\1\11\2\0\1\11\1\0\2\11\1\0\2\11"+
    "\1\1\1\11\3\1\1\11\1\1\2\0\2\1\2\11"+
    "\2\1\1\0\1\11\2\1\3\0";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[124];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the textposition at the last state to be included in yytext */
  private int zzPushbackPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /* user code: */
    /**
     * Represents a token from Java text. This is not strictly necessary:
     * We could just use the <code>Token</code> class. But I do it anyway
     * in case it's necessary to add state later on. (<code>HtmlScanner</code>
     * contains a case where it is necessary.)
     */
    private static class JavaToken extends Token {
        public JavaToken(JavaTokenType type, Position offset, String text, Object data) {
            super(type, offset, text, data);
        }
        
        public JavaToken(JavaTokenType type, Position offset, String text) {
            super(type, offset, text);
        }
    }

    /**
     * Remembers the current document being edited.
     */
    private Document document = null;
    
    /**
     * Constructs a JavaScanner reading a null document. This
     * null document will never be used; the tokenizer will always
     * initialize the reader through a <code>reset</code> method
     * before ever reading any tokens.
     */
    public JavaScanner() {
        this(new StringReader(""));
    }

    public void reset(Reader reader, Token token) {
        if(reader instanceof DocumentReader) {
            document = ((DocumentReader) reader).getDocument();
        } else {
            document = null;
        }
        yyreset(reader);
        this.yychar = token.getEndOffset();
    }
    
    public void reset(Reader reader) {
        if(reader instanceof DocumentReader) {
            document = ((DocumentReader) reader).getDocument();
        } else {
            document = null;
        }
        yyreset(reader);
    }

    /**
     * Creates a token for the given type. This simplifies
     * the code for handling individual tokens.
     *
     * @param type  the type to associate with the created token.
     * @return the created token.
     */
    private JavaToken token(JavaTokenType type) {
        String text = yytext();
        int endOffs = yychar + text.length();
        
        Position pos = null;
        if(document != null) {
            try { pos = document.createPosition(endOffs); } catch(BadLocationException e) { }
        }
        return new JavaToken(type, pos, text);
    }
    
    /**
     * Creates a token for the given type. This simplifies
     * the code for handling individual tokens.
     *
     * @param type  the type to associate with the created token.
     * @param data  the data to associate with the created token.
     * @return the created token.
     */
    private JavaToken token(JavaTokenType type, Object data) {
        String text = yytext();
        int endOffs = yychar + text.length();
        
        Position pos = null;
        if(document != null) {
            try { pos = document.createPosition(endOffs); } catch(BadLocationException e) { }
        }
        return new JavaToken(type, pos, text, data);
    }
    
    /**
     * Creates an error token with the given error message associated
     * with it.
     *
     * @param message  the error message to associate with the token.
     * @return the created token
     */
    private JavaToken errorToken(String message) {
        JavaToken ret = token(JavaTokenType.ERROR);
        ret.setErrorMessage(message);
        return ret;
    }

    /**
     * Determine the actual string represented by the code. This
     * is essentially a matter of replacing any escape sequences
     * with their equivalent characters ("\t" gets replaced with
     * a tab character, for example).</p>
     *
     * <p>This does not address Unicode escape sequences, which are
     * technically handled in an earlier stage than tokenizing,
     * so that for example one could use Unicode escape sequences
     * in the middle of a Java program's variable names. This scanner
     * does not address Unicode sequences at all.
     *
     * @param source  the original string, with escape characters.
     * @return the string it represents, or <code>null</code> if it
     *   has any errors.
     */
    private String unescapeString(String source) {
        StringBuilder ret = new StringBuilder(source.length());
        for(int i = 0; i < source.length(); i++) {
            char c = source.charAt(i);
            if(c == '\\') {
                i++;
                if(i == source.length()) return null;
                c = source.charAt(i);
                if(c == 'b')       ret.append('\b');
                else if(c == 't')  ret.append('\t');
                else if(c == 'n')  ret.append('\n');
                else if(c == 'f')  ret.append('\f');
                else if(c == 'r')  ret.append('\r');
                else if(c == '"')  ret.append('\"');
                else if(c == '\'') ret.append('\'');
                else if(c == '\\') ret.append('\'');
                else { // it must be an octal sequence
                    int o0 = Character.digit(c, 8);
                    if(o0 < 0) return null; // this is an invalid escape sequence
                    
                    int value;
                    if(i + 1 < source.length() && Character.digit(source.charAt(i + 1), 8) >= 0) {
                        i++; // this octal sequence has at least two digits
                        int o1 = Character.digit(source.charAt(i), 8);
                        if(o0 < 4 && i + 1 < source.length() && Character.digit(source.charAt(i + 1), 8) >= 0) {
                            i++; // this octal sequenc has three digits
                            int o2 = Character.digit(source.charAt(i), 8);
                            value = o0 * 64 + o1 * 8 + o2;
                        } else {
                            value = o0 * 8 + o1;
                        }
                    } else {
                        value = o0;
                    }
                    ret.append((char) value);
                }
            } else {
                ret.append(c);
            }
        }
        return ret.toString();
    }


  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public JavaScanner(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public JavaScanner(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 1766) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzPushbackPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead < 0) {
      return true;
    }
    else {
      zzEndRead+= numRead;
      return false;
    }
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = zzPushbackPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public JavaToken nextToken() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      yychar+= zzMarkedPosL-zzStartRead;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = zzLexicalState;


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 25: 
          { return token(JavaTokenType.TILDE);
          }
        case 67: break;
        case 24: 
          { return token(JavaTokenType.EXCLAMATION);
          }
        case 68: break;
        case 12: 
          { return token(JavaTokenType.PERIOD);
          }
        case 69: break;
        case 7: 
          { return errorToken("Character constant must be closed.");
          }
        case 70: break;
        case 36: 
          { return token(JavaTokenType.DOUBLE_LITERAL, Double.valueOf(0.0));
          }
        case 71: break;
        case 52: 
          { return token(JavaTokenType.ADD_ASSIGN);
          }
        case 72: break;
        case 40: 
          { return token(JavaTokenType.COMMENT_END_OF_LINE);
          }
        case 73: break;
        case 34: 
          { try {
        return token(JavaTokenType.LONG_LITERAL, Long.decode(yytext()));
    } catch(NumberFormatException e) {
        return errorToken("Long constant is out of bounds.");
    }
          }
        case 74: break;
        case 28: 
          { return token(JavaTokenType.PLUS);
          }
        case 75: break;
        case 8: 
          { return errorToken("String constant must be closed.");
          }
        case 76: break;
        case 58: 
          { return token(JavaTokenType.XOR_ASSIGN);
          }
        case 77: break;
        case 41: 
          { return errorToken("Comment must be closed.");
          }
        case 78: break;
        case 32: 
          { /* 
     * Stephen Ostermiller reports that Sun's Java implementation
     * does not work quite correctly in terms of MAX_VALUE and MIN_VALUE,
     * and that the following code works around this. In any case,
     * the following definition is not going to hurt us any.
     */ 
    try {
        Float x = Float.valueOf(yytext());
        if (x.isInfinite() || x.compareTo(new Float(0f)) == 0){
            return errorToken("Float value is out of bounds.");
        } else {
            return token(JavaTokenType.FLOAT_LITERAL, x);
        }
    } catch (NumberFormatException e) {
        return errorToken("Float value is out of bounds.");
    }
          }
        case 79: break;
        case 4: 
          { /* At this point, the number we found could still be too large.
     * If it is too large, we need to return an error.
     * Java has methods built in that will decode from a string
     * and throw an exception the number is too large 
     */     
    try {
        return token(JavaTokenType.INTEGER_LITERAL, Integer.decode(yytext()));
    } catch (NumberFormatException e) {
        return errorToken("Integer constant is out of bounds.");
    }
          }
        case 80: break;
        case 56: 
          { return token(JavaTokenType.OR_ASSIGN);
          }
        case 81: break;
        case 29: 
          { return token(JavaTokenType.AMPERSAND);
          }
        case 82: break;
        case 13: 
          { return token(JavaTokenType.LPAREN);
          }
        case 83: break;
        case 44: 
          { return token(JavaTokenType.DECREMENT);
          }
        case 84: break;
        case 22: 
          { return token(JavaTokenType.RANGLE);
          }
        case 85: break;
        case 16: 
          { return token(JavaTokenType.RBRACE);
          }
        case 86: break;
        case 53: 
          { return token(JavaTokenType.INCREMENT);
          }
        case 87: break;
        case 9: 
          { return token(JavaTokenType.SLASH);
          }
        case 88: break;
        case 66: 
          { return token(JavaTokenType.COMMENT_TRADITIONAL);
          }
        case 89: break;
        case 57: 
          { return token(JavaTokenType.LOGICAL_OR);
          }
        case 90: break;
        case 37: 
          { return token(JavaTokenType.MOD_ASSIGN);
          }
        case 91: break;
        case 65: 
          { return token(JavaTokenType.SHIFT_RIGHT_LOGICAL_ASSIGN);
          }
        case 92: break;
        case 51: 
          { return token(JavaTokenType.IS_NOT_EQUAL);
          }
        case 93: break;
        case 48: 
          { return token(JavaTokenType.SHIFT_RIGHT);
          }
        case 94: break;
        case 42: 
          { return token(JavaTokenType.DIVIDE_ASSIGN);
          }
        case 95: break;
        case 10: 
          { return token(JavaTokenType.STAR);
          }
        case 96: break;
        case 60: 
          { return errorToken("String constant is malformed.");
          }
        case 97: break;
        case 54: 
          { return token(JavaTokenType.AND_ASSIGN);
          }
        case 98: break;
        case 45: 
          { return token(JavaTokenType.SUBTRACT_ASSIGN);
          }
        case 99: break;
        case 27: 
          { return token(JavaTokenType.COLON);
          }
        case 100: break;
        case 17: 
          { return token(JavaTokenType.LBRACKET);
          }
        case 101: break;
        case 33: 
          { /* This is the same workaround we saw for floating-point numbers. */
    try {
        Double x = Double.valueOf(yytext());
        if (x.isInfinite() || x.compareTo(new Double(0d)) == 0){
            return errorToken("Double value is out of bounds.");
        } else {
            return token(JavaTokenType.DOUBLE_LITERAL, x);
        }
    } catch (NumberFormatException e) {
        return errorToken("Double value is out of bounds.");
    }
          }
        case 102: break;
        case 35: 
          { /* catch the case of a zero in parsing, so that we do not incorrectly
     * give an error that a number was rounded to zero
     */
    return token(JavaTokenType.FLOAT_LITERAL, Float.valueOf(0.0f));
          }
        case 103: break;
        case 3: 
          { String text = yytext();
    JavaTokenType type = JavaTokenType.forKeyword(text);
    if(type == JavaTokenType.BOOLEAN_LITERAL) {
        // create a token with the value in its data.
        return token(JavaTokenType.BOOLEAN_LITERAL,
            Boolean.valueOf(text.equals("true")));
    } else {
        return token(type);
    }
          }
        case 104: break;
        case 19: 
          { return token(JavaTokenType.SEMICOLON);
          }
        case 105: break;
        case 59: 
          { String text = yytext();
    if(text.length() < 3) return errorToken("Character constant is missing characters.");
    String data = unescapeString(text.substring(1, text.length() - 1));
    if(data == null) {
        return errorToken("Character constant is invalid.");
    } else if(data.length() > 1) {
        return errorToken("Character constant contains multiple characters.");
    } else if(data.length() == 0) {
        return errorToken("Character constant is missing a character.");
    } else {
        return token(JavaTokenType.CHARACTER_LITERAL, Character.valueOf(data.charAt(0)));
    }
          }
        case 106: break;
        case 43: 
          { return token(JavaTokenType.MULTIPLY_ASSIGN);
          }
        case 107: break;
        case 39: 
          { String text = yytext();
    if(text.length() < 2) return errorToken("string constant missing quotations.");
    String data = unescapeString(text.substring(1, text.length() - 1));
    if(data == null) return errorToken("String constant is invalid.");
    return token(JavaTokenType.STRING_LITERAL, data);
          }
        case 108: break;
        case 47: 
          { return token(JavaTokenType.IS_GREATER_EQUAL);
          }
        case 109: break;
        case 2: 
          { return errorToken("Float constant is invalid.");
          }
        case 110: break;
        case 30: 
          { return token(JavaTokenType.VERTICAL_BAR);
          }
        case 111: break;
        case 1: 
          { return errorToken("Identifier is invalid.");
          }
        case 112: break;
        case 62: 
          { return token(JavaTokenType.SHIFT_RIGHT_LOGICAL);
          }
        case 113: break;
        case 49: 
          { return token(JavaTokenType.IS_LESS_EQUAL);
          }
        case 114: break;
        case 14: 
          { return token(JavaTokenType.RPAREN);
          }
        case 115: break;
        case 64: 
          { return token(JavaTokenType.JAVADOC);
          }
        case 116: break;
        case 55: 
          { return token(JavaTokenType.LOGICAL_AND);
          }
        case 117: break;
        case 18: 
          { return token(JavaTokenType.RBRACKET);
          }
        case 118: break;
        case 11: 
          { return token(JavaTokenType.MINUS);
          }
        case 119: break;
        case 61: 
          { return token(JavaTokenType.SHIFT_RIGHT_ASSIGN);
          }
        case 120: break;
        case 26: 
          { return token(JavaTokenType.QUESTION);
          }
        case 121: break;
        case 31: 
          { return token(JavaTokenType.CARET);
          }
        case 122: break;
        case 15: 
          { return token(JavaTokenType.LBRACE);
          }
        case 123: break;
        case 23: 
          { return token(JavaTokenType.LANGLE);
          }
        case 124: break;
        case 50: 
          { return token(JavaTokenType.SHIFT_LEFT);
          }
        case 125: break;
        case 63: 
          { return token(JavaTokenType.SHIFT_LEFT_ASSIGN);
          }
        case 126: break;
        case 20: 
          { return token(JavaTokenType.COMMA);
          }
        case 127: break;
        case 6: 
          { return token(JavaTokenType.PERCENT);
          }
        case 128: break;
        case 21: 
          { return token(JavaTokenType.ASSIGN);
          }
        case 129: break;
        case 46: 
          { return token(JavaTokenType.IS_EQUAL);
          }
        case 130: break;
        case 38: 
          { return errorToken("Character constant is malformed.");
          }
        case 131: break;
        case 5: 
          { 
          }
        case 132: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            return null;
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
