/*
 * Copyright (c) 2005, Carl Burch.
 * 
 * This file is part of the com.cburch.editor package. The latest
 * version is available at http://www.cburch.com/proj/editor/.
 *
 * The com.cburch.editor package is free software; you can redistribute
 * it and/or modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * The com.cburch.editor package is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the com.cburch.editor package; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */
 
 package com.cburch.editor.scanners;

import javax.swing.text.AttributeSet;

import com.cburch.editor.TokenType;

/**
 * Defines the different categories of tokens that might
 * be encountered in an HTML file.
 * 
 * @author Carl Burch
 * @version 0.1 2005-05-31
 */
public enum HtmlTokenType implements TokenType {
    /** A recognized, valid tag. */
    TAG("tag", Styles.TAG),
    /** A deprecated tag. */
    DEPRECATED_TAG("tag (deprecated)", Styles.BAD_TAG),
    /** An unknown tag. */
    UNKNOWN_TAG("tag (unknown)", Styles.BAD_TAG),
    /** Text within a regular element. */
    TEXT("text", Styles.TEXT),
    /** Text within an anchor element. */
    ANCHOR_TEXT("text", Styles.ANCHOR_TEXT),
    /** A comment. */
    COMMENT("comment", Styles.COMMENT),
    /** A sequence of invalid characters. */
    ERROR("ERROR", Styles.ERROR);

    /** A terse description of what sort of token this is. */
    private String descriptor;
    
    /** The style in which tokens of this type should be drawn. */
    private AttributeSet attrs;

    /**
     * Constructs a Java token type with the given descriptor and style.
     * 
     * @param descriptor  a terse description of the token type.
     * @param attrs  the style in which tokens of the type should be drawn.
     */
    private HtmlTokenType(String descriptor, AttributeSet attrs) {
        this.descriptor = descriptor;
        this.attrs = attrs;
    }

    /**
     * Returns a terse description of what sort of token this
     * corresponds to.
     * 
     * @return the terse description.
     */
    public String getDescriptor() {
        return descriptor;
    }
    
    /**
     * Return the style in which tokens of this type should be drawn.
     * 
     * @return the style for tokens of this type.
     */
    public AttributeSet getAttributeSet() {
        return attrs;
    }
}
