/*
 * Copyright (c) 2005, Carl Burch.
 * 
 * This file is part of the com.cburch.editor package. The latest
 * version is available at http://www.cburch.com/proj/editor/.
 *
 * The com.cburch.editor package is free software; you can redistribute
 * it and/or modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * The com.cburch.editor package is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the com.cburch.editor package; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */
 
 package com.cburch.editor.tokens;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

/**
 * Maintains a list of tokens, just as with <code>TokenList</code>,
 * except that modifications are allowed here. The <code>Tokenizer</code>
 * class does not use this class, but other classes may find this
 * useful to maintain their own lists of tokens. 
 *  
 * @author Carl Burch
 * @version 0.1 2005-05-31
 *
 * @param <T> the type of token maintained in the list.
 */
public class MutableTokenList<T extends BasicToken> extends TokenList<T> {
    /** Constructs an empty list of tokens. */
    public MutableTokenList() { super(); }
    
    /**
     * Constructs a list of tokens initially holding the given values.
     * 
     * @param initialValues  the tokens to have in the list initially.
     */
    public MutableTokenList(List<? extends T> initialValues) { super(initialValues); }
    
    /**
     * Replaces a range of the list with a different list instead.
     * 
     * @param from  the first index to be removed.
     * @param to    the first index to be retained, one after the
     *    index of the last index to be removed.
     * @param newTokens  the tokens to be inserted in place of the
     *    removed tokens.
     */
    public void replace(int from, int to, List<T> newTokens) {
        super.replace(from, to, newTokens);
    }

    public Iterator<T> iterator() { return data.iterator(); }
    public ListIterator<T> listIterator() { return data.listIterator(); }
    public ListIterator<T> listIterator(int arg0) { return data.listIterator(arg0); }
    public List<T> subList(int arg0, int arg1) { return data.subList(arg0, arg1); }

    /** Implemented as defined in the <code>List</code> interface. */
    public boolean add(T arg0) { return data.add(arg0); }
    /** Implemented as defined in the <code>List</code> interface. */
    public void add(int arg0, T arg1) { data.add(arg0, arg1); }
    /** Implemented as defined in the <code>List</code> interface. */
    public boolean addAll(Collection<? extends T> arg0) { return data.addAll(arg0); }
    /** Implemented as defined in the <code>List</code> interface. */
    public boolean addAll(int arg0, Collection<? extends T> arg1) { return data.addAll(arg0, arg1); }
    /** Implemented as defined in the <code>List</code> interface. */
    public boolean removeAll(Collection<?> arg0) { return data.removeAll(arg0); }
    /** Implemented as defined in the <code>List</code> interface. */
    public boolean retainAll(Collection<?> arg0) { return data.retainAll(arg0); }
    /** Implemented as defined in the <code>List</code> interface. */
    public void clear() { data.clear(); }
    /** Implemented as defined in the <code>List</code> interface. */
    public T set(int arg0, T arg1) { return data.set(arg0, arg1); }
    /** Implemented as defined in the <code>List</code> interface. */
    public T remove(int arg0) { return data.remove(arg0); }
    /** Implemented as defined in the <code>List</code> interface. */
    public boolean remove(Object arg0) { return data.remove(arg0); }
}
