/*
 * Copyright (c) 2005, Carl Burch.
 * 
 * This file is part of the com.cburch.editor package. The latest
 * version is available at http://www.cburch.com/proj/editor/.
 *
 * The com.cburch.editor package is free software; you can redistribute
 * it and/or modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * The com.cburch.editor package is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the com.cburch.editor package; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */
 
 package com.cburch.editor.tokens;

/**
 * The interface that classes can implement in order to listen
 * to modifications made to the list of tokens maintained by
 * a tokenizer.
 * 
 * @author Carl Burch
 * @version 0.1 2005-05-31
 *
 * @param <T> the type of tokens maintained by the tokenizer.
 */
public interface TokenizerListener<T extends BasicToken> {
    /**
     * Called whenever a tokenizer modifies the list of tokens
     * for which it is responsible. See {@link TokenizerEvent} to
     * learn about what the event looks like.
     * 
     * @param event  a description of the modification.
     */
    public void rangeReplaced(TokenizerEvent<T> event);
}
