/*
 * Decompiled with CFR 0.152.
 */
package lambda;

import java.util.HashMap;
import lambda.Expr;
import lambda.Symbol;

abstract class Builtin {
    static HashMap builtins = new HashMap();

    Builtin() {
    }

    abstract int numArguments();

    abstract boolean canApply(Expr[] var1);

    abstract Expr apply(Expr[] var1);

    static Builtin get(String string, int n) {
        Builtin builtin = (Builtin)builtins.get(string);
        if (builtin != null && builtin.numArguments() == n) {
            return builtin;
        }
        return null;
    }

    static {
        builtins.put("+", new AddOperator());
        builtins.put("-", new SubOperator());
        builtins.put("*", new MultOperator());
        builtins.put("/", new DivOperator());
        builtins.put("=", new EqOperator());
        builtins.put("/=", new NeOperator());
        builtins.put("<", new LtOperator());
        builtins.put(">", new GtOperator());
        builtins.put("<=", new LeOperator());
        builtins.put(">=", new GeOperator());
        builtins.put("if", new IfOperator());
    }

    private static class IfOperator
    extends Builtin {
        private IfOperator() {
        }

        int numArguments() {
            return 3;
        }

        boolean canApply(Expr[] exprArray) {
            String string;
            return exprArray[0] instanceof Expr.Ident && ((string = ((Expr.Ident)exprArray[0]).sym.toString()).equals("true") || string.equals("false"));
        }

        Expr apply(Expr[] exprArray) {
            String string = ((Expr.Ident)exprArray[0]).sym.toString();
            if (string.equals("true")) {
                return exprArray[1];
            }
            return exprArray[2];
        }
    }

    private static class GeOperator
    extends BinaryOperator {
        private GeOperator() {
        }

        String computeResult(int n, int n2) {
            return "" + (n >= n2);
        }
    }

    private static class LeOperator
    extends BinaryOperator {
        private LeOperator() {
        }

        String computeResult(int n, int n2) {
            return "" + (n <= n2);
        }
    }

    private static class GtOperator
    extends BinaryOperator {
        private GtOperator() {
        }

        String computeResult(int n, int n2) {
            return "" + (n > n2);
        }
    }

    private static class LtOperator
    extends BinaryOperator {
        private LtOperator() {
        }

        String computeResult(int n, int n2) {
            return "" + (n < n2);
        }
    }

    private static class NeOperator
    extends BinaryOperator {
        private NeOperator() {
        }

        String computeResult(int n, int n2) {
            return "" + (n != n2);
        }
    }

    private static class EqOperator
    extends BinaryOperator {
        private EqOperator() {
        }

        String computeResult(int n, int n2) {
            return "" + (n == n2);
        }
    }

    private static class DivOperator
    extends BinaryOperator {
        private DivOperator() {
        }

        String computeResult(int n, int n2) {
            return "" + n / n2;
        }
    }

    private static class MultOperator
    extends BinaryOperator {
        private MultOperator() {
        }

        String computeResult(int n, int n2) {
            return "" + n * n2;
        }
    }

    private static class SubOperator
    extends BinaryOperator {
        private SubOperator() {
        }

        String computeResult(int n, int n2) {
            return "" + (n - n2);
        }
    }

    private static class AddOperator
    extends BinaryOperator {
        private AddOperator() {
        }

        String computeResult(int n, int n2) {
            return "" + (n + n2);
        }
    }

    private static abstract class BinaryOperator
    extends Builtin {
        private BinaryOperator() {
        }

        int numArguments() {
            return 2;
        }

        boolean canApply(Expr[] exprArray) {
            if (exprArray[0] instanceof Expr.Ident && exprArray[1] instanceof Expr.Ident) {
                String string = ((Expr.Ident)exprArray[0]).sym.toString();
                String string2 = ((Expr.Ident)exprArray[1]).sym.toString();
                try {
                    Integer.parseInt(string);
                    Integer.parseInt(string2);
                    return true;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return false;
        }

        Expr apply(Expr[] exprArray) {
            String string = ((Expr.Ident)exprArray[0]).sym.toString();
            String string2 = ((Expr.Ident)exprArray[1]).sym.toString();
            String string3 = this.computeResult(Integer.parseInt(string), Integer.parseInt(string2));
            return new Expr.Ident(new Symbol(string3));
        }

        abstract String computeResult(int var1, int var2);
    }
}

