/*
 * Decompiled with CFR 0.152.
 */
package lambda;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;

class Options {
    private static Option[] options = new Option[]{new IntOption("Maximum Reductions", "max_reductions", 100, new int[]{25, 50, 100, 200, 300, 400, 500, 1000}), new EvaluationOrderOption(1), new BooleanOption("Enable Eta Reductions", "eta_reductions", true), new BooleanOption("Use Applied Calculus", "use_applied", true), new IntOption("Maximum Length", "max_length", 300, new int[]{100, 300, 1000, Integer.MAX_VALUE}), new BooleanOption("Show Intermediate Steps", "show_intermediate", true), new BooleanOption("Substitute Symbols", "substitute_symbols", true), new BooleanOption("Vary Parentheses", "vary_parentheses", false), new PrintLambdaOption(true), new FontSizeOption(12), new BooleanOption("Show Browser", "show_browser", true)};
    private static HashMap option_map = null;
    private static char lambda = (char)63;

    Options() {
    }

    private static Option get(String string) {
        if (option_map == null) {
            option_map = new HashMap();
            int n = 0;
            while (n < options.length) {
                option_map.put(options[n].getName(), options[n]);
                ++n;
            }
        }
        return (Option)option_map.get(string);
    }

    static IntOption getMaxReductionsOption() {
        return (IntOption)Options.get("max_reductions");
    }

    static IntOption getEvaluationOrderOption() {
        return (IntOption)Options.get("evaluation_order");
    }

    static BooleanOption getEtaReductionsOption() {
        return (BooleanOption)Options.get("eta_reductions");
    }

    static BooleanOption getUseAppliedOption() {
        return (BooleanOption)Options.get("use_applied");
    }

    static IntOption getMaxLengthOption() {
        return (IntOption)Options.get("max_length");
    }

    static BooleanOption getPrintLambdaOption() {
        return (BooleanOption)Options.get("print_lambda");
    }

    static BooleanOption getShowIntermediateOption() {
        return (BooleanOption)Options.get("show_intermediate");
    }

    static BooleanOption getSubstituteSymbolsOption() {
        return (BooleanOption)Options.get("substitute_symbols");
    }

    static BooleanOption getVaryParenthesesOption() {
        return (BooleanOption)Options.get("vary_parentheses");
    }

    static IntOption getFontSizeOption() {
        return (IntOption)Options.get("font_size");
    }

    static BooleanOption getShowBrowserOption() {
        return (BooleanOption)Options.get("show_browser");
    }

    static char getLambdaChar() {
        return ((PrintLambdaOption)Options.getPrintLambdaOption()).getLambdaChar();
    }

    static Font getFont() {
        return ((FontSizeOption)Options.getFontSizeOption()).getFont();
    }

    static void printOptions() {
        int n = 0;
        while (n < options.length) {
            System.err.print("  -" + options[n].getName() + "=");
            System.err.println(options[n].getParameterDescription());
            ++n;
        }
    }

    static void parseOptions(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            int n2 = stringArray[n].indexOf("=");
            if (stringArray[n] != null && stringArray[n].charAt(0) == '-' && n2 >= 0) {
                String string = stringArray[n].substring(1, n2);
                String string2 = stringArray[n].substring(n2 + 1);
                try {
                    Option option = Options.get(string);
                    if (option != null) {
                        option.setValue(string2);
                        stringArray[n] = null;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            ++n;
        }
    }

    static JMenu getMenu() {
        JMenu jMenu = new JMenu("Options");
        JMenu jMenu2 = new JMenu("Engine");
        jMenu.add(jMenu2);
        JMenu jMenu3 = new JMenu("Printing");
        jMenu.add(jMenu3);
        JMenu jMenu4 = new JMenu("Interface");
        jMenu.add(jMenu4);
        jMenu2.add(Options.getMaxReductionsOption().createMenuItem());
        jMenu2.add(Options.getEvaluationOrderOption().createMenuItem());
        jMenu2.add(Options.getUseAppliedOption().createMenuItem());
        jMenu2.add(Options.getEtaReductionsOption().createMenuItem());
        jMenu3.add(Options.getMaxLengthOption().createMenuItem());
        jMenu3.add(Options.getPrintLambdaOption().createMenuItem());
        jMenu3.add(Options.getShowIntermediateOption().createMenuItem());
        jMenu3.add(Options.getSubstituteSymbolsOption().createMenuItem());
        jMenu3.add(Options.getVaryParenthesesOption().createMenuItem());
        jMenu4.add(Options.getFontSizeOption().createMenuItem());
        jMenu4.add(Options.getShowBrowserOption().createMenuItem());
        return jMenu;
    }

    private static class FontSizeOption
    extends IntOption {
        private Font font;

        FontSizeOption(int n) {
            super("Font Size", "font_size", n, new int[]{10, 12, 14, 18, 24});
        }

        int getValue() {
            return this.font.getSize();
        }

        Font getFont() {
            return this.font;
        }

        void setValue(int n) {
            this.font = new Font("monospaced", 1, n);
            this.fireChanged();
        }
    }

    private static class EvaluationOrderOption
    extends IntOption {
        EvaluationOrderOption(int n) {
            super("Evaluation Order", "evaluation_order", n, null);
        }

        JMenuItem createMenuItem() {
            JMenu jMenu = new JMenu("Evaluation Order");
            ButtonGroup buttonGroup = new ButtonGroup();
            jMenu.add(new SubItem(0, "Applicative (Eager)", buttonGroup));
            jMenu.add(new SubItem(1, "Normal (Lazy)", buttonGroup));
            jMenu.add(new SubItem(2, "Normal Without Thunks", buttonGroup));
            return jMenu;
        }

        String getParameterDescription() {
            return "{applicative,normal,normal_slow}";
        }

        void setValue(String string) throws NumberFormatException {
            if (string.equals("applicative")) {
                this.setValue(0);
            } else if (string.equals("normal")) {
                this.setValue(1);
            } else if (string.equals("normal_slow")) {
                this.setValue(2);
            } else {
                throw new NumberFormatException("invalid evaluation order");
            }
        }

        private class SubItem
        extends JRadioButtonMenuItem
        implements ActionListener {
            int value;

            SubItem(int n, String string, ButtonGroup buttonGroup) {
                super(string);
                this.value = n;
                buttonGroup.add(this);
                this.setSelected(EvaluationOrderOption.this.getValue() == n);
                this.addActionListener(this);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (this.isSelected()) {
                    EvaluationOrderOption.this.setValue(this.value);
                }
            }
        }
    }

    static class IntOption
    extends Option {
        protected String title;
        private int value;
        private int[] options;

        IntOption(String string, String string2, int n, int[] nArray) {
            super(string2);
            this.title = string;
            this.setValue(n);
            this.options = nArray;
        }

        JMenuItem createMenuItem() {
            JMenu jMenu = new JMenu(this.title);
            ButtonGroup buttonGroup = new ButtonGroup();
            boolean bl = false;
            int n = this.getValue();
            int n2 = 0;
            while (n2 < this.options.length) {
                if (!bl && n < this.options[n2]) {
                    jMenu.add(new SubItem(n, buttonGroup));
                    bl = true;
                }
                if (n == this.options[n2]) {
                    bl = true;
                }
                jMenu.add(new SubItem(this.options[n2], buttonGroup));
                ++n2;
            }
            if (!bl) {
                jMenu.add(new SubItem(n, buttonGroup));
            }
            return jMenu;
        }

        String getParameterDescription() {
            return "#";
        }

        void setValue(String string) throws NumberFormatException {
            this.setValue(Integer.parseInt(string));
        }

        void setValue(int n) {
            this.value = n;
            this.fireChanged();
        }

        int getValue() {
            return this.value;
        }

        private class SubItem
        extends JRadioButtonMenuItem
        implements ActionListener {
            int value;

            SubItem(int n, ButtonGroup buttonGroup) {
                super(n == Integer.MAX_VALUE ? "none" : "" + n);
                this.value = n;
                buttonGroup.add(this);
                this.setSelected(IntOption.this.getValue() == n);
                this.addActionListener(this);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (this.isSelected()) {
                    IntOption.this.setValue(this.value);
                }
            }
        }
    }

    private static class PrintLambdaOption
    extends BooleanOption {
        PrintLambdaOption(boolean bl) {
            super("Print Lambda Character", "print_lambda", bl);
        }

        JMenuItem createMenuItem() {
            return new Item();
        }

        char getLambdaChar() {
            if (this.getValue() && Options.getFont().canDisplay('\u03bb')) {
                return '\u03bb';
            }
            return '\\';
        }

        private class Item
        extends JCheckBoxMenuItem
        implements Listener,
        ActionListener {
            Item() {
                super(PrintLambdaOption.this.title);
                this.setSelected(PrintLambdaOption.this.getValue());
                this.addActionListener(this);
                Options.getFontSizeOption().addListener(this);
                this.valueChanged(null);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                PrintLambdaOption.this.setValue(this.isSelected());
            }

            public void valueChanged(Option option) {
                this.setEnabled(this.getFont().canDisplay('\u03bb'));
            }
        }
    }

    static class BooleanOption
    extends Option {
        protected String title;
        private boolean value;

        BooleanOption(String string, String string2, boolean bl) {
            super(string2);
            this.title = string;
            this.value = bl;
        }

        JMenuItem createMenuItem() {
            return new Item();
        }

        String getParameterDescription() {
            return "{yes,no}";
        }

        void setValue(String string) throws NumberFormatException {
            if (string.equals("yes")) {
                this.setValue(true);
            } else if (string.equals("no")) {
                this.setValue(false);
            } else {
                throw new NumberFormatException("cannot set yes/no value to '" + string + "'");
            }
        }

        void setValue(boolean bl) {
            this.value = bl;
            this.fireChanged();
        }

        boolean getValue() {
            return this.value;
        }

        private class Item
        extends JCheckBoxMenuItem
        implements ActionListener {
            Item() {
                super(BooleanOption.this.title);
                this.setSelected(BooleanOption.this.getValue());
                this.addActionListener(this);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                BooleanOption.this.setValue(this.isSelected());
            }
        }
    }

    static abstract class Option {
        private LinkedList listeners = new LinkedList();
        private String name;

        Option(String string) {
            this.name = string;
        }

        abstract JMenuItem createMenuItem();

        abstract void setValue(String var1) throws NumberFormatException;

        abstract String getParameterDescription();

        public String getName() {
            return this.name;
        }

        void addListener(Listener listener) {
            this.listeners.add(listener);
        }

        void removeListener(Listener listener) {
            this.listeners.remove(listener);
        }

        protected void fireChanged() {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                Listener listener = (Listener)iterator.next();
                listener.valueChanged(this);
            }
        }
    }

    static interface Listener {
        public void valueChanged(Option var1);
    }
}

