/*
 * Decompiled with CFR 0.152.
 */
package lambda;

import java.util.HashMap;
import lambda.Expr;
import lambda.Symbol;

class Parser {
    private static final int LAMBDA = 0;
    private static final int LPAREN = 1;
    private static final int RPAREN = 2;
    private static final int LBRACKET = 3;
    private static final int RBRACKET = 4;
    private static final int LBRACE = 5;
    private static final int RBRACE = 6;
    private static final int DOT = 7;
    private static final int ID = 8;
    private static final int EOF = 9;

    Parser() {
    }

    private static Expr parseFactor(Scanner scanner, HashMap hashMap) throws ParseException {
        Expr expr;
        switch (scanner.getCurrent()) {
            case 8: {
                String string = scanner.getCurrentData();
                Symbol symbol = (Symbol)hashMap.get(string);
                if (symbol == null) {
                    symbol = new Symbol(string);
                    hashMap.put(string, symbol);
                }
                expr = new Expr.Ident(symbol);
                scanner.chomp();
                break;
            }
            case 1: {
                scanner.chomp();
                expr = Parser.parseExpr(scanner, hashMap);
                if (scanner.getCurrent() != 2) {
                    throw new ParseException(scanner, "Right parenthesis missing");
                }
                scanner.chomp();
                break;
            }
            case 3: {
                scanner.chomp();
                expr = Parser.parseExpr(scanner, hashMap);
                if (scanner.getCurrent() != 4) {
                    throw new ParseException(scanner, "Right bracket missing");
                }
                scanner.chomp();
                break;
            }
            case 5: {
                scanner.chomp();
                expr = Parser.parseExpr(scanner, hashMap);
                if (scanner.getCurrent() != 6) {
                    throw new ParseException(scanner, "Right brace missing");
                }
                scanner.chomp();
                break;
            }
            case 0: {
                scanner.chomp();
                if (scanner.getCurrent() != 8) {
                    throw new ParseException(scanner, "Parameter name missing following lambda");
                }
                String string = scanner.getCurrentData();
                Symbol symbol = (Symbol)hashMap.get(string);
                Symbol symbol2 = new Symbol(string);
                hashMap.put(string, symbol2);
                scanner.chomp();
                if (scanner.getCurrent() != 7) {
                    throw new ParseException(scanner, "Period missing following parameter name");
                }
                scanner.chomp();
                expr = new Expr.Abstract(symbol2, Parser.parseExpr(scanner, hashMap));
                if (symbol == null) {
                    hashMap.remove(string);
                    break;
                }
                hashMap.put(string, symbol);
                break;
            }
            default: {
                throw new ParseException(scanner, "Unexpected token");
            }
        }
        return expr;
    }

    private static Expr parseExpr(Scanner scanner, HashMap hashMap) throws ParseException {
        Expr expr = Parser.parseFactor(scanner, hashMap);
        while (scanner.getCurrent() != 9 && scanner.getCurrent() != 2) {
            expr = new Expr.Apply(expr, Parser.parseFactor(scanner, hashMap));
        }
        return expr;
    }

    static Expr parse(String string) throws ParseException {
        Scanner scanner = new Scanner(string);
        HashMap hashMap = new HashMap();
        Expr expr = Parser.parseExpr(scanner, hashMap);
        if (scanner.getCurrent() != 9) {
            throw new ParseException(scanner, "Could not parse all of expression");
        }
        return expr;
    }

    private static class Scanner {
        String source;
        int pos;
        int next;
        int cur;
        String data;

        Scanner(String string) {
            this.source = string;
            this.pos = 0;
            this.next = 0;
            this.chomp();
        }

        int getCurrent() {
            return this.cur;
        }

        String getCurrentData() {
            return this.data;
        }

        void chomp() {
            int n = this.source.length();
            this.pos = this.next;
            while (this.pos < n && Character.isWhitespace(this.source.charAt(this.pos))) {
                ++this.pos;
            }
            if (this.pos == n) {
                this.next = n;
                this.cur = 9;
                return;
            }
            this.next = this.pos + 1;
            switch (this.source.charAt(this.pos)) {
                case '\\': 
                case '\u03bb': {
                    this.cur = 0;
                    break;
                }
                case '(': {
                    this.cur = 1;
                    break;
                }
                case ')': {
                    this.cur = 2;
                    break;
                }
                case '[': {
                    this.cur = 3;
                    break;
                }
                case ']': {
                    this.cur = 4;
                    break;
                }
                case '{': {
                    this.cur = 5;
                    break;
                }
                case '}': {
                    this.cur = 6;
                    break;
                }
                case '.': {
                    this.cur = 7;
                    break;
                }
                default: {
                    this.cur = 8;
                    while (this.next < n) {
                        char c = this.source.charAt(this.next);
                        if (Character.isWhitespace(c) || "\\().".indexOf(c) >= 0) break;
                        ++this.next;
                    }
                    this.data = this.source.substring(this.pos, this.next);
                }
            }
        }
    }

    static class ParseException
    extends Exception {
        public ParseException(Scanner scanner, String string) {
            super(scanner.pos + ": " + string);
        }
    }
}

