/*
 * Decompiled with CFR 0.152.
 */
package lambda;

import java.util.HashMap;
import lambda.Builtin;
import lambda.Expr;
import lambda.Options;
import lambda.Symbol;

class Simplify {
    static final int EAGER_EVALUATION = 0;
    static final int LAZY_EVALUATION = 1;
    static final int LAZY_SLOW_EVALUATION = 2;

    Simplify() {
    }

    static Expr simplify(Expr expr) {
        boolean bl = Options.getEtaReductionsOption().getValue();
        boolean bl2 = Options.getUseAppliedOption().getValue();
        int n = Options.getEvaluationOrderOption().getValue();
        CandidateFinder candidateFinder = n == 0 ? new EagerCandidateFinder(bl, bl2) : new LazyCandidateFinder(bl, bl2);
        Expr expr2 = (Expr)expr.visit(candidateFinder);
        if (expr2 == null) {
            return expr;
        }
        Expr expr3 = candidateFinder.getReplacement(expr2);
        Expr.Visitor visitor = n == 0 ? new EagerSubstitutor(expr2, expr3) : (n == 2 ? new LazySlowSubstitutor(expr2, expr3) : new LazySubstitutor(expr2, expr3));
        return (Expr)expr.visit(visitor);
    }

    private static class LazySlowSubstitutor
    implements Expr.Visitor {
        Expr source;
        Expr dest;

        LazySlowSubstitutor(Expr expr, Expr expr2) {
            this.source = expr;
            this.dest = expr2;
        }

        public Object visitAbstract(Expr.Abstract abstract_) {
            if (abstract_ == this.source) {
                return this.dest;
            }
            Expr expr = (Expr)abstract_.expr.visit(this);
            return expr == abstract_.expr ? abstract_ : new Expr.Abstract(abstract_.sym, expr);
        }

        public Object visitApply(Expr.Apply apply) {
            if (apply == this.source) {
                return this.dest;
            }
            Expr expr = (Expr)apply.left.visit(this);
            if (expr != apply.left) {
                return new Expr.Apply(expr, apply.right);
            }
            Expr expr2 = (Expr)apply.right.visit(this);
            if (expr2 != apply.right) {
                return new Expr.Apply(apply.left, expr2);
            }
            return apply;
        }

        public Object visitIdent(Expr.Ident ident) {
            return ident == this.source ? this.dest : ident;
        }
    }

    private static class EagerSubstitutor
    implements Expr.Visitor {
        Expr source;
        Expr dest;

        EagerSubstitutor(Expr expr, Expr expr2) {
            this.source = expr;
            this.dest = expr2;
        }

        public Object visitAbstract(Expr.Abstract abstract_) {
            if (abstract_ == this.source) {
                return this.dest;
            }
            Expr expr = (Expr)abstract_.expr.visit(this);
            return expr == abstract_.expr ? abstract_ : new Expr.Abstract(abstract_.sym, expr);
        }

        public Object visitApply(Expr.Apply apply) {
            if (apply == this.source) {
                return this.dest;
            }
            Expr expr = (Expr)apply.right.visit(this);
            if (expr != apply.right) {
                return new Expr.Apply(apply.left, expr);
            }
            Expr expr2 = (Expr)apply.left.visit(this);
            if (expr2 != apply.left) {
                return new Expr.Apply(expr2, apply.right);
            }
            return apply;
        }

        public Object visitIdent(Expr.Ident ident) {
            return ident == this.source ? this.dest : ident;
        }
    }

    private static class LazySubstitutor
    implements Expr.Visitor {
        HashMap creations = new HashMap();
        Expr source;
        Expr dest;

        LazySubstitutor(Expr expr, Expr expr2) {
            this.source = expr;
            this.dest = expr2;
        }

        public Object visitAbstract(Expr.Abstract abstract_) {
            if (abstract_ == this.source) {
                return this.dest;
            }
            Expr expr = (Expr)abstract_.expr.visit(this);
            if (expr == abstract_.expr) {
                return abstract_;
            }
            Expr expr2 = (Expr)this.creations.get(abstract_);
            if (expr2 == null) {
                expr2 = new Expr.Abstract(abstract_.sym, expr);
                this.creations.put(abstract_, expr2);
            }
            return expr2;
        }

        public Object visitApply(Expr.Apply apply) {
            if (apply == this.source) {
                return this.dest;
            }
            Expr expr = (Expr)apply.left.visit(this);
            Expr expr2 = (Expr)apply.right.visit(this);
            if (expr == apply.left && expr2 == apply.right) {
                return apply;
            }
            Expr expr3 = (Expr)this.creations.get(apply);
            if (expr3 == null) {
                expr3 = new Expr.Apply(expr, expr2);
                this.creations.put(apply, expr3);
            }
            return expr3;
        }

        public Object visitIdent(Expr.Ident ident) {
            return ident == this.source ? this.dest : ident;
        }
    }

    private static class SymbolSubstitutor
    implements Expr.Visitor {
        Symbol to_find;
        Expr to_replace;

        SymbolSubstitutor(Symbol symbol, Expr expr) {
            this.to_find = symbol;
            this.to_replace = expr;
        }

        public Object visitAbstract(Expr.Abstract abstract_) {
            if (abstract_.sym == this.to_find) {
                return abstract_;
            }
            Expr expr = (Expr)abstract_.expr.visit(this);
            return expr == abstract_.expr ? abstract_ : new Expr.Abstract(abstract_.sym, expr);
        }

        public Object visitApply(Expr.Apply apply) {
            Expr expr = (Expr)apply.left.visit(this);
            Expr expr2 = (Expr)apply.right.visit(this);
            if (expr == apply.left && expr2 == apply.right) {
                return apply;
            }
            return new Expr.Apply(expr, expr2);
        }

        public Object visitIdent(Expr.Ident ident) {
            return ident.sym == this.to_find ? this.to_replace : ident;
        }
    }

    private static class EagerCandidateFinder
    extends CandidateFinder {
        EagerCandidateFinder(boolean bl, boolean bl2) {
            super(bl, bl2);
        }

        public Object visitApply(Expr.Apply apply) {
            Object object = apply.right.visit(this);
            if (object != null) {
                return object;
            }
            if (this.isCandidate(apply)) {
                return apply;
            }
            return apply.left.visit(this);
        }
    }

    private static class LazyCandidateFinder
    extends CandidateFinder {
        LazyCandidateFinder(boolean bl, boolean bl2) {
            super(bl, bl2);
        }

        public Object visitApply(Expr.Apply apply) {
            if (this.isCandidate(apply)) {
                return apply;
            }
            Object object = apply.left.visit(this);
            if (object != null) {
                return object;
            }
            return apply.right.visit(this);
        }
    }

    private static abstract class CandidateFinder
    implements Expr.Visitor {
        boolean use_etas;
        boolean use_applied;

        CandidateFinder(boolean bl, boolean bl2) {
            this.use_etas = bl;
            this.use_applied = bl2;
        }

        public Object visitAbstract(Expr.Abstract abstract_) {
            if (this.isCandidate(abstract_)) {
                return abstract_;
            }
            return abstract_.expr.visit(this);
        }

        public abstract Object visitApply(Expr.Apply var1);

        public Object visitIdent(Expr.Ident ident) {
            if (this.isCandidate(ident)) {
                return ident;
            }
            return null;
        }

        boolean isCandidate(Expr expr) {
            Object object;
            Object object2;
            Expr expr2;
            Object object3;
            if (expr instanceof Expr.Apply) {
                object3 = ((Expr.Apply)expr).left;
                expr2 = ((Expr.Apply)expr).right;
                if (object3 instanceof Expr.Abstract) {
                    return true;
                }
            }
            if (this.use_etas && expr instanceof Expr.Abstract) {
                object3 = ((Expr.Abstract)expr).sym;
                expr2 = ((Expr.Abstract)expr).expr;
                if (expr2 instanceof Expr.Apply) {
                    object2 = ((Expr.Apply)expr2).left;
                    object = ((Expr.Apply)expr2).right;
                    if (object instanceof Expr.Ident && ((Expr.Ident)object).sym == object3 && !((Expr)object2).uses((Symbol)object3)) {
                        return true;
                    }
                }
            }
            if (this.use_applied) {
                object3 = expr;
                int n = 0;
                while (object3 instanceof Expr.Apply) {
                    object3 = ((Expr.Apply)object3).left;
                    ++n;
                }
                if (object3 instanceof Expr.Ident && (object = Builtin.get((String)(object2 = ((Expr.Ident)object3).sym.toString()), n)) != null) {
                    Expr[] exprArray = new Expr[n];
                    object3 = expr;
                    int n2 = n - 1;
                    while (object3 instanceof Expr.Apply) {
                        exprArray[n2] = ((Expr.Apply)object3).right;
                        --n2;
                        object3 = ((Expr.Apply)object3).left;
                    }
                    if (((Builtin)object).canApply(exprArray)) {
                        return true;
                    }
                }
            }
            return false;
        }

        Expr getReplacement(Expr expr) {
            Expr expr2;
            Expr expr3;
            if (expr instanceof Expr.Apply) {
                expr3 = ((Expr.Apply)expr).left;
                expr2 = ((Expr.Apply)expr).right;
                if (expr3 instanceof Expr.Abstract) {
                    Expr.Abstract abstract_ = (Expr.Abstract)expr3;
                    return (Expr)abstract_.expr.visit(new SymbolSubstitutor(abstract_.sym, expr2));
                }
            }
            if (this.use_etas && expr instanceof Expr.Abstract && (expr3 = ((Expr.Abstract)expr).expr) instanceof Expr.Apply) {
                expr2 = ((Expr.Apply)expr3).left;
                return expr2;
            }
            if (this.use_applied) {
                String string;
                Builtin builtin;
                expr3 = expr;
                int n = 0;
                while (expr3 instanceof Expr.Apply) {
                    expr3 = ((Expr.Apply)expr3).left;
                    ++n;
                }
                if (expr3 instanceof Expr.Ident && (builtin = Builtin.get(string = ((Expr.Ident)expr3).sym.toString(), n)) != null) {
                    Expr[] exprArray = new Expr[n];
                    expr3 = expr;
                    int n2 = n - 1;
                    while (expr3 instanceof Expr.Apply) {
                        exprArray[n2] = ((Expr.Apply)expr3).right;
                        --n2;
                        expr3 = ((Expr.Apply)expr3).left;
                    }
                    return builtin.apply(exprArray);
                }
            }
            return null;
        }
    }
}

