/*
 * Decompiled with CFR 0.152.
 */
package lambda;

import java.util.HashMap;
import lambda.Expr;
import lambda.Symbol;

class ExprWrapper {
    private static final Boolean TRUE = Boolean.TRUE;
    private static final Boolean FALSE = Boolean.FALSE;
    private final Expr expr;
    private boolean hash_code_known = false;
    private int hash_code_val;

    public ExprWrapper(Expr expr) {
        this.expr = expr;
    }

    public int hashCode() {
        if (!this.hash_code_known) {
            Integer n = (Integer)this.expr.visit(new HashCodeComputer());
            this.hash_code_val = n;
            this.hash_code_known = true;
        }
        return this.hash_code_val;
    }

    public boolean equals(Object object) {
        if (object instanceof ExprWrapper) {
            ExprWrapper exprWrapper = (ExprWrapper)object;
            if (exprWrapper.hashCode() != this.hashCode()) {
                return false;
            }
            if (exprWrapper.expr == this.expr) {
                return true;
            }
            return this.expr.visitP(new EqualsVisitor(), exprWrapper.expr) == TRUE;
        }
        if (object instanceof Expr) {
            return this.equals(new ExprWrapper((Expr)object));
        }
        return false;
    }

    private static class HashCodeComputer
    implements Expr.Visitor {
        private HashMap sym_map = new HashMap();
        int last_ident = 0;

        private HashCodeComputer() {
        }

        public Object visitAbstract(Expr.Abstract abstract_) {
            ++this.last_ident;
            this.sym_map.put(abstract_.sym, new Integer(this.last_ident));
            Object object = abstract_.expr.visit(this);
            this.sym_map.remove(abstract_.sym);
            return object;
        }

        public Object visitApply(Expr.Apply apply) {
            int n = (Integer)apply.left.visit(this);
            int n2 = (Integer)apply.right.visit(this);
            return new Integer(n * 31 + n2);
        }

        public Object visitIdent(Expr.Ident ident) {
            Integer n = (Integer)this.sym_map.get(ident.sym);
            if (n == null) {
                n = new Integer(ident.sym.toString().hashCode());
            }
            return n;
        }
    }

    private static class EqualsVisitor
    implements Expr.VisitorP {
        HashMap sym_map = new HashMap();

        private EqualsVisitor() {
        }

        public Object visitAbstract(Expr.Abstract abstract_, Object object) {
            if (!(object instanceof Expr.Abstract)) {
                return FALSE;
            }
            Expr.Abstract abstract_2 = (Expr.Abstract)object;
            this.sym_map.put(abstract_.sym, abstract_2.sym);
            Object object2 = abstract_.expr.visitP(this, abstract_2.expr);
            this.sym_map.remove(abstract_.sym);
            return object2;
        }

        public Object visitApply(Expr.Apply apply, Object object) {
            if (!(object instanceof Expr.Apply)) {
                return FALSE;
            }
            Expr.Apply apply2 = (Expr.Apply)object;
            if (apply.left.visitP(this, apply2.left) == FALSE) {
                return FALSE;
            }
            if (apply.right.visitP(this, apply2.right) == FALSE) {
                return FALSE;
            }
            return TRUE;
        }

        public Object visitIdent(Expr.Ident ident, Object object) {
            if (!(object instanceof Expr.Ident)) {
                return FALSE;
            }
            Expr.Ident ident2 = (Expr.Ident)object;
            Symbol symbol = (Symbol)this.sym_map.get(ident.sym);
            if (symbol == null) {
                if (ident.sym.toString().equals(ident2.sym.toString())) {
                    return TRUE;
                }
                return FALSE;
            }
            return ident2.sym == symbol ? TRUE : FALSE;
        }
    }
}

