/*
 * Decompiled with CFR 0.152.
 */
package lambda;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URL;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;
import lambda.Context;
import lambda.Engine;
import lambda.Expr;
import lambda.HelpFrame;
import lambda.LambdaText;
import lambda.Options;

class Gui
extends JFrame {
    private static final String HELP_BASE_DIR = "lambda/doc/";
    private JTextField sym_name;
    private JTextField input;
    private JTextArea output;
    private JScrollPane output_pane;
    private SymbolBrowser browser;
    private JScrollPane browser_pane;
    private JSplitPane main_pane;
    private Context context = new Context();
    private Engine engine = new Engine(this);
    private JFileChooser chooser = new JFileChooser();

    public Gui() {
        super("Lambda Calculator");
        Options.getFontSizeOption().addListener(new FontListener());
        this.addWindowListener(new MyWindowListener());
        Font font = Options.getFont();
        JMenuBar jMenuBar = new JMenuBar();
        MenuFile menuFile = new MenuFile();
        MenuEdit menuEdit = new MenuEdit();
        JMenu jMenu = Options.getMenu();
        MenuHelp menuHelp = new MenuHelp();
        this.setJMenuBar(jMenuBar);
        jMenuBar.add(menuFile);
        jMenuBar.add(menuEdit);
        jMenuBar.add(jMenu);
        jMenuBar.add(menuHelp);
        this.sym_name = LambdaText.createTextField(7);
        this.sym_name.setFont(font);
        this.sym_name.addActionListener(new MySymNameListener());
        this.sym_name.addFocusListener(menuEdit);
        this.sym_name.addFocusListener(new SelectAllListener());
        this.input = LambdaText.createTextField(30);
        this.input.setFont(font);
        this.input.addActionListener(new MyInputListener());
        this.input.addFocusListener(menuEdit);
        this.input.addFocusListener(new SelectAllListener());
        this.output = LambdaText.createTextArea();
        this.output.setFont(font);
        this.output.setEditable(false);
        this.output.addFocusListener(menuEdit);
        this.output_pane = new JScrollPane(this.output);
        this.browser = new SymbolBrowser();
        this.input.getDocument().addDocumentListener(this.browser);
        this.browser.addFocusListener(menuEdit);
        this.browser_pane = new JScrollPane(this.browser);
        Container container = this.getContentPane();
        this.main_pane = new JSplitPane(1);
        this.main_pane.setRightComponent(this.output_pane);
        if (Options.getShowBrowserOption().getValue()) {
            this.main_pane.setLeftComponent(this.browser_pane);
            this.main_pane.setDividerLocation(70);
        }
        container.add((Component)this.makeInputPanel(), "North");
        container.add((Component)this.main_pane, "Center");
        this.pack();
    }

    private JPanel makeInputPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        JLabel jLabel = new JLabel("Define");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagLayout.setConstraints(this.sym_name, gridBagConstraints);
        jPanel.add(this.sym_name);
        JLabel jLabel2 = new JLabel("as");
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        jPanel.add(jLabel2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.input, gridBagConstraints);
        jPanel.add(this.input);
        return jPanel;
    }

    JTextArea getOutputArea() {
        return this.output;
    }

    Context getContext() {
        return this.context;
    }

    private class FontListener
    implements Options.Listener {
        private FontListener() {
        }

        public void valueChanged(Options.Option option) {
            Font font = Options.getFont();
            Gui.this.sym_name.setFont(font);
            Gui.this.input.setFont(font);
            Gui.this.output.setFont(font);
            Gui.this.pack();
        }
    }

    private class SymbolBrowser
    extends JList
    implements ListSelectionListener,
    DocumentListener,
    Options.Listener {
        int sel_index;
        String input_val;

        SymbolBrowser() {
            super(Gui.this.context);
            this.setSelectionMode(0);
            this.addListSelectionListener(this);
            Options.getShowBrowserOption().addListener(this);
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            String string = (String)Gui.this.browser.getSelectedValue();
            if (string == null) {
                return;
            }
            Expr expr = Gui.this.context.get(string);
            if (expr != null && this.sel_index != Gui.this.browser.getSelectedIndex()) {
                String string2 = expr.toStringSubstituteBelow(Gui.this.context, Integer.MAX_VALUE, Options.getVaryParenthesesOption().getValue());
                this.input_val = string2.replace('\\', Options.getLambdaChar());
                this.sel_index = Gui.this.browser.getSelectedIndex();
                Gui.this.input.setText(this.input_val);
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            if (Gui.this.input.getText().equals(this.input_val)) {
                Gui.this.browser.setSelectedIndex(this.sel_index);
            } else {
                Gui.this.browser.clearSelection();
            }
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            if (Gui.this.input.getText().equals(this.input_val)) {
                Gui.this.browser.setSelectedIndex(this.sel_index);
            } else {
                Gui.this.browser.clearSelection();
            }
        }

        public void valueChanged(Options.Option option) {
            if (((Options.BooleanOption)option).getValue()) {
                Gui.this.main_pane.setLeftComponent(Gui.this.browser_pane);
            } else {
                Gui.this.main_pane.remove(Gui.this.browser_pane);
            }
            Gui.this.pack();
        }
    }

    private class MyInputListener
    implements ActionListener {
        private MyInputListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = Gui.this.sym_name.getText();
            String string2 = Gui.this.input.getText();
            Gui.this.engine.addDefinition(string, string2);
            Gui.this.sym_name.setText("");
            Gui.this.sym_name.requestFocus();
        }
    }

    private class MySymNameListener
    implements ActionListener {
        private MySymNameListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Gui.this.input.requestFocus();
        }
    }

    private class MyWindowListener
    extends WindowAdapter {
        private MyWindowListener() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            int n = JOptionPane.showConfirmDialog(Gui.this, "Are you sure you want to exit?", "Confirm Exit", 0);
            if (n == 0) {
                System.exit(0);
            }
        }
    }

    private class SelectAllListener
    implements FocusListener {
        private SelectAllListener() {
        }

        public void focusGained(FocusEvent focusEvent) {
            JTextComponent jTextComponent = (JTextComponent)focusEvent.getSource();
            jTextComponent.selectAll();
        }

        public void focusLost(FocusEvent focusEvent) {
        }
    }

    private class MenuHelp
    extends JMenu
    implements ActionListener {
        JMenuItem help = new JMenuItem("Help");
        JMenuItem about = new JMenuItem("About");
        HelpFrame frame = null;
        URL index = null;

        MenuHelp() {
            super("Help");
            this.add(this.help);
            this.help.addActionListener(this);
            this.add(this.about);
            this.about.addActionListener(this);
            this.frame = new HelpFrame("lambda/doc/index.html");
            this.frame.setTitle("Logisim Help");
            this.index = this.frame.getCurrent();
            this.frame.addContentsItem("Contents", this.index);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.help) {
                this.frame.load(this.index);
                this.frame.show();
            } else if (actionEvent.getSource() == this.about) {
                JOptionPane.showMessageDialog(Gui.this, "Lambda Calculator, v1.01. (c) 2003, Carl Burch. See www.cburch.com/proj/lambda for details.");
            }
        }
    }

    private class MenuEdit
    extends JMenu
    implements ActionListener,
    FocusListener {
        JMenuItem cut = new JMenuItem("Cut");
        JMenuItem copy = new JMenuItem("Copy");
        JMenuItem paste = new JMenuItem("Paste");
        JTextComponent component = null;

        MenuEdit() {
            super("Edit");
            this.add(this.cut);
            this.cut.addActionListener(this);
            this.add(this.copy);
            this.copy.addActionListener(this);
            this.add(this.paste);
            this.paste.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl;
            boolean bl2 = bl = this.component != Gui.this.output;
            if (actionEvent.getSource() == this.cut) {
                if (bl) {
                    this.component.cut();
                }
            } else if (actionEvent.getSource() == this.copy) {
                this.component.copy();
            } else if (actionEvent.getSource() == this.paste && bl) {
                this.component.paste();
            }
        }

        public void focusGained(FocusEvent focusEvent) {
            if (focusEvent.isTemporary()) {
                return;
            }
            Object object = focusEvent.getSource();
            if (object instanceof JTextComponent) {
                boolean bl = ((JTextComponent)object).isEditable();
                this.cut.setEnabled(bl);
                this.copy.setEnabled(true);
                this.paste.setEnabled(bl);
            } else {
                this.cut.setEnabled(false);
                this.copy.setEnabled(false);
                this.paste.setEnabled(false);
            }
        }

        public void focusLost(FocusEvent focusEvent) {
        }
    }

    private class MenuFile
    extends JMenu
    implements ActionListener {
        JMenuItem open = new JMenuItem("Import...");
        JMenuItem save = new JMenuItem("Export...");
        JMenuItem quit = new JMenuItem("Quit");

        MenuFile() {
            super("File");
            this.add(this.open);
            this.open.addActionListener(this);
            this.add(this.save);
            this.save.addActionListener(this);
            this.add(this.quit);
            this.quit.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.open) {
                int n = Gui.this.chooser.showOpenDialog(Gui.this);
                if (n == 0) {
                    try {
                        Gui.this.context.importFile(Gui.this.chooser.getSelectedFile());
                    }
                    catch (IOException iOException) {
                        JOptionPane.showMessageDialog(Gui.this, "Error importing: " + iOException, "Import Error", 0);
                    }
                }
            } else if (actionEvent.getSource() == this.save) {
                int n = Gui.this.chooser.showSaveDialog(Gui.this);
                if (n == 0) {
                    try {
                        Gui.this.context.exportFile(Gui.this.chooser.getSelectedFile());
                    }
                    catch (IOException iOException) {
                        JOptionPane.showMessageDialog(Gui.this, "Error exporting: " + iOException, "Export Error", 0);
                    }
                }
            } else if (actionEvent.getSource() == this.quit) {
                new MyWindowListener().windowClosing(null);
            }
        }
    }
}

