/*
 * Decompiled with CFR 0.152.
 */
package pnmviewer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.print.PageFormat;
import java.util.StringTokenizer;
import javax.swing.JPanel;
import pnmviewer.ImageUtil;

class Canvas
extends JPanel {
    private static final int BORDER = 5;
    private static final int IMG_TEXT_SEP = 20;
    private Image img = null;
    private double scale = 1.0;
    private AffineTransform xform = new AffineTransform();
    private Dimension size = null;
    private Dimension dims = new Dimension();

    public Canvas() {
        this.setBackground(Color.lightGray);
        this.xform.translate(5.0, 5.0);
    }

    public void setImage(Image image) {
        this.img = image;
        this.setMyDimension();
        this.repaint();
    }

    public Image getImage() {
        return this.img;
    }

    private void setMyDimension() {
        if (this.img != null) {
            this.size = ImageUtil.getDimension(this.img);
            if (this.size == null) {
                return;
            }
            this.size.setSize(this.size.getWidth() * this.scale, this.size.getHeight() * this.scale);
            this.dims.setSize(this.size.width + 10, this.size.height + 10);
            this.setPreferredSize(this.dims);
            this.revalidate();
        }
    }

    public void setMagnification(double d) {
        this.scale = d;
        this.xform = new AffineTransform();
        this.xform.translate(5.0, 5.0);
        this.xform.scale(d, d);
        this.setMyDimension();
        this.repaint();
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.img != null) {
            if (graphics instanceof Graphics2D) {
                ((Graphics2D)graphics).drawImage(this.img, this.xform, this);
            } else {
                graphics.drawImage(this.img, 0, 0, this);
            }
            graphics.setColor(Color.black);
            if (this.size != null) {
                graphics.drawRect(4, 4, this.size.width + 1, this.size.height + 1);
            }
        }
    }

    void print(Graphics graphics, PageFormat pageFormat, String string) {
        int n = (int)(pageFormat.getWidth() - this.size.getWidth()) / 2;
        int n2 = (int)Math.ceil(pageFormat.getImageableY());
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(n, n2);
        affineTransform.scale(this.scale, this.scale);
        if (graphics instanceof Graphics2D) {
            ((Graphics2D)graphics).drawImage(this.img, affineTransform, this);
        } else {
            graphics.drawImage(this.img, 0, 0, this);
        }
        n2 = (int)((double)n2 + (this.size.getHeight() + 20.0));
        n = (int)Math.ceil(pageFormat.getImageableX());
        int n3 = graphics.getFontMetrics().getHeight();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n", true);
        while (stringTokenizer.hasMoreTokens() && (double)n2 < pageFormat.getHeight()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("\n")) {
                n2 += n3;
                continue;
            }
            graphics.drawString(string2, n, n2);
        }
    }
}

