/*
 * Decompiled with CFR 0.152.
 */
package pnmviewer;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.ImageObserver;

class ImageUtil {
    ImageUtil() {
    }

    static Dimension getDimension(Image image) {
        Observer observer = new Observer();
        int n = image.getWidth(observer);
        int n2 = image.getHeight(observer);
        if (n < 0 || n2 < 0) {
            observer.waitUntilDone();
        }
        n = image.getWidth(observer);
        n2 = image.getHeight(observer);
        if (n < 0 || n2 < 0) {
            return null;
        }
        return new Dimension(n, n2);
    }

    private static class Observer
    implements ImageObserver {
        boolean done = false;

        private Observer() {
        }

        boolean isDone() {
            return this.done;
        }

        synchronized void waitUntilDone() {
            while (!this.isDone()) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        public synchronized boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
            if ((n & 0x20) != 0) {
                this.done = true;
                this.notifyAll();
                return false;
            }
            if ((n & 0x80) != 0) {
                this.done = true;
                this.notifyAll();
                return false;
            }
            return true;
        }
    }
}

