/*
 * Decompiled with CFR 0.152.
 */
package pnmviewer;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.ImageProducer;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.util.StringTokenizer;
import pnmviewer.ImageUtil;

class Pnm {
    private static final int TYPE_MONO = 0;
    private static final int TYPE_GRAY = 1;
    private static final int TYPE_COLOR = 2;

    Pnm() {
    }

    static String convertToText(Image image) throws PnmException {
        Dimension dimension = ImageUtil.getDimension(image);
        int n = (int)dimension.getWidth();
        int n2 = (int)dimension.getHeight();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("P3\n");
        stringBuffer.append(n + " " + n2 + "\n");
        stringBuffer.append("255\n");
        int[] nArray = new int[n * n2];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n, n2, nArray, 0, n);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            throw new PnmException("Interrupted waiting for pixels");
        }
        if ((pixelGrabber.getStatus() & 0x80) != 0) {
            throw new PnmException("Image fetch aborted or errored");
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            while (n4 < n) {
                int n5 = nArray[n3 * n + n4];
                int n6 = n5 >> 16 & 0xFF;
                int n7 = n5 >> 8 & 0xFF;
                int n8 = n5 & 0xFF;
                String string = n6 + " " + n7 + " " + n8;
                int n9 = stringBuffer2.length();
                if (n9 + 2 + string.length() < 80) {
                    if (n9 > 0) {
                        stringBuffer2.append("  ");
                    }
                } else {
                    stringBuffer2.append("\n");
                    stringBuffer.append(stringBuffer2);
                    stringBuffer2.delete(0, stringBuffer2.length());
                }
                stringBuffer2.append(string);
                ++n4;
            }
            if (stringBuffer2.length() > 0) {
                stringBuffer.append(stringBuffer2 + "\n");
                stringBuffer2.delete(0, stringBuffer2.length());
            }
            ++n3;
        }
        return stringBuffer.toString();
    }

    static ImageProducer convertFromText(String string) throws PnmException {
        int n;
        int n2;
        int n3;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (!stringTokenizer.hasMoreTokens()) {
            throw new PnmException("No text found");
        }
        String string2 = stringTokenizer.nextToken();
        if (string2.equals("P1")) {
            n3 = 0;
        } else if (string2.equals("P2")) {
            n3 = 1;
        } else if (string2.equals("P3")) {
            n3 = 2;
        } else {
            throw new PnmException("Unrecognized PNM type " + string2);
        }
        if (!stringTokenizer.hasMoreTokens()) {
            throw new PnmException("Width missing");
        }
        try {
            n2 = Integer.parseInt(stringTokenizer.nextToken());
        }
        catch (NumberFormatException numberFormatException) {
            throw new PnmException("Width must be a number");
        }
        if (!stringTokenizer.hasMoreTokens()) {
            throw new PnmException("Height missing");
        }
        try {
            n = Integer.parseInt(stringTokenizer.nextToken());
        }
        catch (NumberFormatException numberFormatException) {
            throw new PnmException("Height must be a number");
        }
        int[] nArray = new int[n2 * n];
        switch (n3) {
            case 0: {
                Pnm.readMono(nArray, stringTokenizer, n2, n);
                break;
            }
            case 1: {
                Pnm.readGray(nArray, stringTokenizer, n2, n);
                break;
            }
            case 2: {
                Pnm.readColor(nArray, stringTokenizer, n2, n);
            }
        }
        if (stringTokenizer.hasMoreTokens()) {
            throw new PnmException("More data found after final pixel");
        }
        return new MemoryImageSource(n2, n, nArray, 0, n2);
    }

    private static void readMono(int[] nArray, StringTokenizer stringTokenizer, int n, int n2) throws PnmException {
        int n3 = 0;
        while (n3 < nArray.length) {
            if (!stringTokenizer.hasMoreTokens()) {
                throw new PnmException("Missing pixel " + (n3 + 1));
            }
            String string = stringTokenizer.nextToken();
            if (string.equals("0")) {
                nArray[n3] = -1;
            } else if (string.equals("1")) {
                nArray[n3] = -16777216;
            } else {
                throw new PnmException("Pixel " + (n3 + 1) + " cannot be " + string);
            }
            ++n3;
        }
    }

    private static void readGray(int[] nArray, StringTokenizer stringTokenizer, int n, int n2) throws PnmException {
        int n3;
        if (!stringTokenizer.hasMoreTokens()) {
            throw new PnmException("Maximum value missing");
        }
        try {
            n3 = Integer.parseInt(stringTokenizer.nextToken());
        }
        catch (NumberFormatException numberFormatException) {
            throw new PnmException("Maximum value must be a number");
        }
        int n4 = 0;
        while (n4 < nArray.length) {
            if (!stringTokenizer.hasMoreTokens()) {
                throw new PnmException("Missing pixel " + (n4 + 1));
            }
            String string = stringTokenizer.nextToken();
            try {
                int n5 = Integer.parseInt(string);
                if (n5 < 0 || n5 > n3) {
                    throw new PnmException("Pixel " + (n4 + 1) + " cannot be " + string);
                }
                if ((n5 = 255 * n5 / n3) > 255) {
                    n5 = 255;
                }
                nArray[n4] = 0xFF000000 | n5 << 16 | n5 << 8 | n5;
            }
            catch (NumberFormatException numberFormatException) {
                throw new PnmException("Pixel " + (n4 + 1) + " cannot be " + string);
            }
            ++n4;
        }
    }

    private static void readColor(int[] nArray, StringTokenizer stringTokenizer, int n, int n2) throws PnmException {
        int n3;
        int[] nArray2 = new int[3];
        String[] stringArray = new String[]{"red", "green", "blue"};
        if (!stringTokenizer.hasMoreTokens()) {
            throw new PnmException("Maximum value missing");
        }
        try {
            n3 = Integer.parseInt(stringTokenizer.nextToken());
        }
        catch (NumberFormatException numberFormatException) {
            throw new PnmException("Maximum value must be a number");
        }
        int n4 = 0;
        while (n4 < nArray.length) {
            int n5 = 0;
            while (n5 < 3) {
                if (!stringTokenizer.hasMoreTokens()) {
                    throw new PnmException("Missing " + stringArray[n5] + " component of pixel " + (n4 + 1));
                }
                String string = stringTokenizer.nextToken();
                try {
                    nArray2[n5] = Integer.parseInt(string);
                    if (nArray2[n5] < 0 || nArray2[n5] > n3) {
                        throw new PnmException("Pixel " + (n4 + 1) + "'s " + stringArray[n5] + " component cannot be " + string);
                    }
                    nArray2[n5] = 255 * nArray2[n5] / n3;
                    if (nArray2[n5] > 255) {
                        nArray2[n5] = 255;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new PnmException("Pixel " + (n4 + 1) + "'s " + stringArray[n5] + " component cannot be " + string);
                }
                ++n5;
            }
            nArray[n4] = 0xFF000000 | nArray2[0] << 16 | nArray2[1] << 8 | nArray2[2];
            ++n4;
        }
    }

    static class PnmException
    extends Exception {
        PnmException(String string) {
            super(string);
        }
    }
}

