/*
 * Decompiled with CFR 0.152.
 */
package pnmviewer;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import pnmviewer.Canvas;
import pnmviewer.GifEncoder;
import pnmviewer.Pnm;

class Viewer
extends JFrame {
    private JFileChooser chooser = new JFileChooser();
    private Canvas canvas;
    private JTextArea editor;
    private String image_text = null;

    Viewer() {
        super("PNM Viewer");
        this.addWindowListener(new WindowListener());
        this.canvas = new Canvas();
        this.canvas.setPreferredSize(new Dimension(200, 200));
        this.editor = new JTextArea();
        this.editor.setFont(new Font("Monospaced", 0, 12));
        this.editor.setColumns(80);
        this.editor.setLineWrap(true);
        this.editor.setWrapStyleWord(true);
        JSplitPane jSplitPane = new JSplitPane(1, new JScrollPane(this.editor), new JScrollPane(this.canvas));
        jSplitPane.setOneTouchExpandable(true);
        this.getContentPane().add(jSplitPane);
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        JMenu jMenu = new JMenu("File");
        jMenuBar.add(jMenu);
        jMenu.add(new NewMenuItem());
        jMenu.add(new OpenMenuItem());
        jMenu.add(new ImportMenuItem());
        jMenu.add(new SaveMenuItem());
        jMenu.add(new JSeparator());
        jMenu.add(new QuitMenuItem());
        JMenu jMenu2 = new JMenu("Image");
        jMenuBar.add(jMenu2);
        jMenu2.add(new ViewMenuItem());
        jMenu2.add(new MagnifyMenuItem());
        jMenu2.add(new JSeparator());
        jMenu2.add(new PrintMenuItem());
        jMenu2.add(new ExportMenuItem());
        JMenu jMenu3 = new JMenu("Help");
        jMenuBar.add(jMenu3);
        jMenu3.add(new AboutMenuItem());
        this.pack();
    }

    void openFile(File file) {
        try {
            int n;
            FileReader fileReader = new FileReader(file);
            StringBuffer stringBuffer = new StringBuffer();
            char[] cArray = new char[1024];
            while ((n = fileReader.read(cArray)) >= 0) {
                stringBuffer.append(cArray, 0, n);
            }
            fileReader.close();
            this.editor.setText(stringBuffer.toString());
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, "Could not open file: " + iOException);
        }
    }

    void saveFile(File file) {
        try {
            FileWriter fileWriter = new FileWriter(file);
            String string = this.editor.getText();
            char[] cArray = new char[1024];
            int n = 0;
            while (n < string.length()) {
                int n2 = Math.min(cArray.length, string.length() - n);
                string.getChars(n, n + n2, cArray, 0);
                fileWriter.write(cArray, 0, n2);
                n += n2;
            }
            fileWriter.close();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, "Could not save file: " + iOException);
        }
    }

    public void doPrint() {
        if (this.image_text == null) {
            JOptionPane.showMessageDialog(this, "You must be viewing an image to print it.");
            return;
        }
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        if (!printerJob.printDialog()) {
            return;
        }
        try {
            printerJob.setPageable(new MyPageable());
            printerJob.print();
        }
        catch (PrinterException printerException) {
            JOptionPane.showMessageDialog(null, "Error during printing: " + printerException.toString());
        }
    }

    private class MyPageable
    implements Pageable {
        PageFormat format = new PageFormat();
        Printable printable = new MyPrintable();

        private MyPageable() {
        }

        public int getNumberOfPages() {
            return 1;
        }

        public PageFormat getPageFormat(int n) throws IndexOutOfBoundsException {
            if (n < 0 || n >= this.getNumberOfPages()) {
                throw new IndexOutOfBoundsException();
            }
            return this.format;
        }

        public Printable getPrintable(int n) throws IndexOutOfBoundsException {
            if (n < 0 || n >= this.getNumberOfPages()) {
                throw new IndexOutOfBoundsException();
            }
            return this.printable;
        }
    }

    private class MyPrintable
    implements Printable {
        private MyPrintable() {
        }

        public int getNumberOfPages(PageFormat pageFormat) {
            return 1;
        }

        public int print(Graphics graphics, PageFormat pageFormat, int n) {
            Viewer.this.canvas.print(graphics, pageFormat, Viewer.this.image_text);
            return 0;
        }
    }

    private class WindowListener
    extends WindowAdapter {
        private WindowListener() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            System.exit(0);
        }
    }

    private class AboutMenuItem
    extends JMenuItem
    implements ActionListener {
        AboutMenuItem() {
            super("About...");
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JOptionPane.showMessageDialog(Viewer.this, "PNM Viewer v0.01, (c) 2002, Carl Burch.See www.cburch.com/proj/pnmviewer for details.");
        }
    }

    private class ExportMenuItem
    extends JMenuItem
    implements ActionListener {
        ExportMenuItem() {
            super("Export GIF...");
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (Viewer.this.image_text == null) {
                JOptionPane.showMessageDialog(Viewer.this, "You must be viewing an image to export it.");
                return;
            }
            Viewer.this.chooser.setDialogTitle("Export");
            int n = Viewer.this.chooser.showSaveDialog(Viewer.this);
            if (n != 0) {
                return;
            }
            GifEncoder.toFile(Viewer.this.canvas.getImage(), Viewer.this.chooser.getSelectedFile());
        }
    }

    private class PrintMenuItem
    extends JMenuItem
    implements ActionListener {
        PrintMenuItem() {
            super("Print...");
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Viewer.this.doPrint();
        }
    }

    private class MagnifyMenuItem
    extends JMenuItem
    implements ActionListener {
        MagnifyMenuItem() {
            super("Set Magnification...");
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = JOptionPane.showInputDialog(Viewer.this, (Object)"What magnification do you want? (1.0 = no scaling)");
            if (string == null) {
                return;
            }
            try {
                double d = Double.parseDouble(string);
                Viewer.this.canvas.setMagnification(d);
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(Viewer.this, "Not a valid magnification factor: " + string);
            }
        }
    }

    private class ViewMenuItem
    extends JMenuItem
    implements ActionListener {
        ViewMenuItem() {
            super("View");
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = Viewer.this.editor.getText();
            try {
                Image image = Viewer.this.editor.createImage(Pnm.convertFromText(string));
                Viewer.this.canvas.setImage(image);
                Viewer.this.image_text = string;
            }
            catch (Pnm.PnmException pnmException) {
                JOptionPane.showMessageDialog(Viewer.this, "" + pnmException.getMessage());
            }
        }
    }

    private class QuitMenuItem
    extends JMenuItem
    implements ActionListener {
        QuitMenuItem() {
            super("Quit");
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            System.exit(0);
        }
    }

    private class SaveMenuItem
    extends JMenuItem
    implements ActionListener {
        SaveMenuItem() {
            super("Save...");
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Viewer.this.chooser.setDialogTitle("Save");
            int n = Viewer.this.chooser.showSaveDialog(Viewer.this);
            if (n != 0) {
                return;
            }
            Viewer.this.saveFile(Viewer.this.chooser.getSelectedFile());
        }
    }

    private class ImportMenuItem
    extends JMenuItem
    implements ActionListener {
        ImportMenuItem() {
            super("Import...");
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Viewer.this.chooser.setDialogTitle("Import");
            int n = Viewer.this.chooser.showOpenDialog(Viewer.this);
            if (n != 0) {
                return;
            }
            String string = Viewer.this.chooser.getSelectedFile().getAbsolutePath();
            Image image = Toolkit.getDefaultToolkit().createImage(string);
            try {
                Viewer.this.editor.setText(Pnm.convertToText(image));
            }
            catch (Pnm.PnmException pnmException) {
                JOptionPane.showMessageDialog(Viewer.this, "" + pnmException.getMessage());
            }
        }
    }

    private class OpenMenuItem
    extends JMenuItem
    implements ActionListener {
        OpenMenuItem() {
            super("Open...");
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Viewer.this.chooser.setDialogTitle("Open");
            int n = Viewer.this.chooser.showOpenDialog(Viewer.this);
            if (n != 0) {
                return;
            }
            Viewer.this.openFile(Viewer.this.chooser.getSelectedFile());
        }
    }

    private class NewMenuItem
    extends JMenuItem
    implements ActionListener {
        NewMenuItem() {
            super("New");
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Viewer.this.editor.setText("");
        }
    }
}

