/*
 * Decompiled with CFR 0.152.
 */
package unmouse;

import java.awt.Point;
import java.awt.Rectangle;
import unmouse.HandTrackListener;
import unmouse.ImageGrabber;
import unmouse.ImageWindow;

public class HandTrack
extends Thread {
    public static final int SEARCH_BOX_SIZE = 20;
    private static final int COLOR_THRESHOLD = 40;
    private static final int SMOOTHING_DISTANCE = 2;
    private static final int MOTION_THRESHOLD = 50;
    private static final int MOUSE_SMOOTH = 8;
    private static final double RED_WEIGHT = 0.5;
    private static final double GREEN_WEIGHT = 0.3;
    private static final double BLUE_WEIGHT = 0.2;
    private static int GRABBER_REMOVE_PENDING = 1;
    private static int GRABBER_REMOVE_DONE = 2;
    private static int GRABBER_UPDATE_DONE = 3;
    private static boolean DEBUG = false;
    int update_state = GRABBER_UPDATE_DONE;
    ImageGrabber grabber;
    HandTrackListener inset;
    int WIDTH;
    int HEIGHT;
    int[][] old_r;
    int[][] old_g;
    int[][] old_b;
    int[][] new_r;
    int[][] new_g;
    int[][] new_b;
    int[][] motion;
    int[][] motionSum;
    int[][] smoothedMotion;
    Point currCenter = new Point();

    public HandTrack(ImageGrabber imageGrabber, HandTrackListener handTrackListener) {
        this.inset = handTrackListener;
        this.setGrabber(imageGrabber);
    }

    private void setGrabber(ImageGrabber imageGrabber) {
        this.grabber = imageGrabber;
        this.WIDTH = imageGrabber.getWidth();
        this.HEIGHT = imageGrabber.getHeight();
        this.motion = new int[this.WIDTH][this.HEIGHT];
        this.motionSum = new int[this.WIDTH][this.HEIGHT];
        this.smoothedMotion = new int[this.WIDTH][this.HEIGHT];
        imageGrabber.stepImage();
        this.old_r = imageGrabber.getRed();
        this.old_g = imageGrabber.getGreen();
        this.old_b = imageGrabber.getBlue();
        this.new_r = this.old_r;
        this.new_g = this.old_g;
        this.new_b = this.old_b;
        this.currCenter.setLocation(this.WIDTH / 2, this.HEIGHT / 2);
        this.inset.updateCursor(this.currCenter.x, this.currCenter.y);
    }

    public synchronized void removeGrabber() {
        this.update_state = GRABBER_REMOVE_PENDING;
        while (this.update_state != GRABBER_REMOVE_DONE) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.grabber.close();
        this.grabber = null;
    }

    public synchronized void updateGrabber(ImageGrabber imageGrabber) {
        this.setGrabber(imageGrabber);
        this.update_state = GRABBER_UPDATE_DONE;
        this.notifyAll();
    }

    private synchronized void checkForUpdatedGrabber() {
        if (this.update_state == GRABBER_REMOVE_PENDING) {
            this.update_state = GRABBER_REMOVE_DONE;
            this.notifyAll();
        }
        while (this.update_state != GRABBER_UPDATE_DONE) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void run() {
        ImageWindow imageWindow = null;
        if (DEBUG) {
            imageWindow = new ImageWindow();
            imageWindow.show();
        }
        this.new_r = this.old_r;
        this.new_g = this.old_g;
        this.new_b = this.old_b;
        int[] nArray = new int[3];
        Rectangle rectangle = new Rectangle();
        while (true) {
            this.checkForUpdatedGrabber();
            this.old_r = this.new_r;
            this.old_g = this.new_g;
            this.old_b = this.new_b;
            this.updateSearchBox(rectangle, this.currCenter);
            this.grabber.stepImage();
            this.new_r = this.grabber.getRed();
            this.new_g = this.grabber.getGreen();
            this.new_b = this.grabber.getBlue();
            this.computeMotion(this.motion, this.old_r, this.old_g, this.old_b, this.new_r, this.new_g, this.new_b, rectangle);
            this.fetchCumulativeSums(this.motionSum, this.motion, rectangle);
            this.smoothMotion(this.smoothedMotion, this.motionSum, rectangle);
            double d = this.countAboveThreshold(this.smoothedMotion, 40, rectangle);
            if (d > 50.0) {
                this.computeCenter(this.currCenter, this.smoothedMotion, rectangle);
                this.inset.updateCursor(this.currCenter.x, this.currCenter.y);
            }
            if (!DEBUG) continue;
            imageWindow.setImage(0, imageWindow.createImage(this.new_r, this.new_g, this.new_b, this.WIDTH, this.HEIGHT));
            imageWindow.setImage(1, imageWindow.createImage(this.motion, this.WIDTH, this.HEIGHT));
            imageWindow.setImage(2, imageWindow.createImage(this.smoothedMotion, this.WIDTH, this.HEIGHT));
            imageWindow.scheduleRepaint();
        }
    }

    private void updateSearchBox(Rectangle rectangle, Point point) {
        int n = Math.max(0, point.x - 20);
        int n2 = Math.min(this.WIDTH - 1, point.x + 20);
        int n3 = Math.max(0, point.y - 20);
        int n4 = Math.min(this.HEIGHT - 1, point.y + 20);
        rectangle.setBounds(n, n3, n2 - n, n4 - n3);
    }

    private void computeMotion(int[][] nArray, int[][] nArray2, int[][] nArray3, int[][] nArray4, int[][] nArray5, int[][] nArray6, int[][] nArray7, Rectangle rectangle) {
        int n = rectangle.x + rectangle.width;
        int n2 = rectangle.y + rectangle.height;
        int n3 = rectangle.x + 1;
        while (n3 < n) {
            int n4 = rectangle.y;
            while (n4 < n2) {
                int n5 = Math.abs(nArray2[n3][n4] - nArray5[n3][n4]);
                int n6 = Math.abs(nArray3[n3][n4] - nArray6[n3][n4]);
                int n7 = Math.abs(nArray4[n3][n4] - nArray7[n3][n4]);
                nArray[n3][n4] = (int)((double)n5 * 0.5 + (double)n6 * 0.3 + (double)n7 * 0.2);
                ++n4;
            }
            ++n3;
        }
    }

    private void fetchCumulativeSums(int[][] nArray, int[][] nArray2, Rectangle rectangle) {
        int n = rectangle.x + rectangle.width;
        int n2 = rectangle.y + rectangle.height;
        int n3 = 0;
        int n4 = rectangle.y;
        while (n4 < n2) {
            nArray[rectangle.x][n4] = n3 += nArray2[rectangle.x][n4];
            ++n4;
        }
        int n5 = rectangle.x + 1;
        while (n5 < n) {
            n3 = 0;
            int n6 = rectangle.y;
            while (n6 < n2) {
                nArray[n5][n6] = nArray[n5 - 1][n6] + (n3 += nArray2[n5][n6]);
                ++n6;
            }
            ++n5;
        }
    }

    private void smoothMotion(int[][] nArray, int[][] nArray2, Rectangle rectangle) {
        int n;
        int n2 = rectangle.x;
        int n3 = rectangle.y;
        int n4 = rectangle.x + rectangle.width;
        int n5 = rectangle.y + rectangle.height;
        int n6 = 2;
        int n7 = 0;
        while (n7 < n6) {
            n = n3;
            while (n < n5) {
                nArray[n2 + n7][n] = 0;
                nArray[n4 - 1 - n7][n] = 0;
                ++n;
            }
            ++n7;
        }
        n = 0;
        while (n < n6) {
            int n8 = n2;
            while (n8 < n4) {
                nArray[n8][n3 + n] = 0;
                nArray[n8][n5 - 1 - n] = 0;
                ++n8;
            }
            ++n;
        }
        double d = Math.pow(2 * n6, 2.0);
        int n9 = n2 + n6;
        while (n9 < n4 - n6) {
            int n10 = n3 + n6;
            while (n10 < n5 - n6) {
                int n11 = nArray2[n9 + n6][n10 + n6] - nArray2[n9 - n6][n10 + n6] - nArray2[n9 + n6][n10 - n6] + nArray2[n9 - n6][n10 - n6];
                nArray[n9][n10] = (int)((double)n11 / d);
                ++n10;
            }
            ++n9;
        }
    }

    private int countAboveThreshold(int[][] nArray, int n, Rectangle rectangle) {
        int n2 = 0;
        int n3 = rectangle.x + rectangle.width;
        int n4 = rectangle.y + rectangle.height;
        int n5 = rectangle.x;
        while (n5 < n3) {
            int n6 = rectangle.y;
            while (n6 < n4) {
                int n7 = nArray[n5][n6];
                if (n7 > n) {
                    ++n2;
                }
                ++n6;
            }
            ++n5;
        }
        return n2;
    }

    private void computeCenter(Point point, int[][] nArray, Rectangle rectangle) {
        int n = rectangle.x + rectangle.width;
        int n2 = rectangle.y + rectangle.height;
        int n3 = rectangle.y + rectangle.height / 2;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n4 = rectangle.x;
        while (n4 < n) {
            int n5 = rectangle.y;
            while (n5 < n2) {
                int n6 = this.smoothedMotion[n4][n5];
                if (n6 > 40) {
                    double d4 = n5 < n3 ? 1.5 : 1.0;
                    d3 += (double)n6 * d4;
                    d += (double)(n6 * n4) * d4;
                    d2 += (double)(n6 * n5) * d4;
                }
                ++n5;
            }
            ++n4;
        }
        point.setLocation(d / d3, d2 / d3);
    }
}

