/*
 * Decompiled with CFR 0.152.
 */
package unmouse;

import java.awt.Dimension;
import java.awt.image.MemoryImageSource;
import java.io.IOException;
import java.util.Arrays;
import unmouse.ProgressListener;
import unmouse.media.Buffer;
import unmouse.media.BufferToImage;
import unmouse.media.CaptureDevice;
import unmouse.media.CaptureDeviceInfo;
import unmouse.media.CaptureDeviceManager;
import unmouse.media.Controller;
import unmouse.media.ControllerEvent;
import unmouse.media.ControllerListener;
import unmouse.media.DataSource;
import unmouse.media.Format;
import unmouse.media.FormatControl;
import unmouse.media.Manager;
import unmouse.media.MediaLocator;
import unmouse.media.NoDataSourceException;
import unmouse.media.NoProcessorException;
import unmouse.media.NotRealizedError;
import unmouse.media.Processor;
import unmouse.media.PushBufferDataSource;
import unmouse.media.PushBufferStream;
import unmouse.media.RGBFormat;
import unmouse.media.RealizeCompleteEvent;
import unmouse.media.VideoFormat;
import unmouse.media.YUVFormat;

public class ImageGrabber {
    private static final int RGB_DEPTH = 24;
    private final int WIDTH;
    private final int HEIGHT;
    private Object stateLock = new Object();
    private PushBufferStream camStream;
    private MyImageSource source = null;
    private VideoFormat format;
    private DataSource formattedSource;
    private Processor deviceProc;
    private BufferToImage converter;
    private Buffer buffer;
    private int[][][] buffers = new int[64][][];
    private int buffer_position = 0;
    private int[][] r_data;
    private int[][] g_data;
    private int[][] b_data;
    private long last_capture = System.currentTimeMillis() - 1000L;

    public ImageGrabber(CaptureDeviceInfo captureDeviceInfo, VideoFormat videoFormat, ProgressListener progressListener) {
        this.format = videoFormat;
        Dimension dimension = videoFormat.getSize();
        this.WIDTH = dimension.width;
        this.HEIGHT = dimension.height;
        this.source = new MyImageSource(this.WIDTH, this.HEIGHT);
        this.initialize(captureDeviceInfo, progressListener);
    }

    public ImageGrabber(String string, int n, int n2) {
        this.WIDTH = n;
        this.HEIGHT = n2;
        this.source = new MyImageSource(this.WIDTH, this.HEIGHT);
        CaptureDeviceInfo captureDeviceInfo = CaptureDeviceManager.getDevice(string);
        if (captureDeviceInfo == null) {
            this.error("No device found [ " + string + "]");
        }
        Format[] formatArray = captureDeviceInfo.getFormats();
        Dimension dimension = new Dimension(this.WIDTH, this.HEIGHT);
        int n3 = 0;
        while (this.format == null && n3 < formatArray.length) {
            VideoFormat videoFormat;
            if (formatArray[n3] instanceof VideoFormat && (videoFormat = (VideoFormat)formatArray[n3]).getSize().equals(dimension)) {
                if (videoFormat instanceof YUVFormat) {
                    this.format = (VideoFormat)formatArray[n3];
                } else if (videoFormat instanceof RGBFormat && ((RGBFormat)videoFormat).getBitsPerPixel() == 24) {
                    this.format = (VideoFormat)formatArray[n3];
                }
            }
            ++n3;
        }
        if (this.format == null) {
            this.error("Requested format not supported");
        }
        this.initialize(captureDeviceInfo, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(CaptureDeviceInfo captureDeviceInfo, ProgressListener progressListener) {
        Object object;
        FormatControl[] formatControlArray;
        MediaLocator mediaLocator;
        if (progressListener != null) {
            progressListener.setMessage("Finding camera");
            progressListener.setProgress(0.0);
            progressListener.repaint();
        }
        if ((mediaLocator = captureDeviceInfo.getLocator()) == null) {
            this.error("Unable to get MediaLocator for device");
        }
        this.formattedSource = null;
        try {
            this.formattedSource = Manager.createDataSource(mediaLocator);
        }
        catch (IOException iOException) {
            this.error("IO Error creating dataSource");
        }
        catch (NoDataSourceException noDataSourceException) {
            this.error("Unable to create dataSource");
        }
        if (!(this.formattedSource instanceof CaptureDevice)) {
            this.error("DataSource not a CaptureDevice");
        }
        if ((formatControlArray = ((CaptureDevice)this.formattedSource).getFormatControls()) == null || formatControlArray.length == 0) {
            this.error("No FormatControl available");
        }
        if (progressListener != null) {
            progressListener.setMessage("Finding camera: Finding format");
            progressListener.setProgress(0.2);
            progressListener.repaint();
        }
        Format format = null;
        int n = 0;
        while (n < formatControlArray.length) {
            if (formatControlArray[n] != null && (format = formatControlArray[n].setFormat(this.format)) != null) break;
            ++n;
        }
        if (format == null) {
            this.error("Failed to set camera format");
        }
        if (progressListener != null) {
            progressListener.setMessage("Finding camera: Connecting");
            progressListener.setProgress(0.4);
            progressListener.repaint();
        }
        try {
            this.formattedSource.connect();
        }
        catch (IOException iOException) {
            this.error("Unable to connect to DataSource");
        }
        this.deviceProc = null;
        try {
            this.deviceProc = Manager.createProcessor(this.formattedSource);
        }
        catch (IOException iOException) {
            this.error("Unable to get Processor for device: " + iOException.getMessage());
        }
        catch (NoProcessorException noProcessorException) {
            this.error("Unable to get Processor for device: " + noProcessorException.getMessage());
        }
        if (progressListener != null) {
            progressListener.setMessage("Finding camera: Realizing device");
            progressListener.setProgress(0.6);
            progressListener.repaint();
        }
        this.deviceProc.addControllerListener(new RealizeListener());
        this.deviceProc.realize();
        while (this.deviceProc.getState() != Controller.Realized) {
            object = this.stateLock;
            synchronized (object) {
                try {
                    this.stateLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    this.error("Failed to get to realized state");
                }
            }
        }
        this.deviceProc.start();
        object = null;
        try {
            object = (PushBufferDataSource)this.deviceProc.getDataOutput();
        }
        catch (NotRealizedError notRealizedError) {
            this.error("Processor not realized");
        }
        if (progressListener != null) {
            progressListener.setMessage("Finding camera: Finding stream");
            progressListener.setProgress(0.8);
            progressListener.repaint();
        }
        PushBufferStream[] pushBufferStreamArray = ((PushBufferDataSource)object).getStreams();
        this.camStream = null;
        int n2 = 0;
        while (this.camStream == null && n2 < pushBufferStreamArray.length) {
            Format format2 = pushBufferStreamArray[n2].getFormat();
            if (format2.getClass().isInstance(this.format)) {
                this.camStream = pushBufferStreamArray[n2];
            }
            ++n2;
        }
        if (this.camStream == null) {
            this.error("Could not find input stream from device");
        }
        this.converter = new BufferToImage(this.format);
        if (progressListener != null) {
            progressListener.setMessage("Finding camera: Done");
            progressListener.setProgress(1.0);
            progressListener.repaint();
        }
    }

    private int[][] getRawBuffer() {
        ++this.buffer_position;
        if (this.buffer_position == this.buffers.length) {
            this.buffer_position = 0;
        }
        if (this.buffers[this.buffer_position] == null) {
            this.buffers[this.buffer_position] = new int[this.WIDTH][this.HEIGHT];
        }
        return this.buffers[this.buffer_position];
    }

    public int[][] getBuffer() {
        int[][] nArray = this.getRawBuffer();
        int n = 0;
        while (n < nArray.length) {
            Arrays.fill(nArray[n], 0);
            ++n;
        }
        return nArray;
    }

    private void error(String string) {
        throw new RuntimeException("Camera error: " + string);
    }

    public void stepImage() {
        long l = System.currentTimeMillis();
        this.buffer = new Buffer();
        try {
            this.camStream.read(this.buffer);
        }
        catch (IOException iOException) {
            this.error("Unable to capture frame from camera");
        }
        this.r_data = null;
        this.last_capture = System.currentTimeMillis();
    }

    public void stepImage(int n) {
        long l = this.last_capture + (long)n;
        this.stepImage();
        long l2 = l - System.currentTimeMillis();
        if (l2 > 0L) {
            try {
                Thread.sleep(l2);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.last_capture = l;
    }

    public int[][] getRed() {
        if (this.r_data == null) {
            this.fetchPixels();
        }
        return this.r_data;
    }

    public int[][] getGreen() {
        if (this.r_data == null) {
            this.fetchPixels();
        }
        return this.g_data;
    }

    public int[][] getBlue() {
        if (this.r_data == null) {
            this.fetchPixels();
        }
        return this.b_data;
    }

    private void fetchPixels() {
        Object object = this.buffer.getData();
        if (object == null) {
            throw new RuntimeException("Got null buffer from camera");
        }
        if (!(object instanceof byte[])) {
            throw new RuntimeException("Unexpected buffer type from camera: " + object.getClass().getName());
        }
        byte[] byArray = (byte[])object;
        if (this.format instanceof YUVFormat) {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            YUVFormat yUVFormat = (YUVFormat)this.format;
            int[][] nArray = this.getRawBuffer();
            int[][] nArray2 = this.getRawBuffer();
            int[][] nArray3 = this.getRawBuffer();
            int n8 = 0;
            while (n8 < 3) {
                int n9;
                int[][] nArray4;
                if (n8 == 0) {
                    nArray4 = nArray;
                    n7 = yUVFormat.getStrideY();
                    n6 = yUVFormat.getOffsetY();
                } else if (n8 == 1) {
                    nArray4 = nArray2;
                    n7 = yUVFormat.getStrideUV();
                    n6 = yUVFormat.getOffsetU();
                } else {
                    nArray4 = nArray3;
                    n7 = yUVFormat.getStrideUV();
                    n6 = yUVFormat.getOffsetV();
                }
                n5 = this.WIDTH / n7;
                n4 = this.WIDTH * this.HEIGHT / (n5 * n5);
                n3 = n6 + n4;
                n2 = this.WIDTH - n5;
                n = 0;
                if (n5 == 1) {
                    n9 = n6;
                    while (n9 < n3) {
                        nArray4[n2][n] = byArray[n9] & 0xFF;
                        if (--n2 < 0) {
                            n2 = this.WIDTH - 1;
                            ++n;
                        }
                        ++n9;
                    }
                } else {
                    n9 = n6;
                    while (n9 < n3) {
                        int n10 = 0;
                        while (n10 < n5) {
                            int n11 = 0;
                            while (n11 < n5) {
                                nArray4[n2 + n10][n + n11] = byArray[n9] & 0xFF;
                                ++n11;
                            }
                            ++n10;
                        }
                        if ((n2 -= n5) < 0) {
                            n2 = this.WIDTH - n5;
                            n += n5;
                        }
                        ++n9;
                    }
                }
                ++n8;
            }
            this.r_data = this.getRawBuffer();
            this.g_data = this.getRawBuffer();
            this.b_data = this.getRawBuffer();
            int n12 = 0;
            while (n12 < this.WIDTH) {
                n7 = 0;
                while (n7 < this.HEIGHT) {
                    n6 = nArray[n12][n7] - 16;
                    n5 = nArray2[n12][n7] - 128;
                    n4 = nArray3[n12][n7] - 128;
                    n3 = (int)(1.164 * (double)n6 + 1.596 * (double)n4);
                    n2 = (int)(1.164 * (double)n6 - 0.391 * (double)n5 - 0.813 * (double)n4);
                    n = (int)(1.164 * (double)n6 + 2.018 * (double)n5);
                    if (n3 < 0) {
                        n3 = 0;
                    }
                    if (n2 < 0) {
                        n2 = 0;
                    }
                    if (n < 0) {
                        n = 0;
                    }
                    if (n3 > 255) {
                        n3 = 255;
                    }
                    if (n2 > 255) {
                        n2 = 255;
                    }
                    if (n > 255) {
                        n = 255;
                    }
                    this.r_data[n12][n7] = n3;
                    this.g_data[n12][n7] = n2;
                    this.b_data[n12][n7] = n;
                    ++n7;
                }
                ++n12;
            }
            this.source.renew(this.r_data, this.g_data, this.b_data);
        } else if (this.format instanceof RGBFormat) {
            int n = byArray.length / 3;
            this.r_data = this.getRawBuffer();
            this.g_data = this.getRawBuffer();
            this.b_data = this.getRawBuffer();
            int n13 = 0;
            int n14 = this.HEIGHT - 1;
            int n15 = n - 1;
            int n16 = 0;
            while (n15 >= 0) {
                this.r_data[n13][n14] = byArray[n16 + 2] & 0xFF;
                this.g_data[n13][n14] = byArray[n16 + 1] & 0xFF;
                this.b_data[n13][n14] = byArray[n16] & 0xFF;
                if (++n13 == this.WIDTH) {
                    n13 = 0;
                    --n14;
                }
                --n15;
                n16 += 3;
            }
            this.source.renew(this.r_data, this.g_data, this.b_data);
        } else {
            throw new RuntimeException("Unrecognized color format " + this.format.getClass().getName());
        }
    }

    public int getWidth() {
        return this.WIDTH;
    }

    public int getHeight() {
        return this.HEIGHT;
    }

    public MemoryImageSource getSource() {
        return this.source.getSource();
    }

    public static boolean acceptsFormat(Format format) {
        if (format instanceof RGBFormat) {
            return ((RGBFormat)format).getBitsPerPixel() == 24;
        }
        return format instanceof YUVFormat;
    }

    public void close() {
        this.deviceProc.close();
        this.formattedSource.disconnect();
    }

    private class RealizeListener
    implements ControllerListener {
        private RealizeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void controllerUpdate(ControllerEvent controllerEvent) {
            if (controllerEvent instanceof RealizeCompleteEvent) {
                Object object = ImageGrabber.this.stateLock;
                synchronized (object) {
                    ImageGrabber.this.stateLock.notifyAll();
                }
            }
        }
    }

    private class MyImageSource {
        private int[] pix;
        private int height;
        private int width;
        private MemoryImageSource source;

        private MyImageSource(int n, int n2) {
            this.width = n;
            this.height = n2;
            this.pix = new int[n * n2];
            this.source = new MemoryImageSource(n, n2, this.pix, 0, n);
            this.source.setAnimated(true);
        }

        public MemoryImageSource getSource() {
            return this.source;
        }

        public void renew(int[][] nArray, int[][] nArray2, int[][] nArray3) {
            this.setArray(nArray, nArray2, nArray3);
            this.source.newPixels(0, 0, this.width, this.height);
        }

        private void setArray(int[][] nArray, int[][] nArray2, int[][] nArray3) {
            int n = 0;
            int n2 = 0;
            while (n2 < this.height) {
                int n3 = 0;
                while (n3 < this.width) {
                    this.pix[n++] = 0xFF000000 | (nArray[n3][n2] & 0xFF) << 16 | (nArray2[n3][n2] & 0xFF) << 8 | nArray3[n3][n2] & 0xFF;
                    ++n3;
                }
                ++n2;
            }
        }
    }
}

