/*
 * Decompiled with CFR 0.152.
 */
package unmouse;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.MemoryImageSource;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ImageWindow
extends JFrame {
    private static int GAP_SIZE = 20;
    private static int WIN_HEIGHT = 240 + 2 * GAP_SIZE;
    private static int WIN_WIDTH = 320 + 2 * GAP_SIZE;
    private Image[] image = new Image[4];
    private int[] height = new int[4];
    private int[] width = new int[4];
    private MyPanel panel;

    public ImageWindow() {
        this.addWindowListener(new WindowCloser());
        this.panel = new MyPanel();
        this.getContentPane().add(this.panel);
        this.pack();
    }

    public synchronized void setImage(int n, Image image) {
        if (this.image[n] == null) {
            this.image[n] = image;
            int n2 = 0;
            while (n2 < this.image.length) {
                if (this.image[n2] == null) {
                    this.width[n2] = 0;
                    this.height[n2] = 0;
                } else {
                    this.width[n2] = this.image[n2].getWidth(this.panel);
                    this.height[n2] = this.image[n2].getHeight(this.panel);
                }
                ++n2;
            }
            int n3 = Math.max(this.width[0], this.width[1]) + 2 * GAP_SIZE;
            if (this.width[2] + this.width[3] > 0) {
                n3 += Math.max(this.width[2], this.width[3]) + GAP_SIZE;
            }
            int n4 = Math.max(this.height[0], this.height[2]) + 2 * GAP_SIZE;
            if (this.height[1] + this.height[3] > 0) {
                n4 += Math.max(this.height[1], this.height[3]) + GAP_SIZE;
            }
            this.panel.setSize(new Dimension(n3, n4));
            this.panel.setPreferredSize(new Dimension(n3, n4));
            this.pack();
        } else {
            this.image[n] = image;
        }
    }

    public ImageSource createSource(int[][] nArray, int[][] nArray2, int[][] nArray3) {
        return new ImageSource(nArray, nArray2, nArray3);
    }

    public Image createImage(int n, int n2) {
        return super.createImage(n, n2);
    }

    public Image createImage(int[][] nArray, int[][] nArray2, int[][] nArray3, int n, int n2) {
        int[] nArray4 = new int[n * n2];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = 0;
            while (n5 < n) {
                nArray4[n3++] = 0xFF000000 | (nArray[n5][n4] & 0xFF) << 16 | (nArray2[n5][n4] & 0xFF) << 8 | nArray3[n5][n4] & 0xFF;
                ++n5;
            }
            ++n4;
        }
        MemoryImageSource memoryImageSource = new MemoryImageSource(n, n2, nArray4, 0, n);
        return super.createImage(memoryImageSource);
    }

    public Image createImage(int[][] nArray, int n, int n2) {
        int[] nArray2 = new int[n * n2];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = 0;
            while (n5 < n) {
                int n6 = nArray[n5][n4] & 0xFF;
                nArray2[n3++] = 0xFF000000 | n6 << 16 | n6 << 8 | n6;
                ++n5;
            }
            ++n4;
        }
        MemoryImageSource memoryImageSource = new MemoryImageSource(n, n2, nArray2, 0, n);
        return super.createImage(memoryImageSource);
    }

    public void scheduleRepaint() {
        this.panel.repaint();
    }

    private synchronized void drawImages(Graphics graphics) {
        int n = 0;
        while (n < this.image.length) {
            Image image = this.image[n];
            if (image == null) {
                this.width[n] = 0;
                this.height[n] = 0;
            } else {
                this.width[n] = image.getWidth(this.panel);
                this.height[n] = image.getHeight(this.panel);
            }
            ++n;
        }
        int n2 = Math.max(this.width[0], this.width[1]) + 2 * GAP_SIZE;
        int n3 = Math.max(this.height[0], this.height[2]) + 2 * GAP_SIZE;
        graphics.setColor(Color.black);
        if (this.image[0] != null) {
            graphics.drawImage(this.image[0], GAP_SIZE, GAP_SIZE, this);
            graphics.drawRect(GAP_SIZE, GAP_SIZE, this.width[0], this.height[0]);
        }
        if (this.image[1] != null) {
            graphics.drawImage(this.image[1], GAP_SIZE, n3, this);
            graphics.drawRect(GAP_SIZE, n3, this.width[1], this.height[1]);
        }
        if (this.image[2] != null) {
            graphics.drawImage(this.image[2], n2, GAP_SIZE, this);
            graphics.drawRect(n2, GAP_SIZE, this.width[2], this.height[2]);
        }
        if (this.image[3] != null) {
            graphics.drawImage(this.image[3], n2, n3, this);
            graphics.drawRect(n2, n3, this.width[3], this.height[3]);
        }
    }

    private class WindowCloser
    extends WindowAdapter {
        private WindowCloser() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            System.exit(0);
        }
    }

    private class MyPanel
    extends JPanel {
        MyPanel() {
            this.setPreferredSize(new Dimension(WIN_WIDTH, WIN_HEIGHT));
            this.setBackground(Color.white);
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            ImageWindow.this.drawImages(graphics);
        }
    }

    public class ImageSource {
        private int[] pix;
        private int height;
        private int width;
        private MemoryImageSource source;
        private Image img = null;

        private ImageSource(int[][] nArray, int[][] nArray2, int[][] nArray3) {
            this.width = nArray.length;
            this.height = nArray[0].length;
            this.pix = new int[this.width * this.height];
            this.setArray(nArray, nArray2, nArray3);
            this.source = new MemoryImageSource(this.width, this.height, this.pix, 0, this.width);
            this.source.setAnimated(true);
        }

        public Image getImage() {
            if (this.img == null) {
                this.img = ImageWindow.this.createImage(this.source);
            }
            return this.img;
        }

        public void renew(int[][] nArray, int[][] nArray2, int[][] nArray3) {
            this.setArray(nArray, nArray2, nArray3);
            this.source.newPixels(0, 0, this.width, this.height);
        }

        private void setArray(int[][] nArray, int[][] nArray2, int[][] nArray3) {
            int n = 0;
            int n2 = 0;
            while (n2 < this.height) {
                int n3 = 0;
                while (n3 < this.width) {
                    this.pix[n++] = 0xFF000000 | (nArray[n3][n2] & 0xFF) << 16 | (nArray2[n3][n2] & 0xFF) << 8 | nArray3[n3][n2] & 0xFF;
                    ++n3;
                }
                ++n2;
            }
        }
    }
}

