/*
 * Decompiled with CFR 0.152.
 */
package unmouse;

import java.awt.AWTException;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Robot;
import java.awt.Toolkit;
import unmouse.HandTrack;
import unmouse.HandTrackListener;
import unmouse.ImageGrabber;

public class RobotCursor {
    public static final int IMAGE_MARGIN = 20;
    private static final int MOUSE_SMOOTH = 8;
    Robot robot;
    HandTrack tracker;
    HandTrackListener listener;
    Point[] history = new Point[8];
    int image_width;
    int image_height;
    int screen_width = 1;
    int screen_height = 1;

    public RobotCursor(ImageGrabber imageGrabber, HandTrackListener handTrackListener) {
        this.listener = handTrackListener;
        int n = 0;
        while (n < this.history.length) {
            this.history[n] = new Point();
            ++n;
        }
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.screen_width = (int)dimension.getWidth();
        this.screen_height = (int)dimension.getHeight();
        this.setGrabber(imageGrabber);
        try {
            this.robot = new Robot();
        }
        catch (AWTException aWTException) {
            // empty catch block
        }
        this.tracker = new HandTrack(imageGrabber, new MyListener());
    }

    public boolean isRobotEnabled() {
        return this.robot != null;
    }

    private void setGrabber(ImageGrabber imageGrabber) {
        this.image_width = imageGrabber.getWidth();
        this.image_height = imageGrabber.getHeight();
        int n = this.image_width / 2;
        int n2 = this.image_height / 2;
        int n3 = 0;
        while (n3 < this.history.length) {
            this.history[n3].setLocation(n, n2);
            ++n3;
        }
    }

    public synchronized void removeGrabber() {
        this.tracker.removeGrabber();
    }

    public synchronized void updateGrabber(ImageGrabber imageGrabber) {
        this.setGrabber(imageGrabber);
        this.tracker.updateGrabber(imageGrabber);
    }

    public void start() {
        this.tracker.start();
    }

    private class MyListener
    implements HandTrackListener {
        private MyListener() {
        }

        public void updateCursor(int n, int n2) {
            int n3;
            int n4 = (n - 20) * RobotCursor.this.screen_width / (RobotCursor.this.image_width - 40);
            if (n4 < 0) {
                n4 = 0;
            }
            if (n4 >= RobotCursor.this.screen_width) {
                n4 = RobotCursor.this.screen_width - 1;
            }
            if ((n3 = (n2 - 20) * RobotCursor.this.screen_height / (RobotCursor.this.image_height - 40)) < 0) {
                n3 = 0;
            }
            if (n3 >= RobotCursor.this.screen_height) {
                n3 = RobotCursor.this.screen_height - 1;
            }
            int n5 = RobotCursor.this.history.length - 1;
            while (n5 > 0) {
                RobotCursor.this.history[n5].setLocation(RobotCursor.this.history[n5 - 1]);
                --n5;
            }
            RobotCursor.this.history[0].setLocation(n4, n3);
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            int n6 = 0;
            while (n6 < 8) {
                d += (double)((8 - n6) * RobotCursor.this.history[n6].x);
                d2 += (double)((8 - n6) * RobotCursor.this.history[n6].y);
                d3 += (double)(8 - n6);
                ++n6;
            }
            int n7 = (int)(d / d3 + 0.5);
            int n8 = (int)(d2 / d3 + 0.5);
            if (RobotCursor.this.robot != null) {
                RobotCursor.this.robot.mouseMove(n7, n8);
            }
            RobotCursor.this.listener.updateCursor(n, n2);
        }
    }
}

