/*
 * Decompiled with CFR 0.152.
 */
package unmouse;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.ImageObserver;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Vector;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import unmouse.HandTrackListener;
import unmouse.ImageGrabber;
import unmouse.ProgressListener;
import unmouse.RobotCursor;
import unmouse.media.CaptureDeviceInfo;
import unmouse.media.CaptureDeviceManager;
import unmouse.media.Format;
import unmouse.media.MediaLoader;
import unmouse.media.MediaObject;
import unmouse.media.RGBFormat;
import unmouse.media.VideoFormat;
import unmouse.media.YUVFormat;

public class UnMouse
extends JFrame {
    private static String PROP_JMF = "unmouse.jmf";
    private static String PROP_DEVICE = "unmouse.device";
    private static String PROP_FORMAT = "unmouse.format";
    private static int PREFERRED_SIZE = 25000;
    private static int PROGRESS_MARGIN = 20;
    private static int PROGRESS_HEIGHT = 10;
    private static String CAMERA_NEEDED = "Select a device.";
    private Inset inset;
    private CaptureDeviceInfo device = null;
    private VideoFormat format = null;
    private ImageGrabber grabber = null;
    private RobotCursor tracker = null;
    static /* synthetic */ Class class$unmouse$UnMouse;

    public UnMouse() {
        super("The Un-Mouse");
        this.addWindowListener(new WindowCloser());
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        JMenu jMenu = new JMenu("Device");
        jMenu.add(new SetDevice());
        jMenu.add(new SetFormat());
        jMenu.add(new SetJmfItem());
        jMenu.add(new QuitItem());
        jMenuBar.add(jMenu);
        jMenu = new JMenu("Help");
        jMenu.add(new AboutItem());
        jMenuBar.add(jMenu);
        this.inset = new Inset(120, 160);
        this.getContentPane().add((Component)this.inset, "Center");
        this.pack();
    }

    private void setFormat(VideoFormat videoFormat) {
        this.format = videoFormat;
        this.inset.setPreferredSize(videoFormat.getSize());
        this.pack();
        this.repaint();
    }

    private void updateGrabber() {
        if (this.device == null) {
            return;
        }
        if (this.format == null) {
            this.selectDefaultFormat();
            if (this.format == null) {
                return;
            }
        }
        if (this.tracker != null) {
            this.tracker.removeGrabber();
        }
        try {
            this.inset.setShowProgress(true);
            this.grabber = new ImageGrabber(this.device, this.format, this.inset);
            this.inset.setShowProgress(false);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "Error: " + exception);
            exception.printStackTrace();
            return;
        }
        this.inset.updateImage(this.inset.createImage(this.grabber.getSource()));
        if (this.tracker == null) {
            this.tracker = new RobotCursor(this.grabber, new MyHandListener());
            if (!this.tracker.isRobotEnabled()) {
                JOptionPane.showMessageDialog(this, "This platform does not support moving the mouse cursor in Java.");
            }
            this.tracker.start();
        } else {
            this.tracker.updateGrabber(this.grabber);
        }
    }

    private void selectDefaultFormat() {
        Format[] formatArray = this.device.getFormats();
        if (this.format != null) {
            int n = 0;
            while (n < formatArray.length) {
                if (this.format == formatArray[n]) {
                    return;
                }
                ++n;
            }
        }
        VideoFormat videoFormat = null;
        int n = 0;
        int n2 = 0;
        while (n2 < formatArray.length) {
            if (ImageGrabber.acceptsFormat(formatArray[n2])) {
                VideoFormat videoFormat2 = (VideoFormat)formatArray[n2];
                Dimension dimension = videoFormat2.getSize();
                int n3 = Math.abs(dimension.width * dimension.height - PREFERRED_SIZE);
                if (videoFormat == null || n3 < n || n3 == n && videoFormat2 instanceof RGBFormat) {
                    videoFormat = videoFormat2;
                    n = n3;
                }
            }
            ++n2;
        }
        this.setFormat(videoFormat);
    }

    private boolean promptJmf() throws JmfException {
        JFileChooser jFileChooser = new JFileChooser();
        int n = jFileChooser.showOpenDialog(this);
        if (n != 0) {
            return false;
        }
        File file = jFileChooser.getSelectedFile();
        if (!file.exists()) {
            throw new JmfException("The file does not exist");
        }
        String string = "file:/" + file.toString();
        UnMouse.loadJmf(string);
        UnMouse.setSystemPreference(PROP_JMF, string.toString());
        return true;
    }

    public static void loadJmf(String string) throws JmfException {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        try {
            classLoader = new URLClassLoader(new URL[]{new URL(string)}, classLoader);
            if (!MediaLoader.load(classLoader)) {
                throw new JmfException("The library does not contain required classes");
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new JmfException("Malformed URL: " + string + ".");
        }
        catch (SecurityException securityException) {
            throw new JmfException("Not a valid library.");
        }
    }

    private static String formatToString(VideoFormat videoFormat) {
        String string = videoFormat instanceof RGBFormat ? "RGB" : (videoFormat instanceof YUVFormat ? "YUV" : "???");
        Dimension dimension = videoFormat.getSize();
        return string + " " + dimension.width + "x" + dimension.height;
    }

    private static void setSystemPreference(String string, String string2) {
        Preferences preferences = Preferences.systemNodeForPackage(class$unmouse$UnMouse == null ? (class$unmouse$UnMouse = UnMouse.class$("unmouse.UnMouse")) : class$unmouse$UnMouse);
        preferences.put(string, string2);
        try {
            preferences.flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Dimension getImageDimension(Image image) {
        try {
            ImageWaiter imageWaiter = new ImageWaiter();
            image.getWidth(imageWaiter);
            image.getHeight(imageWaiter);
            ImageWaiter imageWaiter2 = imageWaiter;
            synchronized (imageWaiter2) {
                while (true) {
                    if (imageWaiter.isDone()) {
                        // MONITOREXIT @DISABLED, blocks:[0, 3, 6, 7] lbl11 : MonitorExitStatement: MONITOREXIT : var2_3
                        if (!imageWaiter.isAborted()) break;
                        return null;
                    }
                    try {
                        imageWaiter.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            int n = image.getWidth(imageWaiter);
            int n2 = image.getHeight(imageWaiter);
            return new Dimension(n, n2);
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public static void main(String[] stringArray) {
        MediaObject mediaObject;
        int n;
        Format[] formatArray;
        Object object;
        UnMouse unMouse = new UnMouse();
        unMouse.show();
        Preferences preferences = Preferences.systemNodeForPackage(class$unmouse$UnMouse == null ? (class$unmouse$UnMouse = UnMouse.class$("unmouse.UnMouse")) : class$unmouse$UnMouse);
        Preferences preferences2 = Preferences.userNodeForPackage(class$unmouse$UnMouse == null ? (class$unmouse$UnMouse = UnMouse.class$("unmouse.UnMouse")) : class$unmouse$UnMouse);
        unMouse.inset.setMessage("Loading JMF");
        unMouse.inset.repaint();
        if (!MediaLoader.loadSystem()) {
            boolean bl = false;
            object = preferences.get(PROP_JMF, null);
            if (object == null) {
                object = preferences2.get(PROP_JMF, null);
            }
            if (object == null) {
                JOptionPane.showMessageDialog(unMouse, "The JMF library is not in the class path. You must locate it to continue. It is probably called jmf.jar somewhere on your disk.");
            } else {
                try {
                    UnMouse.loadJmf((String)object);
                    bl = true;
                }
                catch (JmfException jmfException) {
                    JOptionPane.showMessageDialog(unMouse, "The JMF library is no longer valid. You must locate it to continue. It is probably called jmf.jar somewhere on your disk.");
                }
            }
            if (!bl) {
                try {
                    if (!unMouse.promptJmf()) {
                        System.exit(0);
                    }
                }
                catch (JmfException jmfException) {
                    JOptionPane.showMessageDialog(unMouse, jmfException.getMessage() + " The program must abort.");
                    System.exit(0);
                }
            }
        }
        unMouse.inset.setMessage(null);
        unMouse.inset.repaint();
        String string = preferences.get(PROP_DEVICE, null);
        if (string == null) {
            string = preferences2.get(PROP_DEVICE, null);
        }
        if (string != null) {
            object = CaptureDeviceManager.getDeviceList(new RGBFormat());
            formatArray = CaptureDeviceManager.getDeviceList(new YUVFormat());
            ((Vector)object).addAll(formatArray);
            n = 0;
            while (n < ((Vector)object).size()) {
                mediaObject = (CaptureDeviceInfo)((Vector)object).get(n);
                if (string.equals(mediaObject.getName())) {
                    unMouse.device = mediaObject;
                    break;
                }
                ++n;
            }
        } else {
            unMouse.inset.setMessage(CAMERA_NEEDED);
            unMouse.inset.repaint();
        }
        object = preferences2.get(PROP_FORMAT, null);
        if (object == null) {
            object = preferences.get(PROP_FORMAT, null);
        }
        if (object != null) {
            formatArray = unMouse.device.getFormats();
            n = 0;
            while (n < formatArray.length) {
                if (formatArray[n] instanceof VideoFormat && ((String)object).equals(UnMouse.formatToString((VideoFormat)(mediaObject = (VideoFormat)formatArray[n])))) {
                    unMouse.setFormat((VideoFormat)mediaObject);
                    break;
                }
                ++n;
            }
        }
        unMouse.updateGrabber();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class Inset
    extends JPanel
    implements ProgressListener {
        Image video = null;
        Dimension video_dim;
        int cur_x;
        int cur_y;
        Color box_color = new Color(1.0f, 0.0f, 0.0f, 0.5f);
        String saved_message = null;
        String message = null;
        boolean show_progress;
        double progress;

        Inset(int n, int n2) {
            this.setPreferredSize(new Dimension(n2, n));
            this.setBackground(Color.blue);
        }

        public void paintComponent(Graphics graphics) {
            int n;
            int n2;
            super.paintComponent(graphics);
            int n3 = this.getWidth();
            int n4 = this.getHeight();
            if (this.video != null) {
                graphics.drawImage(this.video, 0, 0, this);
                n2 = 20;
                graphics.setColor(Color.gray);
                graphics.drawRect(n2, n2, this.video_dim.width - 2 * n2, this.video_dim.height - 2 * n2);
                n = 20;
                graphics.setColor(this.box_color);
                graphics.fillRect(this.cur_x - n, this.cur_y - n, n * 2 + 1, n * 2 + 1);
            }
            if (this.message != null) {
                graphics.setColor(Color.white);
                FontMetrics fontMetrics = graphics.getFontMetrics();
                n = (n3 - fontMetrics.stringWidth(this.message)) / 2;
                graphics.drawString(this.message, n, n4 / 2);
            }
            if (this.show_progress) {
                n2 = n3 - 2 * PROGRESS_MARGIN;
                n = (int)((double)n2 * this.progress);
                int n5 = n4 / 2 + PROGRESS_MARGIN;
                graphics.setColor(Color.white);
                graphics.drawRect(PROGRESS_MARGIN, n5, n2, PROGRESS_HEIGHT);
                graphics.fillRect(PROGRESS_MARGIN, n5, n, PROGRESS_HEIGHT);
            }
        }

        public void setMessage(String string) {
            this.message = string;
        }

        public void setProgress(double d) {
            this.progress = d;
        }

        String getMessage() {
            return this.message;
        }

        void setShowProgress(boolean bl) {
            if (!this.show_progress && bl) {
                this.saved_message = this.message;
            } else if (this.show_progress && !bl) {
                this.message = this.saved_message;
                this.saved_message = null;
            }
            this.show_progress = bl;
        }

        void updatePoint(int n, int n2) {
            this.cur_x = n;
            this.cur_y = n2;
        }

        void updateImage(Image image) {
            this.video = image;
            this.video_dim = UnMouse.getImageDimension(image);
            this.repaint();
        }
    }

    private class WindowCloser
    extends WindowAdapter {
        private WindowCloser() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            System.exit(0);
        }
    }

    private class AboutItem
    extends JMenuItem
    implements ActionListener {
        public AboutItem() {
            super("About");
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JPanel jPanel;
            Image image = Toolkit.getDefaultToolkit().createImage("unmouse/unmouse-about.jpg");
            JDialog jDialog = new JDialog(UnMouse.this, "About Un-Mouse v0.01", true);
            ImageCanvas imageCanvas = new ImageCanvas(image);
            if (imageCanvas.doesExist()) {
                imageCanvas.setBorder(BorderFactory.createLoweredBevelBorder());
                jPanel = new JPanel();
                jPanel.add(imageCanvas);
                jDialog.getContentPane().add((Component)jPanel, "Center");
            } else {
                jDialog.getContentPane().add(new JLabel("Visit www.cburch.com/proj/unmouse/."));
            }
            jPanel = new JPanel();
            jPanel.add(new DlogCloseButton(jDialog));
            jDialog.getContentPane().add((Component)jPanel, "South");
            jDialog.pack();
            jDialog.show();
        }
    }

    private class DlogCloseButton
    extends JButton
    implements ActionListener {
        private JDialog dlog;

        DlogCloseButton(JDialog jDialog) {
            super("OK");
            this.addActionListener(this);
            this.dlog = jDialog;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.dlog.dispose();
        }
    }

    private class ImageCanvas
    extends JPanel {
        private Image img;
        private boolean exists = true;

        ImageCanvas(Image image) {
            this.img = image;
            Dimension dimension = UnMouse.getImageDimension(image);
            if (dimension != null) {
                this.setPreferredSize(dimension);
                this.exists = true;
            } else {
                this.exists = false;
            }
        }

        boolean doesExist() {
            return this.exists;
        }

        public void paintComponent(Graphics graphics) {
            graphics.drawImage(this.img, 0, 0, this);
        }
    }

    private static class ImageWaiter
    implements ImageObserver {
        boolean height = false;
        boolean width = false;
        boolean aborted = false;

        private ImageWaiter() {
        }

        public boolean isDone() {
            return this.aborted || this.width && this.height;
        }

        public boolean isAborted() {
            return this.aborted;
        }

        public synchronized boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
            if ((n & 2) != 0) {
                this.height = true;
            }
            if ((n & 1) != 0) {
                this.width = true;
            }
            if ((n & 0x80) != 0) {
                this.aborted = true;
            }
            if ((n & 0x40) != 0) {
                this.aborted = true;
            }
            if (this.isDone()) {
                this.notifyAll();
                return false;
            }
            return true;
        }
    }

    private class QuitItem
    extends JMenuItem
    implements ActionListener {
        public QuitItem() {
            super("Quit");
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            System.exit(0);
        }
    }

    private class SetJmfItem
    extends JMenuItem
    implements ActionListener {
        public SetJmfItem() {
            super("Locate JMF...");
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                UnMouse.this.promptJmf();
            }
            catch (JmfException jmfException) {
                JOptionPane.showMessageDialog(UnMouse.this, jmfException.getMessage());
            }
        }
    }

    private static class JmfException
    extends Exception {
        JmfException(String string) {
            super(string);
        }
    }

    private class SetFormat
    extends JMenuItem
    implements ActionListener {
        public SetFormat() {
            super("Set Image Format...");
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (UnMouse.this.device == null) {
                JOptionPane.showMessageDialog(UnMouse.this, "You must select a device first.");
                return;
            }
            Format[] formatArray = UnMouse.this.device.getFormats();
            int n = 0;
            int n2 = 0;
            while (n2 < formatArray.length) {
                if (ImageGrabber.acceptsFormat(formatArray[n2])) {
                    ++n;
                } else {
                    formatArray[n2] = null;
                }
                ++n2;
            }
            Object[] objectArray = new Object[n];
            int n3 = 0;
            int n4 = 0;
            while (n4 < formatArray.length) {
                if (formatArray[n4] != null) {
                    objectArray[n3++] = new FormatItem((VideoFormat)formatArray[n4]);
                }
                ++n4;
            }
            Object object = JOptionPane.showInputDialog(UnMouse.this, "Select a format.", "Select format", 1, null, objectArray, objectArray[0]);
            if (object != null) {
                UnMouse.this.setFormat(((FormatItem)object).format);
                UnMouse.this.updateGrabber();
                UnMouse.setSystemPreference(PROP_FORMAT, object.toString());
            }
        }
    }

    private class FormatItem {
        VideoFormat format;
        String desc;

        FormatItem(VideoFormat videoFormat) {
            this.format = videoFormat;
            this.desc = UnMouse.formatToString(videoFormat);
        }

        public String toString() {
            return this.desc;
        }
    }

    private class SetDevice
    extends JMenuItem
    implements ActionListener {
        public SetDevice() {
            super("Set Device...");
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Vector vector = CaptureDeviceManager.getDeviceList(new RGBFormat());
            Vector vector2 = CaptureDeviceManager.getDeviceList(new YUVFormat());
            int n = 0;
            while (n < vector2.size()) {
                if (!vector.contains(vector2.get(n))) {
                    vector.add(vector2.get(n));
                }
                ++n;
            }
            Object[] objectArray = new Object[vector.size()];
            int n2 = 0;
            while (n2 < vector.size()) {
                objectArray[n2] = new DeviceItem((CaptureDeviceInfo)vector.get(n2));
                ++n2;
            }
            Object object = JOptionPane.showInputDialog(UnMouse.this, "Select a device.", "Select device", 1, null, objectArray, objectArray[0]);
            if (object != null) {
                UnMouse.this.device = ((DeviceItem)object).device;
                if (UnMouse.this.inset.getMessage() == CAMERA_NEEDED) {
                    UnMouse.this.inset.setMessage(null);
                }
                UnMouse.this.updateGrabber();
                UnMouse.setSystemPreference(PROP_DEVICE, object.toString());
            }
        }
    }

    private class DeviceItem {
        CaptureDeviceInfo device;

        DeviceItem(CaptureDeviceInfo captureDeviceInfo) {
            this.device = captureDeviceInfo;
        }

        public String toString() {
            return this.device.getName();
        }
    }

    private class MyHandListener
    implements HandTrackListener {
        private MyHandListener() {
        }

        public void updateCursor(int n, int n2) {
            UnMouse.this.inset.updatePoint(n, n2);
            UnMouse.this.inset.repaint();
        }
    }
}

