/*
 * Decompiled with CFR 0.152.
 */
package unmouse.media;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import unmouse.media.DataSource;
import unmouse.media.MediaLocator;
import unmouse.media.MediaObject;
import unmouse.media.NoDataSourceException;
import unmouse.media.NoProcessorException;
import unmouse.media.Processor;

public final class Manager
extends MediaObject {
    static Class type;
    static Method m_createDataSource;
    static Method m_createProcessor;

    static void loadMethods() throws NoSuchMethodException {
        m_createDataSource = type.getMethod("createDataSource", MediaLocator.type);
        m_createProcessor = type.getMethod("createProcessor", DataSource.type);
    }

    Manager(Object object) {
        super(object);
    }

    public static DataSource createDataSource(MediaLocator mediaLocator) throws IOException, NoDataSourceException {
        try {
            return DataSource.create(m_createDataSource.invoke(null, mediaLocator.instance));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (NoDataSourceException.type.isInstance(throwable)) {
                throw new NoDataSourceException(throwable);
            }
            throw new RuntimeException(invocationTargetException);
        }
    }

    public static Processor createProcessor(DataSource dataSource) throws IOException, NoProcessorException {
        try {
            return new Processor(m_createProcessor.invoke(null, dataSource.instance));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (NoProcessorException.type.isInstance(throwable)) {
                throw new NoProcessorException(throwable);
            }
            throw new RuntimeException(invocationTargetException);
        }
    }
}

