/*
 * Decompiled with CFR 0.152.
 */
package visigrade;

import java.awt.AWTException;
import java.awt.Image;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import java.io.OutputStream;

public class GIFEncoder {
    private short width_;
    private short height_;
    private int numColors_;
    private byte[] pixels_;
    private byte[] colors_;
    private ScreenDescriptor sd_;
    private ImageDescriptor id_;

    public GIFEncoder(Image image) throws AWTException {
        this.width_ = (short)image.getWidth(null);
        this.height_ = (short)image.getHeight(null);
        int[] nArray = new int[this.width_ * this.height_];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, (int)this.width_, (int)this.height_, nArray, 0, (int)this.width_);
        try {
            if (!pixelGrabber.grabPixels()) {
                throw new AWTException("Grabber returned false: " + pixelGrabber.status());
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        byte[][] byArray = new byte[this.width_][this.height_];
        byte[][] byArray2 = new byte[this.width_][this.height_];
        byte[][] byArray3 = new byte[this.width_][this.height_];
        int n = 0;
        int n2 = 0;
        while (n2 < this.height_) {
            int n3 = 0;
            while (n3 < this.width_) {
                byArray[n3][n2] = (byte)(nArray[n] >> 16 & 0xFF);
                byArray2[n3][n2] = (byte)(nArray[n] >> 8 & 0xFF);
                byArray3[n3][n2] = (byte)(nArray[n] & 0xFF);
                ++n;
                ++n3;
            }
            ++n2;
        }
        this.ToIndexedColor(byArray, byArray2, byArray3);
    }

    public GIFEncoder(byte[][] byArray, byte[][] byArray2, byte[][] byArray3) throws AWTException {
        this.width_ = (short)byArray.length;
        this.height_ = (short)byArray[0].length;
        this.ToIndexedColor(byArray, byArray2, byArray3);
    }

    public void write(OutputStream outputStream) throws IOException {
        BitUtils.WriteString(outputStream, "GIF87a");
        ScreenDescriptor screenDescriptor = new ScreenDescriptor(this.width_, this.height_, this.numColors_);
        screenDescriptor.Write(outputStream);
        outputStream.write(this.colors_, 0, this.colors_.length);
        ImageDescriptor imageDescriptor = new ImageDescriptor(this.width_, this.height_, ',');
        imageDescriptor.Write(outputStream);
        byte by = BitUtils.BitsNeeded(this.numColors_);
        if (by == 1) {
            by = (byte)(by + 1);
        }
        outputStream.write(by);
        LZWCompressor.LZWCompress(outputStream, by, this.pixels_);
        outputStream.write(0);
        imageDescriptor = new ImageDescriptor(0, 0, ';');
        imageDescriptor.Write(outputStream);
        outputStream.flush();
    }

    void ToIndexedColor(byte[][] byArray, byte[][] byArray2, byte[][] byArray3) throws AWTException {
        this.pixels_ = new byte[this.width_ * this.height_];
        this.colors_ = new byte[768];
        int n = 0;
        int n2 = 0;
        while (n2 < this.width_) {
            int n3 = 0;
            while (n3 < this.height_) {
                int n4 = 0;
                while (n4 < n) {
                    if (this.colors_[n4 * 3] == byArray[n2][n3] && this.colors_[n4 * 3 + 1] == byArray2[n2][n3] && this.colors_[n4 * 3 + 2] == byArray3[n2][n3]) break;
                    ++n4;
                }
                if (n4 > 255) {
                    throw new AWTException("Too many colors.");
                }
                this.pixels_[n3 * this.width_ + n2] = (byte)n4;
                if (n4 == n) {
                    this.colors_[n4 * 3] = byArray[n2][n3];
                    this.colors_[n4 * 3 + 1] = byArray2[n2][n3];
                    this.colors_[n4 * 3 + 2] = byArray3[n2][n3];
                    ++n;
                }
                ++n3;
            }
            ++n2;
        }
        this.numColors_ = 1 << BitUtils.BitsNeeded(n);
        byte[] byArray4 = new byte[this.numColors_ * 3];
        System.arraycopy(this.colors_, 0, byArray4, 0, this.numColors_ * 3);
        this.colors_ = byArray4;
    }

    private static class BitUtils {
        private BitUtils() {
        }

        /*
         * Unable to fully structure code
         */
        public static byte BitsNeeded(int var0) {
            var1_1 = 1;
            if (var0-- != 0) ** GOTO lbl5
            return 0;
lbl-1000:
            // 1 sources

            {
                var1_1 = (byte)(var1_1 + 1);
lbl5:
                // 2 sources

                ** while ((var0 >>= 1) != 0)
            }
lbl6:
            // 1 sources

            return var1_1;
        }

        public static void WriteWord(OutputStream outputStream, short s) throws IOException {
            outputStream.write(s & 0xFF);
            outputStream.write(s >> 8 & 0xFF);
        }

        static void WriteString(OutputStream outputStream, String string) throws IOException {
            int n = 0;
            while (n < string.length()) {
                outputStream.write((byte)string.charAt(n));
                ++n;
            }
        }
    }

    private static class ImageDescriptor {
        public byte separator_;
        public short leftPosition_;
        public short topPosition_;
        public short width_;
        public short height_;
        private byte byte_;

        public ImageDescriptor(short s, short s2, char c) {
            this.separator_ = (byte)c;
            this.leftPosition_ = 0;
            this.topPosition_ = 0;
            this.width_ = s;
            this.height_ = s2;
            this.SetLocalColorTableSize((byte)0);
            this.SetReserved((byte)0);
            this.SetSortFlag((byte)0);
            this.SetInterlaceFlag((byte)0);
            this.SetLocalColorTableFlag((byte)0);
        }

        public void Write(OutputStream outputStream) throws IOException {
            outputStream.write(this.separator_);
            BitUtils.WriteWord(outputStream, this.leftPosition_);
            BitUtils.WriteWord(outputStream, this.topPosition_);
            BitUtils.WriteWord(outputStream, this.width_);
            BitUtils.WriteWord(outputStream, this.height_);
            outputStream.write(this.byte_);
        }

        public void SetLocalColorTableSize(byte by) {
            this.byte_ = (byte)(this.byte_ | by & 7);
        }

        public void SetReserved(byte by) {
            this.byte_ = (byte)(this.byte_ | (by & 3) << 3);
        }

        public void SetSortFlag(byte by) {
            this.byte_ = (byte)(this.byte_ | (by & 1) << 5);
        }

        public void SetInterlaceFlag(byte by) {
            this.byte_ = (byte)(this.byte_ | (by & 1) << 6);
        }

        public void SetLocalColorTableFlag(byte by) {
            this.byte_ = (byte)(this.byte_ | (by & 1) << 7);
        }
    }

    private static class ScreenDescriptor {
        public short localScreenWidth_;
        public short localScreenHeight_;
        private byte byte_;
        public byte backgroundColorIndex_;
        public byte pixelAspectRatio_;

        public ScreenDescriptor(short s, short s2, int n) {
            this.localScreenWidth_ = s;
            this.localScreenHeight_ = s2;
            this.SetGlobalColorTableSize((byte)(BitUtils.BitsNeeded(n) - 1));
            this.SetGlobalColorTableFlag((byte)1);
            this.SetSortFlag((byte)0);
            this.SetColorResolution((byte)7);
            this.backgroundColorIndex_ = 0;
            this.pixelAspectRatio_ = 0;
        }

        public void Write(OutputStream outputStream) throws IOException {
            BitUtils.WriteWord(outputStream, this.localScreenWidth_);
            BitUtils.WriteWord(outputStream, this.localScreenHeight_);
            outputStream.write(this.byte_);
            outputStream.write(this.backgroundColorIndex_);
            outputStream.write(this.pixelAspectRatio_);
        }

        public void SetGlobalColorTableSize(byte by) {
            this.byte_ = (byte)(this.byte_ | by & 7);
        }

        public void SetSortFlag(byte by) {
            this.byte_ = (byte)(this.byte_ | (by & 1) << 3);
        }

        public void SetColorResolution(byte by) {
            this.byte_ = (byte)(this.byte_ | (by & 7) << 4);
        }

        public void SetGlobalColorTableFlag(byte by) {
            this.byte_ = (byte)(this.byte_ | (by & 1) << 7);
        }
    }

    private static class LZWCompressor {
        private LZWCompressor() {
        }

        public static void LZWCompress(OutputStream outputStream, int n, byte[] byArray) throws IOException {
            short s = -1;
            BitFile bitFile = new BitFile(outputStream);
            LZWStringTable lZWStringTable = new LZWStringTable();
            int n2 = 1 << n;
            int n3 = n2 + 1;
            int n4 = n + 1;
            int n5 = (1 << n4) - 1;
            lZWStringTable.ClearTable(n);
            bitFile.WriteBits(n2, n4);
            int n6 = 0;
            while (n6 < byArray.length) {
                byte by = byArray[n6];
                short s2 = lZWStringTable.FindCharString(s, by);
                if (s2 != -1) {
                    s = s2;
                } else {
                    bitFile.WriteBits(s, n4);
                    if (lZWStringTable.AddCharString(s, by) > n5) {
                        if (++n4 > 12) {
                            bitFile.WriteBits(n2, n4 - 1);
                            lZWStringTable.ClearTable(n);
                            n4 = n + 1;
                        }
                        n5 = (1 << n4) - 1;
                    }
                    s = (short)((short)by & 0xFF);
                }
                ++n6;
            }
            if (s != -1) {
                bitFile.WriteBits(s, n4);
            }
            bitFile.WriteBits(n3, n4);
            bitFile.Flush();
        }
    }

    private static class LZWStringTable {
        private static final int RES_CODES = 2;
        private static final short HASH_FREE = -1;
        private static final short NEXT_FIRST = -1;
        private static final int MAXBITS = 12;
        private static final int MAXSTR = 4096;
        private static final short HASHSIZE = 9973;
        private static final short HASHSTEP = 2039;
        byte[] strChr_ = new byte[4096];
        short[] strNxt_ = new short[4096];
        short[] strHsh_ = new short[9973];
        short numStrings_;

        public int AddCharString(short n, byte by) {
            if (this.numStrings_ >= 4096) {
                return 65535;
            }
            int n2 = LZWStringTable.Hash((short)n, by);
            while (this.strHsh_[n2] != -1) {
                n2 = (n2 + 2039) % 9973;
            }
            this.strHsh_[n2] = this.numStrings_;
            this.strChr_[this.numStrings_] = by;
            this.strNxt_[this.numStrings_] = n != -1 ? n : -1;
            short s = this.numStrings_;
            this.numStrings_ = (short)(s + 1);
            return s;
        }

        public short FindCharString(short s, byte by) {
            short s2;
            if (s == -1) {
                return by;
            }
            int n = LZWStringTable.Hash(s, by);
            while ((s2 = this.strHsh_[n]) != -1) {
                if (this.strNxt_[s2] == s && this.strChr_[s2] == by) {
                    return s2;
                }
                n = (n + 2039) % 9973;
            }
            return -1;
        }

        public void ClearTable(int n) {
            this.numStrings_ = 0;
            int n2 = 0;
            while (n2 < 9973) {
                this.strHsh_[n2] = -1;
                ++n2;
            }
            int n3 = (1 << n) + 2;
            int n4 = 0;
            while (n4 < n3) {
                this.AddCharString((short)-1, (byte)n4);
                ++n4;
            }
        }

        public static int Hash(short s, byte by) {
            return (((short)(by << 8) ^ s) & 0xFFFF) % 9973;
        }
    }

    private static class BitFile {
        OutputStream output_;
        byte[] buffer_;
        int index_;
        int bitsLeft_;

        public BitFile(OutputStream outputStream) {
            this.output_ = outputStream;
            this.buffer_ = new byte[256];
            this.index_ = 0;
            this.bitsLeft_ = 8;
        }

        public void Flush() throws IOException {
            int n = this.index_ + (this.bitsLeft_ == 8 ? 0 : 1);
            if (n > 0) {
                this.output_.write(n);
                this.output_.write(this.buffer_, 0, n);
                this.buffer_[0] = 0;
                this.index_ = 0;
                this.bitsLeft_ = 8;
            }
        }

        public void WriteBits(int n, int n2) throws IOException {
            int n3 = 0;
            int n4 = 255;
            do {
                if (this.index_ == 254 && this.bitsLeft_ == 0 || this.index_ > 254) {
                    this.output_.write(n4);
                    this.output_.write(this.buffer_, 0, n4);
                    this.buffer_[0] = 0;
                    this.index_ = 0;
                    this.bitsLeft_ = 8;
                }
                if (n2 <= this.bitsLeft_) {
                    int n5 = this.index_;
                    this.buffer_[n5] = (byte)(this.buffer_[n5] | (n & (1 << n2) - 1) << 8 - this.bitsLeft_);
                    n3 += n2;
                    this.bitsLeft_ -= n2;
                    n2 = 0;
                    continue;
                }
                int n6 = this.index_++;
                this.buffer_[n6] = (byte)(this.buffer_[n6] | (n & (1 << this.bitsLeft_) - 1) << 8 - this.bitsLeft_);
                n3 += this.bitsLeft_;
                n >>= this.bitsLeft_;
                n2 -= this.bitsLeft_;
                this.buffer_[this.index_] = 0;
                this.bitsLeft_ = 8;
            } while (n2 != 0);
        }
    }
}

