/*
 * Decompiled with CFR 0.152.
 */
package visigrade;

import java.util.Arrays;
import visigrade.Graph;

public class GradeSampler
implements Graph.Sampler {
    private static double SLUSH_MULT = 0.05;
    private double[] data;
    private double xmin;
    private double xmax;
    private double ymax;
    private double total;
    private double total_sq;
    private double slush;
    private int bar_width = 10;
    private Graph graph = null;

    public GradeSampler(double[] dArray) {
        this.setData(dArray);
        double d = (this.xmax - this.xmin) * SLUSH_MULT;
        if (d < SLUSH_MULT) {
            d = SLUSH_MULT;
        }
        this.setSlush(d);
    }

    public void setGraph(Graph graph) {
        this.graph = graph;
    }

    public void setData(double[] dArray) {
        double d;
        this.data = new double[dArray.length];
        System.arraycopy(dArray, 0, this.data, 0, this.data.length);
        Arrays.sort(this.data);
        this.total = this.data[0];
        this.total_sq = this.total * this.total;
        this.xmin = this.data[0];
        this.xmax = this.data[0];
        int n = 1;
        while (n < this.data.length) {
            d = this.data[n];
            this.total += d;
            this.total_sq += d * d;
            if (d > this.xmax) {
                this.xmax = d;
            }
            if (d < this.xmin) {
                this.xmin = d;
            }
            ++n;
        }
        d = this.xmax - this.xmin;
        if (d > 0.0) {
            this.xmin -= d * SLUSH_MULT;
            this.xmax += d * SLUSH_MULT;
        } else {
            this.xmin -= 1.0;
            this.xmax += 1.0;
        }
        this.setSlush(this.slush);
        if (this.graph != null) {
            this.graph.repaint();
        }
    }

    public double getSlush() {
        return this.slush;
    }

    public void setSlush(double d) {
        this.slush = d;
        this.ymax = this.sample(this.data[0]);
        int n = 0;
        while (n < this.data.length) {
            double d2 = this.sample(this.data[n]);
            if (d2 > this.ymax) {
                this.ymax = d2;
            }
            ++n;
        }
        if (this.graph != null) {
            this.graph.repaint();
        }
    }

    public double getMean() {
        return this.total / (double)this.data.length;
    }

    public double getStandardDeviation() {
        double d = this.getMean();
        return Math.sqrt(this.total_sq / (double)this.data.length - d * d);
    }

    public double getMedian() {
        int n = this.data.length;
        if (n % 2 == 1) {
            return this.data[(n - 1) / 2];
        }
        return 0.5 * this.data[(n - 2) / 2] + 0.5 * this.data[n / 2];
    }

    public double getFirstQuartile() {
        int n = this.data.length;
        if (n < 4) {
            return this.data[0];
        }
        if (n % 4 == 0) {
            return 0.5 * this.data[n / 4 - 1] + 0.5 * this.data[n / 4];
        }
        if (n % 4 == 2) {
            return this.data[(n - 2) / 4];
        }
        if (n % 4 == 1) {
            return 0.75 * this.data[(n - 1) / 4 - 1] + 0.25 * this.data[(n - 1) / 4];
        }
        return 0.25 * this.data[(n + 1) / 4 - 1] + 0.75 * this.data[(n + 1) / 4];
    }

    public double getThirdQuartile() {
        int n = this.data.length;
        if (n < 4) {
            return this.data[n - 1];
        }
        if (n % 4 == 0) {
            return 0.5 * this.data[3 * n / 4 - 1] + 0.5 * this.data[3 * n / 4];
        }
        if (n % 4 == 2) {
            return this.data[3 * (n - 2) / 4 + 1];
        }
        if (n % 4 == 1) {
            return 0.25 * this.data[3 * (n - 1) / 4] + 0.75 * this.data[3 * (n - 1) / 4 + 1];
        }
        return 0.75 * this.data[3 * (n + 1) / 4 - 2] + 0.25 * this.data[3 * (n + 1) / 4 - 1];
    }

    public void setXMin(double d) {
        this.xmin = d;
    }

    public void setXMax(double d) {
        this.xmax = d;
    }

    public double getXMin() {
        return this.xmin;
    }

    public double getXMax() {
        return this.xmax;
    }

    public double getYMin() {
        return 0.0;
    }

    public double getYMax() {
        return this.ymax;
    }

    public double sample(double d) {
        double d2;
        double d3 = 0.0;
        int n = 0;
        while (n < this.data.length) {
            d2 = (this.data[n] - d) / this.slush;
            double d4 = Math.exp(-(d2 * d2));
            d3 += d4;
            ++n;
        }
        d2 = d3;
        return d2;
    }
}

