/*
 * Decompiled with CFR 0.152.
 */
package visigrade;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import visigrade.Canvas;

public class Graph
extends Canvas {
    private static int PREF_WIDTH = 400;
    private static int PREF_HEIGHT = 200;
    private Sampler sampler;

    public Graph(Sampler sampler) {
        super(new Drawer(sampler), PREF_WIDTH, PREF_HEIGHT);
        this.sampler = sampler;
    }

    public boolean getShowXAxis() {
        return ((Drawer)this.getDrawer()).show_xaxis;
    }

    public void setShowXAxis(boolean bl) {
        ((Drawer)this.getDrawer()).show_xaxis = bl;
        this.repaint();
    }

    public double getTickFrequency() {
        return ((Drawer)this.getDrawer()).tick_freq;
    }

    public void setTickFrequency(double d) {
        ((Drawer)this.getDrawer()).tick_freq = d;
        this.repaint();
    }

    public boolean getLabelPeaks() {
        return ((Drawer)this.getDrawer()).show_peaks;
    }

    public void setLabelPeaks(boolean bl) {
        ((Drawer)this.getDrawer()).show_peaks = bl;
        this.repaint();
    }

    public boolean getLabelValleys() {
        return ((Drawer)this.getDrawer()).show_valleys;
    }

    public void setLabelValleys(boolean bl) {
        ((Drawer)this.getDrawer()).show_valleys = bl;
        this.repaint();
    }

    public Image getImage() {
        Image image = this.createImage(this.getWidth(), this.getHeight());
        this.paintComponent(image.getGraphics());
        return image;
    }

    private class MouseListener
    extends MouseAdapter {
        int start_x;
        int start_y;

        private MouseListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.start_x = mouseEvent.getX();
            this.start_y = 2 - mouseEvent.getY();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = 2 - mouseEvent.getY();
            int n3 = Math.min(this.start_x, n);
            int n4 = Math.max(this.start_x, n);
            int n5 = Math.min(this.start_y, n2);
            int n6 = Math.max(this.start_y, n2);
            double d = Graph.this.sampler.getXMin();
            double d2 = Graph.this.sampler.getYMin();
            double d3 = Graph.this.sampler.getXMax() - d;
            double d4 = Graph.this.sampler.getYMax() - d2;
            int n7 = Graph.this.getWidth();
            int n8 = Graph.this.getHeight();
            double d5 = (double)n3 * d3 / (double)n7 + d;
            double d6 = (double)n4 * d3 / (double)n7 + d;
            double d7 = (double)n5 * d4 / (double)n8 + d2;
            double d8 = (double)n6 * d4 / (double)n8 + d2;
            Graph.this.sampler = new ZoomSampler(Graph.this.sampler, d5, d6, d7, d8);
            Graph.this.setDrawer(new Drawer(Graph.this.sampler));
        }
    }

    private static class Drawer
    implements Canvas.Drawer {
        private Sampler sampler;
        private boolean show_peaks = true;
        private boolean show_valleys = false;
        private boolean show_xaxis = false;
        private double tick_freq = 0.0;

        public Drawer(Sampler sampler) {
            this.sampler = sampler;
        }

        public void paint(Canvas canvas, Graphics graphics) {
            int n;
            int n2 = canvas.getWidth();
            int n3 = canvas.getHeight();
            double d = this.sampler.getXMin();
            double d2 = this.sampler.getXMax();
            double d3 = this.sampler.getYMin();
            double d4 = d2 - d;
            double d5 = this.sampler.getYMax() - d3;
            double d6 = d4 / (double)n2;
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n4 = 2;
            int n5 = fontMetrics.getAscent() + fontMetrics.getDescent();
            int n6 = n4 + n5;
            int n7 = 0;
            double d7 = d3;
            boolean bl = true;
            int n8 = n3 - 2 * n6;
            int n9 = n3 - n6;
            int[] nArray = new int[n2];
            int[] nArray2 = new int[n2];
            if (this.show_xaxis) {
                graphics.setColor(Color.gray);
                graphics.drawLine(0, n9, n2, n9);
            }
            if (this.tick_freq > 0.0) {
                n = (int)(d / this.tick_freq);
                int n10 = 1 + n;
                while ((double)n10 * this.tick_freq < d2) {
                    double d8 = (double)n10 * this.tick_freq;
                    String string = "" + d8;
                    int n11 = (int)Math.round((double)n2 * (d8 - d) / d4);
                    graphics.setColor(Color.gray);
                    graphics.drawLine(n11, n9, n11, n9 + n4);
                    graphics.setColor(Color.black);
                    graphics.drawString(string, n11 - fontMetrics.stringWidth(string) / 2, n9 + n4 + fontMetrics.getAscent());
                    ++n10;
                }
            }
            n = 0;
            while (n < n2) {
                int n12;
                String string;
                double d9;
                double d10;
                double d11 = d4 * (double)n / (double)n2 + d;
                double d12 = this.sampler.sample(d11);
                double d13 = this.sampler.sample(d11 - d6 / 2.0);
                double d14 = this.sampler.sample(d11 + d6 / 2.0);
                int n13 = n3 - n6 - (int)Math.round(((d12 = d12 < d13 && d12 < d14 ? this.sampler.sample(this.findMin(d11 - d6 / 2.0, d11 + d6 / 2.0)) : (d12 > d13 && d12 > d14 ? this.sampler.sample(this.findMax(d11 - d6 / 2.0, d11 + d6 / 2.0)) : (d13 + 2.0 * d12 + d14) / 4.0)) - d3) / d5 * (double)n8);
                if (n13 > n3 - 1) {
                    n13 = n3 - 1;
                }
                if (n13 < 0) {
                    n13 = 0;
                }
                nArray[n] = n;
                nArray2[n] = n13;
                if (d7 > d12) {
                    if (this.show_peaks && bl) {
                        d10 = d4 * (double)(n - n4) / (double)n2 + d;
                        d9 = this.findMax(d10, d11);
                        d9 = (double)Math.round(d9 * 10.0) / 10.0;
                        string = "" + d9;
                        n12 = n - 1 - fontMetrics.stringWidth(string) / 2;
                        graphics.setColor(Color.red);
                        graphics.drawString(string, n12, n7 - n4);
                    }
                    bl = false;
                } else {
                    if (this.show_valleys && !bl) {
                        d10 = d4 * (double)(n - 2) / (double)n2 + d;
                        d9 = this.findMin(d10, d11);
                        d9 = (double)Math.round(d9 * 10.0) / 10.0;
                        string = "" + d9;
                        n12 = n - 1 - fontMetrics.stringWidth(string) / 2;
                        graphics.setColor(Color.red);
                        graphics.drawString(string, n12, n7 + n4 + fontMetrics.getAscent());
                    }
                    bl = true;
                }
                d7 = d12;
                n7 = n13;
                ++n;
            }
            this.switchToWidth(graphics, 2);
            graphics.setColor(Color.blue);
            graphics.drawPolyline(nArray, nArray2, nArray.length);
            this.switchToWidth(graphics, 1);
        }

        private void switchToWidth(Graphics graphics, int n) {
            if (graphics instanceof Graphics2D) {
                ((Graphics2D)graphics).setStroke(new BasicStroke(n));
            }
        }

        private double findMax(double d, double d2) {
            double d3 = (2.0 * d + d2) / 3.0;
            double d4 = (d + 2.0 * d2) / 3.0;
            double d5 = this.sampler.sample(d);
            double d6 = this.sampler.sample(d3);
            double d7 = this.sampler.sample(d4);
            double d8 = this.sampler.sample(d2);
            int n = 0;
            while (n < 20 && Math.abs(d2 - d) > 0.001) {
                if (d6 > d7) {
                    d2 = d4;
                    d8 = d7;
                    d4 = (d3 + d2) / 2.0;
                    d7 = this.sampler.sample(d4);
                } else {
                    d = d3;
                    d5 = d6;
                    d3 = (d + d4) / 2.0;
                    d6 = this.sampler.sample(d3);
                }
                ++n;
            }
            double d9 = d;
            double d10 = d5;
            if (d6 > d10) {
                d9 = d3;
                d10 = d6;
            }
            if (d7 > d10) {
                d9 = d4;
                d10 = d7;
            }
            if (d8 > d10) {
                d9 = d2;
                d10 = d8;
            }
            return d9;
        }

        private double findMin(double d, double d2) {
            double d3 = (2.0 * d + d2) / 3.0;
            double d4 = (d + 2.0 * d2) / 3.0;
            double d5 = this.sampler.sample(d);
            double d6 = this.sampler.sample(d3);
            double d7 = this.sampler.sample(d4);
            double d8 = this.sampler.sample(d2);
            int n = 0;
            while (n < 20 && Math.abs(d2 - d) > 0.01) {
                if (d6 < d7) {
                    d2 = d4;
                    d8 = d7;
                    d4 = (d3 + d2) / 2.0;
                    d7 = this.sampler.sample(d4);
                } else {
                    d = d3;
                    d5 = d6;
                    d3 = (d + d4) / 2.0;
                    d6 = this.sampler.sample(d3);
                }
                ++n;
            }
            double d9 = d;
            double d10 = d5;
            if (d6 > d10) {
                d9 = d3;
                d10 = d6;
            }
            if (d7 > d10) {
                d9 = d4;
                d10 = d7;
            }
            if (d8 > d10) {
                d9 = d2;
                d10 = d8;
            }
            return d9;
        }
    }

    private static class ZoomSampler
    implements Sampler {
        private static double DERV_MIN = -10.0;
        private static double DERV_MAX = 10.0;
        private Sampler sampler;
        private double xmin;
        private double xmax;
        private double ymin;
        private double ymax;

        public ZoomSampler(Sampler sampler, double d, double d2, double d3, double d4) {
            this.sampler = sampler;
            this.xmin = d;
            this.xmax = d2;
            this.ymin = d3;
            this.ymax = d4;
        }

        public double getXMin() {
            return this.xmin;
        }

        public double getXMax() {
            return this.xmax;
        }

        public double getYMin() {
            return this.ymin;
        }

        public double getYMax() {
            return this.ymax;
        }

        public double sample(double d) {
            return this.sampler.sample(d);
        }
    }

    public static interface Sampler {
        public double getXMin();

        public double getXMax();

        public double getYMin();

        public double getYMax();

        public double sample(double var1);
    }
}

