/*
 * Decompiled with CFR 0.152.
 */
package visigrade;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import visigrade.ColumnLayout;
import visigrade.GIFEncoder;
import visigrade.GradeSampler;
import visigrade.Graph;

public class GraphWindow {
    private static int SLUSH_MAX_VALUE = 70;
    private static int SLUSH_MIN_VALUE = 1;
    private static double SLUSH_DELTA = 0.1;
    private static int SLUSH_MAJOR_START = 10;
    private static int SLUSH_MAJOR_DELTA = 10;
    private static int STATS_WIDTH = 13;
    private JFrame frame;
    private GradeSampler sampler;
    private Graph graph;
    private StatsPanel stats;

    public GraphWindow(double[] dArray) {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(new FileMenu());
        jMenuBar.add(new HelpMenu());
        this.sampler = new GradeSampler(dArray);
        this.graph = new Graph(this.sampler);
        this.stats = new StatsPanel();
        ControlPanel controlPanel = new ControlPanel();
        this.frame = new JFrame();
        this.frame.addWindowListener(new WindowListener());
        this.frame.setTitle("Visigrade");
        this.frame.setJMenuBar(jMenuBar);
        this.frame.getContentPane().add((Component)controlPanel, "North");
        this.frame.getContentPane().add((Component)this.graph, "Center");
        this.frame.getContentPane().add((Component)this.stats, "South");
        this.graph.setBorder(BorderFactory.createBevelBorder(1));
        this.frame.pack();
        this.sampler.setGraph(this.graph);
    }

    public void show() {
        this.frame.show();
    }

    public void dispose() {
        this.frame.dispose();
        System.exit(0);
    }

    public void loadData(InputStream inputStream) {
        Object object;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        ArrayList<Double> arrayList = new ArrayList<Double>();
        int n = 1;
        while (true) {
            object = "";
            try {
                object = bufferedReader.readLine();
                if (object == null) {
                    break;
                }
            }
            catch (IOException iOException) {
                System.err.print("line " + n + ": ");
                iOException.printStackTrace();
                System.exit(-1);
            }
            StringTokenizer stringTokenizer = new StringTokenizer((String)object);
            if (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                try {
                    double d = Double.parseDouble(string);
                    arrayList.add(new Double(d));
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(this.frame, "line " + n + ": " + "unrecognized number `" + string + "'");
                    return;
                }
            }
            ++n;
        }
        if (arrayList.size() == 0) {
            JOptionPane.showMessageDialog(this.frame, "no scores found in file");
            return;
        }
        object = new double[arrayList.size()];
        int n2 = 0;
        while (n2 < ((Object)object).length) {
            object[n2] = (Double)arrayList.get(n2);
            ++n2;
        }
        this.sampler.setData((double[])object);
        this.stats.update();
    }

    private class StatsPanel
    extends JPanel {
        JTextField mean_field;
        JTextField stddev_field;
        JTextField median_field;
        JTextField midrange_field;

        public StatsPanel() {
            this.setLayout(new ColumnLayout(2));
            this.mean_field = new JTextField(STATS_WIDTH);
            this.mean_field.setEditable(false);
            this.add((Component)new JLabel("Mean: "), "none");
            this.add((Component)this.mean_field, "horizontal");
            this.stddev_field = new JTextField(STATS_WIDTH);
            this.stddev_field.setEditable(false);
            this.add((Component)new JLabel("Std. Dev.: "), "none");
            this.add((Component)this.stddev_field, "horizontal");
            this.median_field = new JTextField(STATS_WIDTH);
            this.median_field.setEditable(false);
            this.add((Component)new JLabel("Median: "), "none");
            this.add((Component)this.median_field, "horizontal");
            this.midrange_field = new JTextField(STATS_WIDTH);
            this.midrange_field.setEditable(false);
            this.add((Component)new JLabel("Midrange: "), "none");
            this.add((Component)this.midrange_field, "horizontal");
            this.update();
        }

        private void update() {
            this.mean_field.setText("" + this.format(GraphWindow.this.sampler.getMean(), 2));
            this.stddev_field.setText("" + this.format(GraphWindow.this.sampler.getStandardDeviation(), 2));
            this.median_field.setText("" + this.format(GraphWindow.this.sampler.getMedian(), 2));
            this.midrange_field.setText("" + this.format(GraphWindow.this.sampler.getFirstQuartile(), 2) + " - " + this.format(GraphWindow.this.sampler.getThirdQuartile(), 2));
        }

        private String format(double d, int n) {
            double d2 = Math.pow(10.0, n);
            return "" + (double)Math.round(d * d2) / d2;
        }
    }

    private class ControlPanel
    extends JPanel
    implements ItemListener,
    ActionListener {
        private JCheckBox label_peaks = new JCheckBox("Label Peaks");
        private JCheckBox label_valleys = new JCheckBox("Label Valleys");
        private JCheckBox show_xaxis = new JCheckBox("Show X-Axis");
        private JTextField xaxis_ticks = new JTextField();
        private JTextField xaxis_right = new JTextField();
        private JTextField xaxis_left = new JTextField();

        public ControlPanel() {
            JLabel jLabel = new JLabel("");
            this.setLayout(new ColumnLayout(2));
            this.add((Component)new JLabel("Slush:"), "none");
            this.add((Component)new SlushSlider(), "none");
            this.label_peaks.setSelected(GraphWindow.this.graph.getLabelPeaks());
            this.label_peaks.addItemListener(this);
            this.add((Component)jLabel, "none");
            this.add((Component)this.label_peaks, "none");
            this.label_valleys.setSelected(GraphWindow.this.graph.getLabelValleys());
            this.label_valleys.addItemListener(this);
            this.add((Component)jLabel, "none");
            this.add((Component)this.label_valleys, "none");
            this.show_xaxis.setSelected(GraphWindow.this.graph.getShowXAxis());
            this.show_xaxis.addItemListener(this);
            this.add((Component)jLabel, "none");
            this.add((Component)this.show_xaxis, "none");
            this.xaxis_ticks.setText("" + GraphWindow.this.graph.getTickFrequency());
            this.xaxis_ticks.addActionListener(this);
            this.add((Component)new JLabel("Ticks:"), "none");
            this.add((Component)this.xaxis_ticks, "horizontal");
            this.xaxis_left.setText("" + GraphWindow.this.sampler.getXMin());
            this.xaxis_left.addActionListener(this);
            this.add((Component)new JLabel("Minimum X:"), "none");
            this.add((Component)this.xaxis_left, "horizontal");
            this.xaxis_right.setText("" + GraphWindow.this.sampler.getXMax());
            this.xaxis_right.addActionListener(this);
            this.add((Component)new JLabel("Maximum X:"), "none");
            this.add((Component)this.xaxis_right, "horizontal");
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            JComponent jComponent = (JComponent)itemEvent.getSource();
            if (jComponent == this.label_peaks) {
                GraphWindow.this.graph.setLabelPeaks(this.label_peaks.isSelected());
            } else if (jComponent == this.label_valleys) {
                GraphWindow.this.graph.setLabelValleys(this.label_valleys.isSelected());
            } else if (jComponent == this.show_xaxis) {
                GraphWindow.this.graph.setShowXAxis(this.show_xaxis.isSelected());
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JComponent jComponent = (JComponent)actionEvent.getSource();
            if (jComponent == this.xaxis_ticks) {
                try {
                    String string = this.xaxis_ticks.getText();
                    double d = Double.parseDouble(string);
                    GraphWindow.this.graph.setTickFrequency(d);
                }
                catch (NumberFormatException numberFormatException) {
                    this.xaxis_ticks.setText("" + GraphWindow.this.graph.getTickFrequency());
                }
            } else if (jComponent == this.xaxis_left) {
                try {
                    String string = this.xaxis_left.getText();
                    double d = Double.parseDouble(string);
                    GraphWindow.this.sampler.setXMin(d);
                    GraphWindow.this.graph.repaint();
                }
                catch (NumberFormatException numberFormatException) {
                    this.xaxis_left.setText("" + GraphWindow.this.graph.getTickFrequency());
                }
            } else if (jComponent == this.xaxis_right) {
                try {
                    String string = this.xaxis_right.getText();
                    double d = Double.parseDouble(string);
                    GraphWindow.this.sampler.setXMax(d);
                    GraphWindow.this.graph.repaint();
                }
                catch (NumberFormatException numberFormatException) {
                    this.xaxis_right.setText("" + GraphWindow.this.graph.getTickFrequency());
                }
            }
        }
    }

    private class SlushSlider
    extends JSlider
    implements ChangeListener {
        SlushSlider() {
            super(0, SLUSH_MIN_VALUE, SLUSH_MAX_VALUE, (int)Math.round(GraphWindow.this.sampler.getSlush() / SLUSH_DELTA));
            this.addChangeListener(this);
            this.setPaintTicks(true);
            this.setPaintLabels(true);
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
            Hashtable<Integer, JLabel> hashtable = this.getLabelTable();
            if (hashtable == null) {
                hashtable = new Hashtable<Integer, JLabel>();
            }
            int n = SLUSH_MAJOR_START;
            while (n <= SLUSH_MAX_VALUE) {
                ((Dictionary)hashtable).put(new Integer(n), new JLabel("" + (double)n * SLUSH_DELTA));
                n += SLUSH_MAJOR_DELTA;
            }
            this.setLabelTable(hashtable);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (!this.getValueIsAdjusting()) {
                int n = this.getValue();
                GraphWindow.this.sampler.setSlush((double)n * SLUSH_DELTA);
            }
        }
    }

    private class HelpMenu
    extends JMenu
    implements ActionListener {
        private JMenuItem item_about = new JMenuItem("About...");

        public HelpMenu() {
            super("Help");
            this.item_about.addActionListener(this);
            this.add(this.item_about);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.item_about) {
                JOptionPane.showMessageDialog(GraphWindow.this.frame, "v0.1, (c) 2002, Carl Burch. See www.cburch.com/proj/visigrade for details.");
            }
        }
    }

    private class FileMenu
    extends JMenu
    implements ActionListener {
        private JMenuItem item_load;
        private JMenuItem item_gif;
        private JMenuItem item_print;
        private JMenuItem item_quit;
        private JFileChooser chooser = new JFileChooser(System.getProperty("user.dir"));

        public FileMenu() {
            super("File");
            this.item_load = new JMenuItem("Load Data...");
            this.item_load.addActionListener(this);
            this.add(this.item_load);
            this.item_gif = new JMenuItem("Export GIF...");
            this.item_gif.addActionListener(this);
            this.add(this.item_gif);
            this.item_print = new JMenuItem("Print...");
            this.item_print.addActionListener(this);
            this.add(this.item_print);
            this.item_quit = new JMenuItem("Quit");
            this.item_quit.addActionListener(this);
            this.add(this.item_quit);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.item_load) {
                int n = this.chooser.showOpenDialog(GraphWindow.this.frame);
                if (n == 0) {
                    try {
                        File file = this.chooser.getSelectedFile();
                        GraphWindow.this.loadData(new FileInputStream(file));
                    }
                    catch (Exception exception) {
                        JOptionPane.showMessageDialog(GraphWindow.this.frame, "Could not save file: " + exception.getMessage());
                    }
                }
            } else if (object == this.item_gif) {
                int n = this.chooser.showSaveDialog(GraphWindow.this.frame);
                if (n == 0) {
                    try {
                        File file = this.chooser.getSelectedFile();
                        FileOutputStream fileOutputStream = new FileOutputStream(file);
                        GIFEncoder gIFEncoder = new GIFEncoder(GraphWindow.this.graph.getImage());
                        gIFEncoder.write(fileOutputStream);
                    }
                    catch (Exception exception) {
                        JOptionPane.showMessageDialog(GraphWindow.this.frame, "Could not save file: " + exception.getMessage());
                    }
                }
            } else if (object == this.item_print) {
                PrinterJob printerJob = PrinterJob.getPrinterJob();
                if (printerJob.printDialog()) {
                    printerJob.setPageable(new MyPageable());
                    try {
                        printerJob.print();
                    }
                    catch (PrinterException printerException) {
                        JOptionPane.showMessageDialog(null, "Error during printing: " + printerException.toString());
                    }
                }
            } else if (object == this.item_quit) {
                GraphWindow.this.dispose();
                System.exit(0);
            }
        }

        private class MyPageable
        implements Pageable {
            PageFormat format = new PageFormat();
            Printable printable = new MyPrintable();

            private MyPageable() {
            }

            public int getNumberOfPages() {
                return 1;
            }

            public PageFormat getPageFormat(int n) throws IndexOutOfBoundsException {
                if (n < 0 || n >= this.getNumberOfPages()) {
                    throw new IndexOutOfBoundsException();
                }
                return this.format;
            }

            public Printable getPrintable(int n) throws IndexOutOfBoundsException {
                if (n < 0 || n >= this.getNumberOfPages()) {
                    throw new IndexOutOfBoundsException();
                }
                return this.printable;
            }
        }

        private class MyPrintable
        implements Printable {
            private MyPrintable() {
            }

            public int print(Graphics graphics, PageFormat pageFormat, int n) {
                if (graphics instanceof Graphics2D) {
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    int n2 = GraphWindow.this.graph.getWidth();
                    int n3 = GraphWindow.this.graph.getHeight();
                    double d = pageFormat.getImageableWidth();
                    double d2 = pageFormat.getImageableHeight();
                    double d3 = Math.min(Math.min(1.0, d / (double)n2), d2 / (double)n3);
                    graphics2D.scale(d3, d3);
                    graphics2D.translate(pageFormat.getImageableX() / d3, pageFormat.getImageableY() / d3);
                }
                if (n > 1) {
                    return 1;
                }
                GraphWindow.this.graph.paintComponent(graphics);
                return 0;
            }
        }
    }

    private class WindowListener
    extends WindowAdapter {
        private WindowListener() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            GraphWindow.this.dispose();
            System.exit(0);
        }
    }
}

