/*
 * DataRep.java
 *
 * Created on February 19, 2004, 8:45 AM
 */
package DataRep;
/**
 *
 * @author  lziegler
 */
public class DataRep extends javax.swing.JFrame {
    
    /** Creates new form DataRep */
    public DataRep() {
        initComponents();
	setTitle("Data Representation Program");
        modeGroup=new javax.swing.ButtonGroup();
        modeGroup.add(StudentRadioItem);
        modeGroup.add(FacultyRadioItem);
        StudentRadioItem.setSelected(true);
        datatypeGroup=new javax.swing.ButtonGroup();
        datatypeGroup.add(UnsignedRadioItem);
        datatypeGroup.add(SignedRadioItem);
        datatypeGroup.add(HexRadioItem);
        datatypeGroup.add(RealRadioItem);
        datatypeGroup.add(CharacterRadioItem);
        datatypeGroup.add(OctalRadioItem);
        wordSizeGroup=new javax.swing.ButtonGroup();
        wordSizeGroup.add(EightBitRadioItem);
        wordSizeGroup.add(SixteenBitRadioItem);
        wordSizeGroup.add(ThirtyTwoBitRadioItem);
        wordSizeGroup.add(SixtyFourBitRadioItem);
        fontSizeGroup=new javax.swing.ButtonGroup();
        fontSizeGroup.add(SmallRadioItem);
        fontSizeGroup.add(MediumRadioItem);
        fontSizeGroup.add(LargeRadioItem);
        fontSizeGroup.add(ChoiceRadioItem);
        ChoiceRadioItem.setSelected(true);
        ThirtyTwoBitRadioItem.setSelected(true);
        SignedRadioItem.setSelected(true);
        CharacterRadioItem.setEnabled(false);
        setButtonFonts(fontSize);
        wordPanel=(Word) WordPanel;
        setSize(wordPanel.retrieveWidth(),wordPanel.retrieveHeight());
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        ButtonPanel = new javax.swing.JPanel();
        jPanel1 = new javax.swing.JPanel();
        DatatypeLabel = new javax.swing.JLabel();
        Double = new javax.swing.JButton();
        Halve = new javax.swing.JButton();
        Complement = new javax.swing.JButton();
        BlankLabel = new javax.swing.JLabel();
        Increment = new javax.swing.JButton();
        Decrement = new javax.swing.JButton();
        ClearButton = new javax.swing.JButton();
        WordPanel = new Word32(currentValue,fontSize,spaceMode,dataType);
        DataRepMenuBar = new javax.swing.JMenuBar();
        ModeMenu = new javax.swing.JMenu();
        StudentRadioItem = new javax.swing.JRadioButtonMenuItem();
        FacultyRadioItem = new javax.swing.JRadioButtonMenuItem();
        jSeparator1 = new javax.swing.JSeparator();
        PrintItem = new javax.swing.JMenuItem();
        QuitItem = new javax.swing.JMenuItem();
        DataTypeMenu = new javax.swing.JMenu();
        SignedRadioItem = new javax.swing.JRadioButtonMenuItem();
        UnsignedRadioItem = new javax.swing.JRadioButtonMenuItem();
        HexRadioItem = new javax.swing.JRadioButtonMenuItem();
        OctalRadioItem = new javax.swing.JRadioButtonMenuItem();
        CharacterRadioItem = new javax.swing.JRadioButtonMenuItem();
        RealRadioItem = new javax.swing.JRadioButtonMenuItem();
        WordSizeMenu = new javax.swing.JMenu();
        EightBitRadioItem = new javax.swing.JRadioButtonMenuItem();
        SixteenBitRadioItem = new javax.swing.JRadioButtonMenuItem();
        ThirtyTwoBitRadioItem = new javax.swing.JRadioButtonMenuItem();
        SixtyFourBitRadioItem = new javax.swing.JRadioButtonMenuItem();
        FontMenu = new javax.swing.JMenu();
        SmallRadioItem = new javax.swing.JRadioButtonMenuItem();
        MediumRadioItem = new javax.swing.JRadioButtonMenuItem();
        LargeRadioItem = new javax.swing.JRadioButtonMenuItem();
        ChoiceRadioItem = new javax.swing.JRadioButtonMenuItem();
        HelpMenu = new javax.swing.JMenu();
        AboutItem = new javax.swing.JMenuItem();

        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
        });

        jPanel1.setLayout(new java.awt.GridLayout(2, 4));

        DatatypeLabel.setFont(new java.awt.Font("Dialog", 1, 16));
        DatatypeLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        DatatypeLabel.setText("Signed");
        jPanel1.add(DatatypeLabel);

        Double.setFont(new java.awt.Font("Dialog", 1, 16));
        Double.setText("Double");
        Double.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                DoubleActionPerformed(evt);
            }
        });

        jPanel1.add(Double);

        Halve.setFont(new java.awt.Font("Dialog", 1, 16));
        Halve.setText("Halve");
        Halve.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                HalveActionPerformed(evt);
            }
        });

        jPanel1.add(Halve);

        Complement.setFont(new java.awt.Font("Dialog", 1, 16));
        Complement.setText("Complement");
        Complement.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                ComplementActionPerformed(evt);
            }
        });

        jPanel1.add(Complement);

        jPanel1.add(BlankLabel);

        Increment.setFont(new java.awt.Font("Dialog", 1, 16));
        Increment.setText("Increment");
        Increment.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                IncrementActionPerformed(evt);
            }
        });

        jPanel1.add(Increment);

        Decrement.setFont(new java.awt.Font("Dialog", 1, 16));
        Decrement.setText("Decrement");
        Decrement.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                DecrementActionPerformed(evt);
            }
        });

        jPanel1.add(Decrement);

        ClearButton.setFont(new java.awt.Font("Dialog", 1, 16));
        ClearButton.setText("Clear");
        ClearButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                ClearButtonActionPerformed(evt);
            }
        });

        jPanel1.add(ClearButton);

        ButtonPanel.add(jPanel1);

        getContentPane().add(ButtonPanel, java.awt.BorderLayout.SOUTH);

        getContentPane().add(WordPanel, java.awt.BorderLayout.CENTER);

        ModeMenu.setText("Mode");
        StudentRadioItem.setText("Student Mode");
        StudentRadioItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                StudentRadioItemActionPerformed(evt);
            }
        });

        ModeMenu.add(StudentRadioItem);

        FacultyRadioItem.setText("Faculty Mode");
        FacultyRadioItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                FacultyRadioItemActionPerformed(evt);
            }
        });

        ModeMenu.add(FacultyRadioItem);

        ModeMenu.add(jSeparator1);

        PrintItem.setText("Print");
        PrintItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                PrintItemActionPerformed(evt);
            }
        });

        ModeMenu.add(PrintItem);

        QuitItem.setText("Quit");
        QuitItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                QuitItemActionPerformed(evt);
            }
        });

        ModeMenu.add(QuitItem);

        DataRepMenuBar.add(ModeMenu);

        DataTypeMenu.setText("Data Type");
        SignedRadioItem.setText("Signed Decimal");
        SignedRadioItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                SignedRadioItemActionPerformed(evt);
            }
        });

        DataTypeMenu.add(SignedRadioItem);

        UnsignedRadioItem.setText("Unsigned Decimal");
        UnsignedRadioItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                UnsignedRadioItemActionPerformed(evt);
            }
        });

        DataTypeMenu.add(UnsignedRadioItem);

        HexRadioItem.setText("Hexadecimal");
        HexRadioItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                HexRadioItemActionPerformed(evt);
            }
        });

        DataTypeMenu.add(HexRadioItem);

        OctalRadioItem.setText("Octal");
        OctalRadioItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                OctalRadioItemActionPerformed(evt);
            }
        });

        DataTypeMenu.add(OctalRadioItem);

        CharacterRadioItem.setText("Character");
        CharacterRadioItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                CharacterRadioItemActionPerformed(evt);
            }
        });

        DataTypeMenu.add(CharacterRadioItem);

        RealRadioItem.setText("Real");
        RealRadioItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                RealRadioItemActionPerformed(evt);
            }
        });

        DataTypeMenu.add(RealRadioItem);

        DataRepMenuBar.add(DataTypeMenu);

        WordSizeMenu.setText("Word Size");
        EightBitRadioItem.setText("8 Bits");
        EightBitRadioItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                EightBitRadioItemActionPerformed(evt);
            }
        });

        WordSizeMenu.add(EightBitRadioItem);

        SixteenBitRadioItem.setText("16 Bits");
        SixteenBitRadioItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                SixteenBitRadioItemActionPerformed(evt);
            }
        });

        WordSizeMenu.add(SixteenBitRadioItem);

        ThirtyTwoBitRadioItem.setText("32 Bits");
        ThirtyTwoBitRadioItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                ThirtyTwoBitRadioItemActionPerformed(evt);
            }
        });

        WordSizeMenu.add(ThirtyTwoBitRadioItem);

        SixtyFourBitRadioItem.setText("64 Bits");
        SixtyFourBitRadioItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                SixtyFourBitRadioItemActionPerformed(evt);
            }
        });

        WordSizeMenu.add(SixtyFourBitRadioItem);

        DataRepMenuBar.add(WordSizeMenu);

        FontMenu.setText("Font");
        SmallRadioItem.setText("Small Font");
        SmallRadioItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                SmallRadioItemActionPerformed(evt);
            }
        });

        FontMenu.add(SmallRadioItem);

        MediumRadioItem.setText("Medium Font");
        MediumRadioItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                MediumRadioItemActionPerformed(evt);
            }
        });

        FontMenu.add(MediumRadioItem);

        LargeRadioItem.setText("Large Font");
        LargeRadioItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                LargeRadioItemActionPerformed(evt);
            }
        });

        FontMenu.add(LargeRadioItem);

        ChoiceRadioItem.setText("Choose Font");
        ChoiceRadioItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                ChoiceRadioItemActionPerformed(evt);
            }
        });

        FontMenu.add(ChoiceRadioItem);

        DataRepMenuBar.add(FontMenu);

        HelpMenu.setText("Help");
        AboutItem.setText("About ...");
        AboutItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                AboutItemActionPerformed(evt);
            }
        });

        HelpMenu.add(AboutItem);

        DataRepMenuBar.add(HelpMenu);

        setJMenuBar(DataRepMenuBar);

        pack();
    }//GEN-END:initComponents

    private void AboutItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_AboutItemActionPerformed
        javax.swing.JOptionPane.showMessageDialog(null,"Lynn Ziegler\nVersion 2, 2004");
    }//GEN-LAST:event_AboutItemActionPerformed

    private void ChoiceRadioItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_ChoiceRadioItemActionPerformed
        setVisible(false);
        try {
            fontSize=Integer.parseInt(javax.swing.JOptionPane.showInputDialog("Please enter a font size betwee 8 and 40"));
        }
        catch(NumberFormatException e) {
            fontSize=wordPanel.getMediumFont();
        }
        if(((wordSize==32) || (wordSize==64)) & (fontSize>32)) fontSize=32;
        else if(fontSize>57) fontSize=57;
        remove(WordPanel);
        WordPanel=createWord(wordSize,wordPanel.getLong(),fontSize,spaceMode,dataType);
        getContentPane().add(WordPanel, java.awt.BorderLayout.CENTER);
        wordPanel=(Word) WordPanel;
        setButtonFonts(fontSize);
        setSize(wordPanel.retrieveWidth(),wordPanel.retrieveHeight());
        setVisible(true);
    }//GEN-LAST:event_ChoiceRadioItemActionPerformed

    private void LargeRadioItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_LargeRadioItemActionPerformed
        setVisible(false);
        remove(WordPanel);
        WordPanel=createWord(wordSize,wordPanel.getLong(),wordPanel.getLargeFont(),spaceMode,dataType);
        getContentPane().add(WordPanel, java.awt.BorderLayout.CENTER);
        wordPanel=(Word) WordPanel;
        setButtonFonts(fontSize);
        setSize(wordPanel.retrieveWidth(),wordPanel.retrieveHeight());
        setVisible(true);
    }//GEN-LAST:event_LargeRadioItemActionPerformed

    private void MediumRadioItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_MediumRadioItemActionPerformed
        setVisible(false);
        remove(WordPanel);
        WordPanel=createWord(wordSize,wordPanel.getLong(),wordPanel.getMediumFont(),spaceMode,dataType);
        getContentPane().add(WordPanel, java.awt.BorderLayout.CENTER);
        wordPanel=(Word) WordPanel;
        setButtonFonts(fontSize);
        setSize(wordPanel.retrieveWidth(),wordPanel.retrieveHeight());
        setVisible(true);
    }//GEN-LAST:event_MediumRadioItemActionPerformed

    private void SmallRadioItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_SmallRadioItemActionPerformed
        setVisible(false);
        remove(WordPanel);
        WordPanel=createWord(wordSize,wordPanel.getLong(),wordPanel.getSmallFont(),spaceMode,dataType);
        getContentPane().add(WordPanel, java.awt.BorderLayout.CENTER);
        wordPanel=(Word) WordPanel;
        setButtonFonts(fontSize);
        setSize(wordPanel.retrieveWidth(),wordPanel.retrieveHeight());
        setVisible(true);
    }//GEN-LAST:event_SmallRadioItemActionPerformed

    private void SixtyFourBitRadioItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_SixtyFourBitRadioItemActionPerformed
        CharacterRadioItem.setEnabled(false);
        UnsignedRadioItem.setEnabled(false);
        if((wordPanel.getDataType()!=Word.CHAR) && (wordPanel.getDataType()!=Word.UNSIGNED)) {
            if(fontSize>32) fontSize=32;
            else if(fontSize<8) fontSize=8;
            wordSize=64;
            rebuild();
        }
        else javax.swing.JOptionPane.showMessageDialog(null,
                        "64 bit words do not support Character or Unsigned data types.");
    }//GEN-LAST:event_SixtyFourBitRadioItemActionPerformed

    private void ThirtyTwoBitRadioItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_ThirtyTwoBitRadioItemActionPerformed
        CharacterRadioItem.setEnabled(false);
        UnsignedRadioItem.setEnabled(true);
        if(wordPanel.getDataType()!=Word.CHAR) {
            wordSize=32;
            if(fontSize>32) fontSize=32;
            else if(fontSize<8) fontSize=8;
            rebuild();
        }
        else javax.swing.JOptionPane.showMessageDialog(null,
                          "32 bit words do not support Character data type.");
    }//GEN-LAST:event_ThirtyTwoBitRadioItemActionPerformed

    private void SixteenBitRadioItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_SixteenBitRadioItemActionPerformed
        CharacterRadioItem.setEnabled(false);
        UnsignedRadioItem.setEnabled(true);
        if(wordPanel.getDataType()!=Word.CHAR) {
            if(fontSize>57) fontSize=57;
            else if(fontSize<8) fontSize=8;
            wordSize=16;
            rebuild();
        }
        else javax.swing.JOptionPane.showMessageDialog(null,
                          "16 bit words do not support Unicode character type yet.");
    }//GEN-LAST:event_SixteenBitRadioItemActionPerformed

    private void EightBitRadioItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_EightBitRadioItemActionPerformed
        CharacterRadioItem.setEnabled(true);
        UnsignedRadioItem.setEnabled(true);
        if(fontSize>57) fontSize=57;
        else if(fontSize<8) fontSize=8;
        wordSize=8;
        rebuild();
    }//GEN-LAST:event_EightBitRadioItemActionPerformed

    private void RealRadioItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_RealRadioItemActionPerformed
        dataType=wordPanel.REAL;
        DatatypeLabel.setText("Real");
        rebuild();
    }//GEN-LAST:event_RealRadioItemActionPerformed

    private void CharacterRadioItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_CharacterRadioItemActionPerformed
        dataType=wordPanel.CHAR;
        DatatypeLabel.setText("Character");
        rebuild();
    }//GEN-LAST:event_CharacterRadioItemActionPerformed

    private void OctalRadioItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_OctalRadioItemActionPerformed
        dataType=wordPanel.OCTAL;
        DatatypeLabel.setText("Octal");
        rebuild();
    }//GEN-LAST:event_OctalRadioItemActionPerformed

    private void HexRadioItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_HexRadioItemActionPerformed
        dataType=wordPanel.HEX;
        DatatypeLabel.setText("Hexadecimal");
        rebuild();
    }//GEN-LAST:event_HexRadioItemActionPerformed

    private void UnsignedRadioItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_UnsignedRadioItemActionPerformed
        dataType=wordPanel.UNSIGNED;
        DatatypeLabel.setText("Unsigned");
        rebuild();
    }//GEN-LAST:event_UnsignedRadioItemActionPerformed

    private void SignedRadioItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_SignedRadioItemActionPerformed
        dataType=wordPanel.SIGNED;
        DatatypeLabel.setText("Signed");
        rebuild();
    }//GEN-LAST:event_SignedRadioItemActionPerformed

    private void StudentRadioItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_StudentRadioItemActionPerformed
        spaceMode=false;
        rebuild();
    }//GEN-LAST:event_StudentRadioItemActionPerformed

    private void FacultyRadioItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_FacultyRadioItemActionPerformed
        spaceMode=true;
        rebuild();
    }//GEN-LAST:event_FacultyRadioItemActionPerformed
        
    /**
     * Resets font size for buttons and menus when it is changed by the user.
     */
    private void setButtonFonts(int fSize) {
        fontSize=fSize;
        DatatypeLabel.setFont(new java.awt.Font("Dialog",0, fontSize));
        BlankLabel.setFont(new java.awt.Font("Dialog",0, fontSize));
        ClearButton.setFont(new java.awt.Font("Dialog",0, fontSize));
        Complement.setFont(new java.awt.Font("Dialog",0, fontSize));
        Decrement.setFont(new java.awt.Font("Dialog",0, fontSize));
        Double.setFont(new java.awt.Font("Dialog",0, fontSize));
        Halve.setFont(new java.awt.Font("Dialog",0, fontSize));
        Increment.setFont(new java.awt.Font("Dialog",0, fontSize));
        DataTypeMenu.setFont(new java.awt.Font("Dialog",0,fontSize));
        FontMenu.setFont(new java.awt.Font("Dialog",0,fontSize));
        ModeMenu.setFont(new java.awt.Font("Dialog",0,fontSize));
        WordSizeMenu.setFont(new java.awt.Font("Dialog",0,fontSize));
        HelpMenu.setFont(new java.awt.Font("Dialog", 0, fontSize));
    }
    
    /**
     * Sets the value of the display to 0 when the Clear button is pressed.
     */
    private void ClearButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_ClearButtonActionPerformed
        wordPanel.setBits(0L);
    }//GEN-LAST:event_ClearButtonActionPerformed
    
    /**
     * When the user wishes to specify the font instead of using one of the
     * defaults, this method pops up a window where the user can enter a
     * font size of choice.
     */    
    /**
     * Gets the size of the "large" font from the current word and builds the appropriate
     * layout at that font size.
     */    
    private Word createWord(int wSize, long cValue, int fSize, boolean sMode, int dType) {
        wordSize=wSize;
        currentValue=cValue;
        fontSize=fSize;
        spaceMode=sMode;
        dataType=dType;
        switch(wordSize) {
            case 8:
                return(new Word8(currentValue,fontSize,spaceMode,dataType));
            case 16:
                return(new Word16(currentValue,fontSize,spaceMode,dataType));
            case 64:
                return(new Word64(currentValue,fontSize,spaceMode,dataType));
            default:
                return(new Word32(currentValue,fontSize,spaceMode,dataType));
        }
    }
    
     /**
     * Gets the size of the "large" font from the current word and builds the appropriate
     * layout at that font size.
     */                        
    private void rebuild() {
        setVisible(false);
        remove(WordPanel);
        if(dataType==Word.REAL) doubleValue=wordPanel.computeDouble();
        WordPanel=createWord(wordSize,wordPanel.getLong(),fontSize,spaceMode,dataType);
        getContentPane().add(WordPanel, java.awt.BorderLayout.CENTER);
        wordPanel=(Word) WordPanel;
        if(dataType==Word.REAL) wordPanel.setDoubleBits(doubleValue);
        setButtonFonts(fontSize);
        setSize(wordPanel.retrieveWidth(),wordPanel.retrieveHeight());
        setVisible(true);
    }
                            
    private void ComplementActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_ComplementActionPerformed
        wordPanel.setBits(wordPanel.getLong() ^ -1L);
    }//GEN-LAST:event_ComplementActionPerformed
    
    private void PrintItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_PrintItemActionPerformed
        try {
            PrintUtilities.printComponent(this);
        }
        catch(Exception e) {
            System.out.println("Exception "+e+" when trying to print.");
        }
    }//GEN-LAST:event_PrintItemActionPerformed
    
    private void QuitItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_QuitItemActionPerformed
        System.exit(0);
    }//GEN-LAST:event_QuitItemActionPerformed
        
    private void DecrementActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_DecrementActionPerformed
        if(wordPanel.getDataType()==Word.REAL){
            wordPanel.setDoubleBits(wordPanel.getDouble()-1.0);
        }
        else {
            wordPanel.setBits(wordPanel.getLong()-1);
        }
    }//GEN-LAST:event_DecrementActionPerformed
    
    private void IncrementActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_IncrementActionPerformed
        if(wordPanel.getDataType()==Word.REAL){
            wordPanel.setDoubleBits(wordPanel.getDouble()+1.0);
        }
        else {
            wordPanel.setBits(wordPanel.getLong()+1);
        }
    }//GEN-LAST:event_IncrementActionPerformed
    
    private void HalveActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_HalveActionPerformed
        if(wordPanel.getDataType()==Word.REAL){
            wordPanel.setDoubleBits(wordPanel.getDouble()/2.0);
        }
        else {
            wordPanel.setBits(wordPanel.getLong()/2);
        }
        // Add your handling code here:
    }//GEN-LAST:event_HalveActionPerformed
    
    private void DoubleActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_DoubleActionPerformed
        if(wordPanel.getDataType()==Word.REAL){
            wordPanel.setDoubleBits(wordPanel.getDouble()*2.0);
        }
        else {
            wordPanel.setBits(wordPanel.getLong()*2);
        }
        // Add your handling code here:
    }//GEN-LAST:event_DoubleActionPerformed
    
    /** Exit the Application */
    private void exitForm(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_exitForm
        System.exit(0);
    }//GEN-LAST:event_exitForm
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        DataRep D=new DataRep();
        D.show();
    }

    int fontSize=16;
    boolean spaceMode=false;
    int wordSize=32;
    int dataType=Word.SIGNED;
    long currentValue=0;
    Word wordPanel;
    double doubleValue;
    javax.swing.ButtonGroup modeGroup;
    javax.swing.ButtonGroup datatypeGroup;
    javax.swing.ButtonGroup wordSizeGroup;
    javax.swing.ButtonGroup fontSizeGroup;
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JMenuItem AboutItem;
    private javax.swing.JLabel BlankLabel;
    private javax.swing.JPanel ButtonPanel;
    private javax.swing.JRadioButtonMenuItem CharacterRadioItem;
    private javax.swing.JRadioButtonMenuItem ChoiceRadioItem;
    private javax.swing.JButton ClearButton;
    private javax.swing.JButton Complement;
    private javax.swing.JMenuBar DataRepMenuBar;
    private javax.swing.JMenu DataTypeMenu;
    private javax.swing.JLabel DatatypeLabel;
    private javax.swing.JButton Decrement;
    private javax.swing.JButton Double;
    private javax.swing.JRadioButtonMenuItem EightBitRadioItem;
    private javax.swing.JRadioButtonMenuItem FacultyRadioItem;
    private javax.swing.JMenu FontMenu;
    private javax.swing.JButton Halve;
    private javax.swing.JMenu HelpMenu;
    private javax.swing.JRadioButtonMenuItem HexRadioItem;
    private javax.swing.JButton Increment;
    private javax.swing.JRadioButtonMenuItem LargeRadioItem;
    private javax.swing.JRadioButtonMenuItem MediumRadioItem;
    private javax.swing.JMenu ModeMenu;
    private javax.swing.JRadioButtonMenuItem OctalRadioItem;
    private javax.swing.JMenuItem PrintItem;
    private javax.swing.JMenuItem QuitItem;
    private javax.swing.JRadioButtonMenuItem RealRadioItem;
    private javax.swing.JRadioButtonMenuItem SignedRadioItem;
    private javax.swing.JRadioButtonMenuItem SixteenBitRadioItem;
    private javax.swing.JRadioButtonMenuItem SixtyFourBitRadioItem;
    private javax.swing.JRadioButtonMenuItem SmallRadioItem;
    private javax.swing.JRadioButtonMenuItem StudentRadioItem;
    private javax.swing.JRadioButtonMenuItem ThirtyTwoBitRadioItem;
    private javax.swing.JRadioButtonMenuItem UnsignedRadioItem;
    private javax.swing.JPanel WordPanel;
    private javax.swing.JMenu WordSizeMenu;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JSeparator jSeparator1;
    // End of variables declaration//GEN-END:variables
    
}
