/*
 * Word16.java
 *
 * Created on February 23, 2004, 1:35 PM
 */
package DataRep;
/**
 *
 * @author  lziegler
 */
public class Word16 extends Word {
    
    /** Creates a new instance of Word16 */
    public Word16(long value, int fontSize, boolean spaceMode, int dataType) {
        super(value,fontSize,spaceMode,dataType);
    }
    
    public double computeDouble() {
        if(!powerComputed) {
            power=new double[63];
            power[62]=2147483648.0;
            for(int i=61;i>=0;i--) power[i]=power[i+1]/2.0;
        }
        double sign=1.0;
        int shortValue=(int)(wordValue & 0x0FFFFL);
        if(shortValue==0) return(0.0);
        else {
            if((shortValue & 0x08000)!=0) sign=-1.0;
            shortValue=shortValue & 0x07FFF;
            double mantissa=((double) (shortValue & 511))/512.0;
            int temp=(shortValue>>9) & 63;
            if(temp==63) {
                if(mantissa==0.0) {
                    if(sign<0) return(Double.NEGATIVE_INFINITY);
                    else return(Double.POSITIVE_INFINITY);
                }
                else return(Double.NaN);
            }
            else if(temp>0) {
                return(sign*(1.0+mantissa)*power[temp]);
            }
            else {
                return(sign*mantissa/1073741824.0);
            }
        }
    }
    
    public void display() {
        switch(dataType) {
            case SIGNED:
                short temp=(short)(wordValue & 0x0FFFFL);;
                wordValue=temp;
                valueField.setText(""+wordValue); break;
            case UNSIGNED:
                valueField.setText(""+(wordValue & 0x0FFFFL)); break;
            case HEX:
                valueField.setText(Long.toString((wordValue & 0x0FFFFL),16)); break;
            case OCTAL:
                valueField.setText(Long.toString((wordValue & 0x0FFFFL),8)); break;
            case REAL:
                valueField.setText(""+((float) computeDouble())); break;
        }
    }
    
    public int getLargeFont() {
        return(40);
    }
    
    public int getMediumFont() {
        return(33);
    }
    
    public int getSmallFont() {
        return(24);
    }
    
    public void setBits(String valueFieldValue) {
        try {
            switch(dataType) {
                case SIGNED: case UNSIGNED:
                    setBits(Long.parseLong(valueFieldValue)); break;
                case HEX:
                    setBits(Long.parseLong(valueFieldValue,16)); break;
                case OCTAL:
                    setBits(Long.parseLong(valueFieldValue,8)); break;
                case REAL:
                    setDoubleBits(Double.parseDouble(valueFieldValue));
            }
        }
        catch (Exception e) {
            display();
        }
    }
    
    public void setDoubleBits(double value) {
        int iTemp=Float.floatToIntBits((float) value);
        int iSign;
        if(iTemp<0) iSign=0x08000; else iSign=0;
        float fTemp=Math.abs((float)value);
        if(fTemp>=4292870144.0) setBits(iSign | 32256);
        else if(fTemp>=4290772992.0) setBits(iSign | 32255);
        else if(fTemp<0.0000000000009094947) setBits(0);
        else if(fTemp<0.0000000000018189894) setBits(1);
        else if(fTemp<0.000000000931322574615478515625) {
            setBits(iSign | (int) (fTemp*549755813888.0+0.5));
        }
        else if(fTemp<1.9990234375) {
            int cTemp=(iTemp >> 23) & 0x1F;
            iTemp=(iTemp>>13) & 0x3FF;
            if((iTemp & 1)==0) iTemp=iTemp>>1;
            else {
                iTemp=(iTemp+1)>>1;
                if(iTemp>0x1FF) {
                    cTemp=cTemp+1;
                    iTemp=iTemp>>1;
                }
            }
            setBits(iSign | (cTemp << 9) | iTemp);
        }
        else if(fTemp<=2.0) setBits(iSign | 0x4000);
        else {
            int cTemp=((iTemp >> 23) & 0x1F) | 0x20;
            iTemp=(iTemp>>13) & 0x3FF;
            if((iTemp & 1)==0) iTemp=iTemp>>1;
            else {
                iTemp=(iTemp+1)>>1;
                if(iTemp>511) {
                    cTemp=cTemp+1;
                    iTemp=iTemp & 0x1FF;
                }
            }
            setBits(iSign | (cTemp << 9) | iTemp);
        }
    }
    
    public void setSpacing() {
        if(!spaceMode || dataType==SIGNED || dataType==UNSIGNED) {
            int [] temp={7,15,19};
            bitSpacing=temp;
        }
        else {
            switch(dataType) {
                case OCTAL:
                    int [] temp8={0,3,6,9,12,15,18};
                    bitSpacing=temp8; break;
                case HEX:
                    int [] temp16={3,7,11,15,18};
                    bitSpacing=temp16; break;
                case REAL:
                    int [] tempR={0,6,15,18};
                    bitSpacing=tempR; break;
            }
        }
    }
    
    public int wordLength() {
        return(16);
    }
    
    public int retrieveWidth() {
        return(25*fontSize+175);
    }
    
    public int retrieveHeight() {
        return(5*fontSize+130);
    }
    
    private boolean powerComputed=false;
    private double [] power;
}
