/*
 * Word32.java
 *
 * Created on February 18, 2004, 2:00 PM
 */
package DataRep;
/**
 *
 * @author  lziegler
 */
public class Word32 extends Word {
    
    /** Creates a new instance of Word32 */
    public Word32(long value, int fontSize, boolean spaceMode, int dataType) {
        super(value,fontSize,spaceMode,dataType);
    }
    
    /** computeDouble returns the double value represented by the bits of
     * the Word.
     */
    public double computeDouble() {
        int temp=(int) (wordValue & 0x0FFFFFFFF);
        return((double)(Float.intBitsToFloat(temp)));
    }
    
    /** display() changes the text field to properly display the information
     * stored in the word.
     */
    public void display() {
        long temp2;
        switch(dataType) {
            case SIGNED:
                int temp=(int) wordValue;
                wordValue=temp;
                valueField.setText(""+temp); break;
            case UNSIGNED:
                temp2=wordValue & 0x0FFFFFFFFL;
                valueField.setText(""+temp2); break;
            case HEX:
                temp2=wordValue & 0x0FFFFFFFFL;
                valueField.setText(Long.toString(temp2,16)); break;
            case OCTAL:
                temp2=wordValue & 0x0FFFFFFFFL;
                valueField.setText(Long.toString(temp2,8)); break;
            case REAL:
                double doubleValue=computeDouble();
                float f=(float) doubleValue;
                valueField.setText(""+f); break;
        }
    }
    
    /** setBits(value) sets the Word value and its bits to the specified
     * double value and adjusts the display.
     */
    public void setDoubleBits(double value) {
        float temp=(float) value;
        setBits((long)(Float.floatToIntBits(temp)));
    }
    
    /** setBits(value) sets the Word value and its bits to the specified
     * String valueFieldValue according to the type being represented and
     * then adjusts the display.
     */
    public void setBits(String valueFieldValue) {
        try {
            switch(dataType) {
                case SIGNED: case UNSIGNED:
                    setBits(Long.parseLong(valueFieldValue)); break;
                case HEX:
                    setBits(Long.parseLong(valueFieldValue,16)); break;
                case OCTAL:
                    setBits(Long.parseLong(valueFieldValue,8)); break;
                case REAL:
                    setDoubleBits(Double.parseDouble(valueFieldValue));
            }
        }
        catch (Exception e) {
            display();
        }
    }
    
    /** setSpacing() creates the array bitSpacing which is used to insert
     * spaces in the Bit display in the right spots. The spacing depends
     * on the values of wordSize, dataType, and spaceMode.
     */
    public void setSpacing() {
        if(!spaceMode || dataType==UNSIGNED || dataType==SIGNED) {
            int [] temp={7,15,23,31,35};
            bitSpacing=temp;
        }
        else {
            switch(dataType) {
                case OCTAL:
                    int [] temp={1,4,7,10,13,16,19,22,25,28,31,34};
                    bitSpacing=temp; break;
                case HEX:
                    int [] temp3={3,7,11,15,19,23,27,31,35};
                    bitSpacing=temp3; break;
                case REAL:
                    int [] temp2={0,8,31,35};
                    bitSpacing=temp2; break;
            }
        }
    }
    
    /** wordLength() returns the length of this Word.
     */
    public int wordLength() {
        return(32);
    }
    
    public int getLargeFont() {
        return(20);
    }
    
    public int getMediumFont() {
        return(16);
    }
    
    public int getSmallFont() {
        return(8);
    }
    
    public int retrieveWidth() {
        return(34*fontSize+475);
    }
    
    public int retrieveHeight() {
        return(5*fontSize+130);
    }
    
}
