/*
 * Word64.java
 *
 * Created on February 22, 2004, 4:11 PM
 */
package DataRep;
/**
 *
 * @author  lziegler
 */
public class Word64 extends Word {
    
    /** Creates a new instance of Word64 */
    public Word64(long value, int fontSize, boolean spaceMode, int dataType) {
        super(value,fontSize,spaceMode,dataType);
    }
    
    public double computeDouble() {
        return(Double.longBitsToDouble(wordValue));
    }
    
    public void display() {
        switch(dataType) {
            case SIGNED:
                valueField.setText(""+wordValue); break;
            case HEX:
                valueField.setText(Long.toString(wordValue,16)); break;
            case OCTAL:
                valueField.setText(Long.toString(wordValue,8)); break;
            case REAL:
                double doubleValue=computeDouble();
                valueField.setText(""+doubleValue); break;
        }
        
    }
    
    public int getLargeFont() {
        return(20);
    }
    
    public int getMediumFont() {
        return(16);
    }
    
    public int getSmallFont() {
        return(8);
    }
        
    public void setBits(String valueFieldValue) {
        try {
            switch(dataType) {
                case SIGNED: case UNSIGNED:
                    setBits(Long.parseLong(valueFieldValue)); break;
                case HEX:
                    setBits(Long.parseLong(valueFieldValue,16)); break;
                case OCTAL:
                    setBits(Long.parseLong(valueFieldValue,8)); break;
                case REAL:
                    setDoubleBits(Double.parseDouble(valueFieldValue));
            }
        }
        catch (Exception e) {
            display();
        }
    }
    
    public void setDoubleBits(double value) {
        setBits(Double.doubleToLongBits(value));
    }
    
    public void setSpacing() {
        if(!spaceMode || dataType==SIGNED) {
            int [] temp={7,15,23,31,39,47,55,63,67};
            bitSpacing=temp;
        }
        else {
            switch(dataType) {
                case OCTAL:
                    int [] temp={0,3,6,9,12,15,18,21,24,27,30,33,36,39,42,45,48,51,54,57,60,63,66};
                    bitSpacing=temp; break;
                case HEX:
                    int [] temp3={3,7,11,15,19,23,27,31,35,39,43,47,51,55,59,63,67};
                    bitSpacing=temp3; break;
                case REAL:
                    int [] temp2={0,11,39,63,67};
                    bitSpacing=temp2; break;
            }
        }
    }
    
    public int wordLength() {
        return(64);
    }
    
    public int retrieveWidth() {
        return(34*fontSize+475);
    }
    
    public int retrieveHeight() {
        return(6*fontSize+150);
    }
    
}
