/*
 * Word8.java
 *
 * Created on February 23, 2004, 7:59 PM
 */
package DataRep;
/**
 *
 * @author  lziegler
 */
public class Word8 extends Word {
    
    /** Creates a new instance of Word8 */
    public Word8(long value, int fontSize, boolean spaceMode, int dataType) {
        super(value,fontSize,spaceMode,dataType);
    }
    
    public double computeDouble() {
        if(!powerComputed) {
            power=new double[15];
            power[14]=128.0;
            for(int i=13;i>=0;i--) power[i]=power[i+1]/2.0;
        }
        double sign=1.0;
        double mantissa;
        int temp=(int) (wordValue & 0x0FFL);
        if(temp==0) return(0.0);
        else if(temp==128) return(-0.0);
        else {
            if((temp & 128)!=0) sign=-1.0;
            mantissa=((temp & 7)/8.0);
            int eTemp=(temp>>3) & 15;
            if(eTemp==15) {
                if(mantissa==0.0) {
                    if(sign<0) return(Double.NEGATIVE_INFINITY);
                    else return(Double.POSITIVE_INFINITY);
                }
                else return(Double.NaN);
            }
            else if(eTemp!=0) {
                return(sign*(1.0+mantissa)*power[eTemp]);
            }
            else {
                return(sign*mantissa/64.0);
            }
        }
    }
    
    public void display() {
        switch(dataType) {
            case SIGNED:
                byte temp=(byte)(wordValue & 0x0FFL);;
                wordValue=temp;
                valueField.setText(""+wordValue); break;
            case UNSIGNED:
                valueField.setText(""+(wordValue & 0x0FFL)); break;
            case HEX:
                valueField.setText(Long.toString((wordValue & 0x0FFL),16)); break;
            case OCTAL:
                valueField.setText(Long.toString((wordValue & 0x0FFL),8)); break;
            case REAL:
                valueField.setText(""+((float) computeDouble())); break;
            case CHAR:
                valueField.setText(""+((char)(wordValue & 0x0FFL))); break;
        }
    }
    
    public int getLargeFont() {
        return(40);
    }
    
    public int getMediumFont() {
        return(33);
    }
    
    public int getSmallFont() {
        return(24);
    }
    
    public int retrieveHeight() {
        return(5*fontSize+130);
    }
    
    public int retrieveWidth() {
        return(25*fontSize+175);
    }
    
    public void setBits(String valueFieldValue) {
        try {
            long temp;
            switch(dataType) {
                case SIGNED: case UNSIGNED:
                    byte temp2=(byte)(Long.parseLong(valueFieldValue) & 0xFFL);
                    wordValue=temp2;
                    setBits(wordValue); break;
                case HEX:
                    System.out.println(valueFieldValue);
                    temp=Long.parseLong(valueFieldValue,16) & 0xFFL;
                    setBits(temp); break;
                case OCTAL:
                    temp=Long.parseLong(valueFieldValue,8) & 0xFFL;
                    setBits(temp); break;
                case REAL:
                    if(valueFieldValue.equals("-0.0")) setBits(0x80L); 
                    else setDoubleBits(Double.parseDouble(valueFieldValue)); break;
                case CHAR:
                    if((valueFieldValue.length()>1) && (valueFieldValue.charAt(0)=='\\')) {
                        setBits(Long.parseLong(valueFieldValue.substring(1),8));
                    }
                    else if(valueFieldValue.length()>0) setBits((long)(valueFieldValue.charAt(0)));
            }
        }
        catch(Exception e) {
            display();
        }
    }
    
    public void setDoubleBits(double value) {
        int sign=0;
        int temp = (int)(wordValue & 0x0FFL);
        if(value<0) sign=128;
        value=Math.abs(value);
        if(value>248.0) setBits(120 | sign);
        else if(value>240.0) setBits(119 | sign);
        else if(value<0.0009765625) setBits(0);
        else if(value<0.001953125) setBits(1 | sign);
        else if(value<0.015625) setBits(sign | ((int)(value*512.0+0.5)));
        else if((value>=1.9375) && (value<=2.0)) setBits(sign | 64);
        else {
            int iTemp=Float.floatToIntBits((float) value);
            if(((iTemp & 0x7F800000)==0x7F800000) && ((iTemp & 0x7FFFFF) !=0)) setBits(0x7FL);
            else {
                int cTemp=(iTemp>>23) & 7;
                
                iTemp=(iTemp>>19) & 15;
                if((iTemp & 1)==0) iTemp=iTemp>>1;
                else {
                    iTemp=(iTemp+1)>>1;
                    if(iTemp>7) {
                        cTemp++;
                        iTemp=0;
                    }
                }
                if(value<2.0) setBits(sign | (cTemp<<3) | iTemp);
                else setBits(sign | ((cTemp | 8)<<3) | iTemp);
            }
        }
    }
    
    public void setSpacing() {
        if(!spaceMode || dataType==SIGNED || dataType==UNSIGNED) {
            int [] temp={7,11};
            bitSpacing=temp;
        }
        else {
            switch(dataType) {
                case OCTAL:
                    int [] temp8={1,4,7,10};
                    bitSpacing=temp8; break;
                case HEX:
                    int [] temp16={3,7,11};
                    bitSpacing=temp16; break;
                case REAL:
                    int [] tempR={0,4,7,15};
                    bitSpacing=tempR; break;
            }
        }
    }
    
    public int wordLength() {
        return(8);
    }
    private boolean powerComputed=false;
    private double [] power;
    
}
