/*
 * Decompiled with CFR 0.152.
 */
package edu.csbsju.socs.hymn;

import edu.csbsju.socs.hymn.Cpu;
import edu.csbsju.socs.hymn.EventLog;
import edu.csbsju.socs.hymn.Strings;
import edu.csbsju.socs.util.LocaleManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.TreeSet;

class Assembler {
    private static HashMap op_codes = null;

    static {
        MyListener l = new MyListener();
        LocaleManager.addListener(l);
        l.localeChanged();
    }

    Assembler() {
    }

    public static String disassemble(int value) {
        String arg = Integer.toBinaryString(value & 0x1F);
        switch (value >> 5 & 7) {
            case 0: {
                return Strings.get("haltOp");
            }
            case 1: {
                return String.valueOf(Strings.get("jumpOp")) + " " + arg;
            }
            case 2: {
                return String.valueOf(Strings.get("jzerOp")) + " " + arg;
            }
            case 3: {
                return String.valueOf(Strings.get("jposOp")) + " " + arg;
            }
            case 4: {
                return String.valueOf(Strings.get("loadOp")) + " " + arg;
            }
            case 5: {
                return String.valueOf(Strings.get("storOp")) + " " + arg;
            }
            case 6: {
                return String.valueOf(Strings.get("addOp")) + " " + arg;
            }
            case 7: {
                return String.valueOf(Strings.get("subOp")) + " " + arg;
            }
        }
        return "???";
    }

    public static int assemble(String line, int radix) throws Error {
        return Assembler.assemble(line, radix, null);
    }

    public static int assemble(String line, int radix, HashMap map) throws Error {
        Integer ret;
        StringTokenizer toks = new StringTokenizer(line);
        if (!toks.hasMoreTokens()) {
            throw new Error(Strings.get("emptyInstrError"));
        }
        String first = toks.nextToken();
        String op = first.toUpperCase();
        OpCode handler = (OpCode)op_codes.get(op);
        if (handler != null) {
            return handler.handle(op, toks, radix, map);
        }
        if (Character.isDigit(op.charAt(0)) || op.charAt(0) == '-') {
            if (toks.hasMoreTokens()) {
                throw new Error(Strings.get("numericArgError"));
            }
            try {
                int ret2 = Integer.parseInt(op, op.charAt(0) == '0' ? 2 : radix);
                if (ret2 < -128 || ret2 > 127) {
                    throw new Error(Strings.get("badNumericError"));
                }
                return ret2;
            }
            catch (NumberFormatException ret2) {
                // empty catch block
            }
        }
        if (map != null && (ret = (Integer)map.get(first)) != null) {
            if (toks.hasMoreTokens()) {
                throw new Error(Strings.get("labelRefArgError"));
            }
            return ret;
        }
        throw new Error(String.valueOf(Strings.get("badInstructionError")) + ": " + op);
    }

    public static Error[] assemble(Reader raw_reader, Cpu cpu) {
        TreeSet<Error> errors = new TreeSet<Error>();
        LinkedList<String> instructions = new LinkedList<String>();
        HashMap<String, Integer> sym_map = new HashMap<String, Integer>();
        BufferedReader reader = new BufferedReader(raw_reader);
        int line_num = 0;
        int doc_offset = 0;
        int next_doc_offset = 0;
        int addr = 0;
        int needed = -1;
        while (true) {
            int pos;
            String line;
            ++line_num;
            doc_offset = next_doc_offset;
            try {
                line = reader.readLine();
            }
            catch (IOException e) {
                errors.add(new Error(doc_offset, line_num, String.valueOf(Strings.get("assembleIoError")) + ": " + e));
                break;
            }
            if (line == null) break;
            next_doc_offset = doc_offset + line.length() + 1;
            int comment = line.indexOf(35);
            if (comment >= 0) {
                line = line.substring(0, comment);
            }
            while ((pos = line.indexOf(58)) >= 0) {
                String label = line.substring(0, pos).trim();
                line = line.substring(pos + 1);
                if (label.indexOf(32) >= 0 || label.indexOf(9) >= 0) {
                    errors.add(new Error(doc_offset, line_num, Strings.get("whiteSpaceLabelError")));
                } else if (label.equals("")) {
                    errors.add(new Error(doc_offset, line_num, Strings.get("emptyLabelError")));
                } else if (op_codes.get(label) != null) {
                    errors.add(new Error(doc_offset, line_num, Strings.get("opLabelError")));
                } else if (sym_map.get(label) != null) {
                    errors.add(new Error(doc_offset, line_num, String.valueOf(Strings.get("dupLabelError")) + ": " + label));
                } else {
                    try {
                        Integer.parseInt(label);
                        errors.add(new Error(doc_offset, line_num, Strings.get("numericLabelError")));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                sym_map.put(label, new Integer(addr));
                needed = line_num;
            }
            if (addr > 29) {
                errors.add(new Error(doc_offset, line_num, Strings.get("programTooLargeError")));
                needed = -1;
                break;
            }
            if ((line = line.trim()).equals("")) continue;
            needed = -1;
            instructions.add(String.valueOf(doc_offset) + "\t" + line_num + "\t" + line);
            ++addr;
        }
        if (needed > 0) {
            errors.add(new Error(doc_offset, needed, Strings.get("labelAtEndError")));
        }
        int[] data = new int[32];
        addr = -1;
        Iterator it = instructions.iterator();
        while (it.hasNext()) {
            String instr = (String)it.next();
            ++addr;
            int offs_pos = instr.indexOf(9);
            doc_offset = Integer.parseInt(instr.substring(0, offs_pos));
            int num_pos = instr.indexOf(9, offs_pos + 1);
            line_num = Integer.parseInt(instr.substring(offs_pos + 1, num_pos));
            instr = instr.substring(num_pos + 1);
            try {
                data[addr] = Assembler.assemble(instr, 10, sym_map);
            }
            catch (Error e) {
                errors.add(new Error(doc_offset, line_num, e.getMessage()));
            }
        }
        if (errors.size() > 0) {
            Error[] ret = new Error[errors.size()];
            errors.toArray(ret);
            return ret;
        }
        EventLog.Cause cause = new EventLog.Cause();
        int i = 0;
        while (i < data.length) {
            cpu.getMem(i).setValue(data[i], cause);
            ++i;
        }
        cpu.resetRegisters();
        return null;
    }

    public static class Error
    extends Exception
    implements Comparable {
        private int line_num = -1;
        private int document_offset = -1;

        public Error(String msg) {
            super(msg);
        }

        public Error(int doc_offset, int line_num, String msg) {
            super(msg);
            this.line_num = line_num;
        }

        public int getLineNumber() {
            return this.line_num;
        }

        public int getDocumentOffset() {
            return this.document_offset;
        }

        public boolean equals(Object base) {
            if (!(base instanceof Error)) {
                return false;
            }
            Error other = (Error)base;
            return this.line_num == other.line_num && this.getMessage().equals(other.getMessage());
        }

        public int compareTo(Object base) {
            if (!(base instanceof Error)) {
                return 1;
            }
            if (this == base) {
                return 0;
            }
            Error other = (Error)base;
            if (this.line_num != other.line_num) {
                return this.line_num - other.line_num;
            }
            if (!this.getMessage().equals(other.getMessage())) {
                return this.getMessage().compareTo(other.getMessage());
            }
            return 0;
        }
    }

    private static abstract class OpCode {
        OpCode() {
        }

        abstract int handle(String var1, StringTokenizer var2, int var3, HashMap var4) throws Error;
    }

    private static class OpCode0
    extends OpCode {
        int value;

        OpCode0(int value) {
            this.value = value;
        }

        int handle(String op, StringTokenizer toks, int radix, HashMap map) throws Error {
            if (toks.hasMoreTokens()) {
                throw new Error(String.valueOf(Strings.get("moreThanZeroArgsError")) + ": " + op);
            }
            return this.value;
        }
    }

    private static class OpCode1
    extends OpCode {
        int value;

        OpCode1(int value) {
            this.value = value;
        }

        int handle(String op, StringTokenizer toks, int radix, HashMap map) throws Error {
            Integer argo;
            if (!toks.hasMoreTokens()) {
                throw new Error(Strings.get("lessThanOneArgError: " + op));
            }
            String args = toks.nextToken();
            int arg = 0;
            boolean arg_known = false;
            try {
                if (args.charAt(0) == '0') {
                    arg = Integer.parseInt(args, 2);
                    arg_known = true;
                } else {
                    arg = Integer.parseInt(args, radix);
                    arg_known = true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (!arg_known && map != null && (argo = (Integer)map.get(args)) != null) {
                arg = argo;
                arg_known = true;
            }
            if (!arg_known) {
                throw new Error(String.valueOf(Strings.get("badArgError")) + ": " + args);
            }
            if (arg < 0 || arg >= 32) {
                throw new Error(String.valueOf(Strings.get("argOutOfRangeError")) + ": " + args);
            }
            if (toks.hasMoreTokens()) {
                throw new Error(String.valueOf(Strings.get("moreThanOneArgError")) + ": " + op);
            }
            return this.value | arg;
        }
    }

    private static class MyListener
    implements LocaleManager.Listener {
        MyListener() {
        }

        public void localeChanged() {
            StringTokenizer lists = new StringTokenizer("haltOps readOps writeOps jumpOps jzerOps jposOps loadOps storOps addOps subOps");
            OpCode[] codes = new OpCode[]{new OpCode0(0), new OpCode0(158), new OpCode0(191), new OpCode1(32), new OpCode1(64), new OpCode1(96), new OpCode1(128), new OpCode1(160), new OpCode1(192), new OpCode1(224)};
            op_codes = new HashMap();
            int i = 0;
            while (lists.hasMoreTokens()) {
                String list = Strings.get(lists.nextToken());
                StringTokenizer ops = new StringTokenizer(list);
                while (ops.hasMoreTokens()) {
                    op_codes.put(ops.nextToken(), codes[i]);
                }
                ++i;
            }
        }
    }
}

