/*
 * Decompiled with CFR 0.152.
 */
package edu.csbsju.socs.hymn;

import edu.csbsju.socs.hymn.Cpu;
import edu.csbsju.socs.hymn.EventLog;
import edu.csbsju.socs.hymn.FlowPanel;
import edu.csbsju.socs.hymn.Strings;
import edu.csbsju.socs.hymn.Tty;
import edu.csbsju.socs.util.GraphicsExt;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;

class ControlPanel
extends FlowPanel {
    private static final Color DISABLED_RED = new Color(128, 0, 0);
    private static final Color DISABLED_GREEN = new Color(0, 128, 0);
    private static final Color DISABLED_BLACK = Color.black;
    private static final Font SUBLINE_FONT = new Font("Dialog", 0, 9);
    private Cpu cpu;
    private RunThread run_thread = new RunThread();
    private JPanel speed_panel = new JPanel();
    private JPanel button_panel = new JPanel(new GridLayout(1, 4, 5, 5));
    private JLabel speed_label = new JLabel();
    private SpeedField speed_field = new SpeedField();
    private SpeedSlider speed_slider = new SpeedSlider();
    private PlayButton play_button = new PlayButton();
    private JButton step_button = new StepButton();
    private UndoButton undo_button = new UndoButton();
    private JButton reset_button = new ResetButton();

    ControlPanel(Cpu cpu) {
        super(1);
        this.cpu = cpu;
        this.speed_panel.add(this.speed_label);
        this.speed_panel.add(this.speed_field);
        this.button_panel.setBorder(BorderFactory.createEmptyBorder(10, 20, 30, 20));
        this.button_panel.add(this.play_button);
        this.button_panel.add(this.step_button);
        this.button_panel.add(this.undo_button);
        this.button_panel.add(this.reset_button);
        cpu.getLog().addListener(this.undo_button);
        this.undo_button.setEnabled(true);
        this.add(this.speed_panel);
        this.add(this.speed_slider);
        this.add(this.button_panel);
    }

    void renewStrings() {
        this.speed_label.setText(Strings.get("cpuSpeedLabel"));
        this.play_button.renewStrings();
        this.step_button.setToolTipText(Strings.get("stepButtonTip"));
        this.undo_button.setToolTipText(Strings.get("backButtonTip"));
        this.reset_button.setToolTipText(Strings.get("resetButtonTip"));
        this.repaint();
    }

    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.speed_panel != null) {
            this.speed_panel.setBackground(bg);
        }
        if (this.speed_slider != null) {
            this.speed_slider.setBackground(bg);
        }
        if (this.button_panel != null) {
            this.button_panel.setBackground(bg);
        }
    }

    private void setRunButton(boolean state) {
        if (state) {
            this.cpu.getTty().cancelInput();
        }
        this.play_button.setState(state);
        this.step_button.setEnabled(state);
        this.step_button.repaint();
        this.undo_button.setEnabled(state);
        this.undo_button.repaint();
    }

    public void setFontSize(float size) {
        this.speed_label.setFont(this.speed_label.getFont().deriveFont(size));
        this.speed_field.setFont(this.speed_field.getFont().deriveFont(size));
    }

    private class RunThread
    implements Runnable {
        protected Thread current = null;
        protected boolean go_indefinitely;
        protected boolean go_forward = true;
        protected int instructions_left = 0;

        RunThread() {
        }

        public synchronized void toggle() {
            this.go_forward = true;
            this.setRun(!this.go_indefinitely);
            this.beginThread();
        }

        public synchronized void halt() {
            this.setRun(false);
            this.beginThread();
        }

        public synchronized void step() {
            this.go_forward = true;
            this.go_indefinitely = false;
            this.instructions_left = 1;
            this.beginThread();
        }

        public synchronized void undo() {
            this.go_forward = false;
            this.go_indefinitely = false;
            this.instructions_left = 1;
            this.beginThread();
        }

        protected void beginThread() {
            if (this.current == null) {
                this.current = new Thread(this);
                this.current.start();
            } else {
                try {
                    this.current.interrupt();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
        }

        protected void setRun(boolean what) {
            this.go_indefinitely = what;
            ControlPanel.this.setRunButton(!this.go_indefinitely);
        }

        public void run() {
            while (this.current != null) {
                try {
                    if (this.go_indefinitely || this.instructions_left > 0) {
                        ControlPanel.this.setRunButton(false);
                        try {
                            if (this.go_forward) {
                                this.executeInstruction();
                            } else {
                                ControlPanel.this.cpu.getLog().undo();
                            }
                        }
                        catch (InterruptedException e) {
                            this.go_indefinitely = false;
                        }
                        if (this.instructions_left > 0) {
                            --this.instructions_left;
                        }
                        if (Cpu.isHaltInstr(ControlPanel.this.cpu.getIR().getValue())) {
                            this.go_indefinitely = false;
                        }
                    }
                    if (!this.go_indefinitely && this.instructions_left == 0) {
                        ControlPanel.this.setRunButton(true);
                    }
                    try {
                        int delay = 30 * (100 - ControlPanel.this.speed_slider.getValue()) + 3;
                        Thread.sleep(delay);
                    }
                    catch (InterruptedException delay) {}
                }
                catch (Throwable e) {
                    JOptionPane.showMessageDialog(null, String.valueOf(Strings.get("cpuError")) + e);
                }
            }
        }

        protected void executeInstruction() throws InterruptedException {
            while (this.go_forward && (this.go_indefinitely || this.instructions_left > 0)) {
                try {
                    ControlPanel.this.cpu.executeStep();
                    return;
                }
                catch (Tty.InputNotReadyException inputNotReadyException) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private class SpeedSlider
    extends JSlider
    implements MouseListener,
    MouseMotionListener {
        SpeedSlider() {
            this.setMaximum(100);
            this.setValue(0);
            this.setMajorTickSpacing(10);
            this.setPaintTicks(true);
            this.addMouseListener(this);
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
            this.mouseDragged(e);
        }

        public void mouseDragged(MouseEvent e) {
            ControlPanel.this.speed_field.setText(Integer.toString(this.getValue()));
        }

        public void mouseMoved(MouseEvent e) {
        }
    }

    private class SpeedField
    extends JTextField
    implements ActionListener {
        public SpeedField() {
            super(3);
            this.setHorizontalAlignment(4);
            this.setText("0");
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent event) {
            try {
                int new_val = Integer.parseInt(this.getText());
                if (new_val >= 0 && new_val <= 100) {
                    ControlPanel.this.speed_slider.setValue(new_val);
                    return;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.setText("" + ControlPanel.this.speed_slider.getValue());
        }
    }

    private abstract class IconButton
    extends JButton
    implements ActionListener,
    Icon {
        public IconButton() {
            this.setIcon(this);
            this.addActionListener(this);
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        }

        public void actionPerformed(ActionEvent e) {
            this.buttonClicked();
        }

        public abstract void buttonClicked();

        public int getIconWidth() {
            return 25;
        }

        public int getIconHeight() {
            return 25;
        }

        public abstract void paintIcon(Component var1, Graphics var2, int var3, int var4);
    }

    private class PlayButton
    extends IconButton {
        private boolean state = false;

        public PlayButton() {
            this.setState(true);
        }

        public void buttonClicked() {
            ControlPanel.this.run_thread.toggle();
        }

        public void setState(boolean value) {
            if (this.state == value) {
                return;
            }
            this.state = value;
            this.renewStrings();
            this.repaint();
        }

        private void renewStrings() {
            if (this.state) {
                this.setToolTipText(Strings.get("runButtonTip"));
            } else {
                this.setToolTipText(Strings.get("stopButtonTip"));
            }
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.state) {
                g.setColor(Color.green);
                int[] xp = new int[]{x + 7, x + 7, x + 17};
                int[] yp = new int[]{y + 1, y + 13, y + 7};
                g.fillPolygon(xp, yp, 3);
                g.setColor(Color.black);
                g.drawPolygon(xp, yp, 3);
                g.setFont(SUBLINE_FONT);
                GraphicsExt.drawText(g, Strings.get("runButton"), x + 12, y + 25, 0, 1);
            } else {
                g.setColor(Color.red);
                g.fillRect(x + 9, y + 3, 8, 8);
                g.setColor(Color.black);
                g.drawRect(x + 9, y + 3, 7, 7);
                g.setFont(SUBLINE_FONT);
                GraphicsExt.drawText(g, Strings.get("stopButton"), x + 12, y + 25, 0, 1);
            }
        }
    }

    private class StepButton
    extends IconButton {
        public void buttonClicked() {
            ControlPanel.this.run_thread.step();
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            int[] xp = new int[]{x + 7, x + 7, x + 15};
            int[] yp = new int[]{y + 1, y + 13, y + 7};
            boolean enabled = this.isEnabled();
            g.setColor(enabled ? Color.green : DISABLED_GREEN);
            g.fillPolygon(xp, yp, 3);
            g.setColor(enabled ? Color.red : DISABLED_RED);
            g.fillRect(x + 16, y, 4, 14);
            g.setColor(enabled ? Color.black : DISABLED_BLACK);
            g.drawRect(x + 16, y, 4, 14);
            g.drawPolygon(xp, yp, 3);
            g.setFont(SUBLINE_FONT);
            GraphicsExt.drawText(g, Strings.get("stepButton"), x + 12, y + 25, 0, 1);
            g.setColor(Color.black);
        }
    }

    private class UndoButton
    extends IconButton
    implements EventLog.Listener {
        private boolean should_enable = true;

        public void buttonClicked() {
            ControlPanel.this.run_thread.undo();
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            int[] xp = new int[]{x + 20, x + 20, x + 11};
            int[] yp = new int[]{y + 1, y + 13, y + 7};
            boolean enabled = this.isEnabled();
            g.setColor(enabled ? Color.green : DISABLED_GREEN);
            g.fillPolygon(xp, yp, 3);
            g.setColor(enabled ? Color.red : DISABLED_RED);
            g.fillRect(x + 7, y + 1, 4, 14);
            g.setColor(enabled ? Color.black : DISABLED_BLACK);
            g.drawRect(x + 7, y + 1, 4, 14);
            g.drawPolygon(xp, yp, 3);
            g.setFont(SUBLINE_FONT);
            GraphicsExt.drawText(g, Strings.get("backButton"), x + 12, y + 25, 0, 1);
            g.setColor(Color.black);
        }

        public void setEnabled(boolean value) {
            this.should_enable = value;
            if (ControlPanel.this.cpu != null) {
                super.setEnabled(!ControlPanel.this.cpu.getLog().isEmpty() && value);
            } else {
                super.setEnabled(value);
            }
        }

        public void eventAdded(EventLog.LogEvent event) {
            super.setEnabled(!event.log.isEmpty() && this.should_enable);
            this.repaint();
        }

        public void eventRemoved(EventLog.LogEvent event) {
            super.setEnabled(!event.log.isEmpty() && this.should_enable);
            this.repaint();
        }
    }

    private class ResetButton
    extends IconButton {
        public void buttonClicked() {
            ControlPanel.this.cpu.resetRegisters();
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(Color.black);
            GraphicsExt.switchToWidth(g, 4);
            int[] xp = new int[]{x + 12, x + 15, x + 12};
            int[] yp = new int[]{y + 11, y + 14, y + 17};
            g.drawArc(x + 6, y + 1, 14, 14, 0, 270);
            g.drawPolyline(xp, yp, 3);
            boolean enabled = this.isEnabled();
            g.setColor(enabled ? Color.red : DISABLED_RED);
            GraphicsExt.switchToWidth(g, 2);
            g.drawArc(x + 6, y + 1, 14, 14, 0, 270);
            g.drawPolyline(xp, yp, 3);
            GraphicsExt.switchToWidth(g, 1);
            g.setColor(Color.black);
            g.setFont(SUBLINE_FONT);
            GraphicsExt.drawText(g, Strings.get("resetButton"), x + 12, y + 25, 0, 1);
        }
    }
}

