/*
 * Decompiled with CFR 0.152.
 */
package edu.csbsju.socs.hymn;

import edu.csbsju.socs.hymn.EventLog;
import edu.csbsju.socs.hymn.Register;
import edu.csbsju.socs.hymn.Strings;
import edu.csbsju.socs.hymn.Tty;

class Cpu {
    public static final int MEM_SIZE = 32;
    public static final int WRITE_ADDR = 31;
    public static final int READ_ADDR = 30;
    public static final int MAX_MEM_ADDR = 29;
    private static final int ADDR_MASK = 31;
    private EventLog log = new EventLog();
    private Register PC = new Register(5, this.log);
    private Register IR = new Register(8, this.log);
    private Register AC = new Register(8, this.log);
    private Register[] mem = new Register[32];
    private Tty tty = null;

    public Cpu() {
        int i = 0;
        while (i < this.mem.length) {
            this.mem[i] = new Register(8, this.log);
            ++i;
        }
    }

    public Register getPC() {
        return this.PC;
    }

    public Register getIR() {
        return this.IR;
    }

    public Register getAC() {
        return this.AC;
    }

    public Register getMem(int index) {
        if (index < 0 || index >= this.mem.length) {
            throw new IllegalArgumentException(String.valueOf(Strings.get("badAddressError")) + ": " + index);
        }
        return this.mem[index];
    }

    public EventLog getLog() {
        return this.log;
    }

    public Tty getTty() {
        return this.tty;
    }

    public void setTty(Tty tty) {
        this.tty = tty;
        tty.setCpu(this);
    }

    public synchronized void resetRegisters() {
        this.log.clear();
        EventLog.Cause cause = new EventLog.Cause();
        this.PC.setValue(0, cause);
        this.IR.setValue(0, cause);
        this.AC.setValue(0, cause);
        this.tty.reset();
    }

    public synchronized void resetMemory() {
        EventLog.Cause cause = new EventLog.Cause();
        int i = 0;
        while (i < this.mem.length) {
            this.mem[i].setValue(0, cause);
            ++i;
        }
    }

    public synchronized void executeStep() throws Tty.InputNotReadyException {
        StepCause cause = new StepCause();
        int pc = this.PC.getValue(cause) & 0x1F;
        int instr = this.getMemValue(pc, cause);
        this.IR.setValue(instr, cause);
        int op = instr >> 5 & 7;
        int arg = instr & 0x1F;
        switch (op) {
            case 0: {
                break;
            }
            case 1: {
                this.PC.setValue(arg, cause);
                break;
            }
            case 2: {
                int ac = this.AC.getValue(cause);
                this.PC.setValue(ac == 0 ? arg : pc + 1, cause);
                break;
            }
            case 3: {
                int ac = this.AC.getValue(cause);
                this.PC.setValue(ac > 0 ? arg : pc + 1, cause);
                break;
            }
            case 4: {
                this.AC.setValue(this.getMemValue(arg, cause), cause);
                this.PC.setValue(pc + 1, cause);
                break;
            }
            case 5: {
                int ac = this.AC.getValue(cause);
                this.setMemValue(arg, ac, cause);
                this.PC.setValue(pc + 1, cause);
                break;
            }
            case 6: {
                int ac = this.AC.getValue(cause);
                this.AC.setValue(ac + this.getMemValue(arg, cause), cause);
                this.PC.setValue(pc + 1, cause);
                break;
            }
            case 7: {
                int ac = this.AC.getValue(cause);
                this.AC.setValue(ac - this.getMemValue(arg, cause), cause);
                this.PC.setValue(pc + 1, cause);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getMemValue(int addr, EventLog.Cause cause) throws Tty.InputNotReadyException {
        if (this.tty == null) return this.mem[addr].getValue(cause);
        if (addr != 30) return this.mem[addr].getValue(cause);
        this.tty.requestInput();
        if (!this.tty.isInputReady()) throw new Tty.InputNotReadyException();
        int ret = this.tty.consumeInput(cause);
        this.mem[30].setValue(ret, cause);
        return ret;
    }

    private void setMemValue(int addr, int value, EventLog.Cause cause) {
        this.mem[addr].setValue(value, cause);
        if (this.tty != null && addr == 31) {
            this.tty.setValue(this.mem[31].getValue(), cause);
        }
    }

    public static boolean isHaltInstr(int instr) {
        return (instr >> 5 & 7) == 0;
    }

    public static class StepCause
    extends EventLog.Cause {
    }
}

