/*
 * Decompiled with CFR 0.152.
 */
package edu.csbsju.socs.hymn;

import edu.csbsju.socs.hymn.Assembler;
import edu.csbsju.socs.hymn.ControlPanel;
import edu.csbsju.socs.hymn.Cpu;
import edu.csbsju.socs.hymn.Editor;
import edu.csbsju.socs.hymn.ErrorWindow;
import edu.csbsju.socs.hymn.EventLog;
import edu.csbsju.socs.hymn.FlowPanel;
import edu.csbsju.socs.hymn.IOArea;
import edu.csbsju.socs.hymn.Keyboard;
import edu.csbsju.socs.hymn.MachineFile;
import edu.csbsju.socs.hymn.Register;
import edu.csbsju.socs.hymn.RegisterPanel;
import edu.csbsju.socs.hymn.Strings;
import edu.csbsju.socs.hymn.Tty;
import edu.csbsju.socs.hymn.TypeSelector;
import edu.csbsju.socs.hymn.WordView;
import edu.csbsju.socs.util.HelpFrame;
import edu.csbsju.socs.util.LocaleManager;
import edu.csbsju.socs.util.PrintUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PrinterException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;

class CpuView
extends JFrame
implements LocaleManager.Listener {
    static final Color BACKGROUND = new Color(204, 255, 204);
    private IOArea io_area = new IOArea();
    private Cpu cpu = new Cpu();
    private int font_size = -1;
    private HashMap view_map = new HashMap();
    private JFileChooser chooser = new JFileChooser(".");
    private Editor editor = new Editor();
    private ErrorWindow errors = new ErrorWindow();
    private HelpFrame help_frame = new HelpFrame();
    private FileMenu file_menu = new FileMenu();
    private MemoryMenu memory_menu = new MemoryMenu();
    private AssemblerMenu assembler_menu = new AssemblerMenu();
    private OptionsMenu options_menu = new OptionsMenu();
    private HelpMenu help_menu = new HelpMenu();
    private ControlPanel control_panel;
    private RegisterPanel register_panel;
    private TtyPanel tty_panel;
    private MemoryPanel[] mem_panel = new MemoryPanel[3];

    public CpuView() {
        this.addWindowListener(new WindowCloser());
        this.cpu.setTty(new Tty(this.io_area, new Keyboard(this.io_area)));
        this.editor.setCpuView(this);
        JMenuBar menubar = new JMenuBar();
        menubar.add(this.file_menu);
        menubar.add(this.memory_menu);
        menubar.add(this.assembler_menu);
        menubar.add(this.options_menu);
        menubar.add(this.help_menu);
        this.setJMenuBar(menubar);
        this.control_panel = new ControlPanel(this.cpu);
        this.control_panel.setBackground(BACKGROUND);
        this.register_panel = new RegisterPanel(this.cpu);
        this.register_panel.setBackground(BACKGROUND);
        this.register_panel.mapViews(this.view_map);
        this.tty_panel = new TtyPanel(this.cpu);
        FlowPanel controls = new FlowPanel(0);
        controls.setAnchor(11);
        controls.setBackground(BACKGROUND);
        controls.addSpring(20, 100.0);
        controls.add(this.control_panel);
        controls.addSpring(20, 100.0);
        controls.add(this.register_panel);
        controls.addSpring(20, 100.0);
        controls.add(this.tty_panel);
        controls.addSpring(20, 100.0);
        FlowPanel memory = new FlowPanel(0);
        memory.setBackground(BACKGROUND);
        int i = 0;
        while (i < 3) {
            MemoryPanel panel = new MemoryPanel(i * 10, (i + 1) * 10);
            panel.mapViews(this.view_map);
            this.mem_panel[i] = panel;
            if (i > 0) {
                this.mem_panel[i - 1].threadTo(panel);
            }
            memory.addSpring(10, 100.0);
            memory.add(panel);
            ++i;
        }
        this.mem_panel[0].selector.setValue(2);
        this.mem_panel[1].selector.setValue(2);
        memory.addSpring(10, 100.0);
        FlowPanel contents = new FlowPanel(1);
        contents.setBackground(BACKGROUND);
        contents.setFill(2);
        contents.addSpring(20, 100.0);
        contents.add(controls);
        contents.addSpring(20, 100.0);
        contents.add(memory);
        contents.addSpring(20, 100.0);
        this.cpu.getLog().addListener(new LogListener());
        this.getContentPane().setBackground(BACKGROUND);
        this.getContentPane().add((Component)contents, "Center");
        LocaleManager.addListener(this);
        this.setFontSize(12);
        this.localeChanged();
    }

    public void localeChanged() {
        this.setTitle(Strings.get("cpuFrameTitle"));
        this.file_menu.renewStrings();
        this.memory_menu.renewStrings();
        this.assembler_menu.renewStrings();
        this.options_menu.renewStrings();
        this.help_menu.renewStrings();
        this.control_panel.renewStrings();
        this.register_panel.renewStrings();
        this.tty_panel.renewStrings();
        int i = 0;
        while (i < this.mem_panel.length) {
            this.mem_panel[i].renewStrings();
            ++i;
        }
        this.pack();
        this.editor.renewStrings();
        this.errors.renewStrings();
        this.help_frame.renewStrings();
        JFileChooser newch = new JFileChooser();
        File f = this.chooser.getCurrentDirectory();
        if (f != null) {
            newch.setCurrentDirectory(f);
        }
        if ((f = this.chooser.getSelectedFile()) != null) {
            newch.setSelectedFile(f);
        }
        this.chooser = newch;
    }

    public ErrorWindow getErrorWindow() {
        return this.errors;
    }

    public void doAssemble(Frame parent, Reader reader) {
        Assembler.Error[] errs = Assembler.assemble(reader, this.cpu);
        this.errors.setErrors(errs);
        if (errs == null) {
            this.errors.setErrors(null);
        } else {
            this.errors.show();
        }
    }

    private void insertByteAt(int addr) {
        EventLog.Cause cause = new EventLog.Cause();
        int i = 30;
        while (i > addr) {
            int val = this.cpu.getMem(i - 1).getValue();
            this.cpu.getMem(i).setValue(val, cause);
            --i;
        }
        this.cpu.getMem(addr).setValue(0, cause);
    }

    private void removeByteAt(int addr) {
        EventLog.Cause cause = new EventLog.Cause();
        int i = addr;
        while (i < 30) {
            int val = this.cpu.getMem(i + 1).getValue();
            this.cpu.getMem(i).setValue(val, cause);
            ++i;
        }
    }

    public void doQuit() {
        this.editor.closeWindow();
        System.exit(0);
    }

    private void setFontSize(int new_size) {
        this.font_size = new_size;
        float size = this.font_size;
        this.control_panel.setFontSize(size);
        this.register_panel.setFontSize(size);
        this.tty_panel.setFontSize(size);
        int i = 0;
        while (i < this.mem_panel.length) {
            this.mem_panel[i].setFontSize(size);
            ++i;
        }
        this.options_menu.size_item.sizeChanged(new_size);
        this.pack();
    }

    private void showError(String msg) {
        JOptionPane.showMessageDialog(this, msg, Strings.get("errorDlogTitle"), 0);
    }

    private class FileMenu
    extends JMenu
    implements ActionListener {
        JMenuItem print = new JMenuItem();
        JMenuItem quit = new JMenuItem();

        FileMenu() {
            this.add(this.print);
            this.print.addActionListener(this);
            this.add(this.quit);
            this.quit.addActionListener(this);
        }

        private void renewStrings() {
            this.setText(Strings.get("fileMenu"));
            this.print.setText(Strings.get("printWindowMenuItem"));
            this.quit.setText(Strings.get("quitMenuItem"));
        }

        public void actionPerformed(ActionEvent evt) {
            Object src = evt.getSource();
            if (src == this.print) {
                this.doPrint();
            } else if (src == this.quit) {
                CpuView.this.doQuit();
            }
        }

        private void doPrint() {
            try {
                PrintUtilities.printComponent(CpuView.this);
            }
            catch (PrinterException e) {
                CpuView.this.showError(String.valueOf(Strings.get("printError")) + ": " + e);
            }
        }
    }

    private class MemoryMenu
    extends JMenu
    implements ActionListener {
        JMenuItem insert = new JMenuItem();
        JMenuItem remove = new JMenuItem();
        JMenuItem clear = new JMenuItem();
        JMenuItem open = new JMenuItem();
        JMenuItem save = new JMenuItem();

        MemoryMenu() {
            this.add(this.insert);
            this.insert.addActionListener(this);
            this.add(this.remove);
            this.remove.addActionListener(this);
            this.add(this.clear);
            this.clear.addActionListener(this);
            this.addSeparator();
            this.add(this.open);
            this.open.addActionListener(this);
            this.add(this.save);
            this.save.addActionListener(this);
        }

        private void renewStrings() {
            this.setText(Strings.get("memoryMenu"));
            this.insert.setText(Strings.get("insertByteMenuItem"));
            this.remove.setText(Strings.get("deleteByteMenuItem"));
            this.clear.setText(Strings.get("clearMemoryMenuItem"));
            this.open.setText(Strings.get("openImageMenuItem"));
            this.save.setText(Strings.get("saveImageMenuItem"));
        }

        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            if (source == this.insert) {
                this.doInsert();
            } else if (source == this.remove) {
                this.doRemove();
            } else if (source == this.clear) {
                CpuView.this.cpu.resetMemory();
            } else if (source == this.open) {
                this.doOpen();
            } else if (source == this.save) {
                this.doSave();
            }
        }

        private void doInsert() {
            int loc = this.getMemoryAddress(Strings.get("insertBytePrompt"));
            if (loc >= 0) {
                CpuView.this.insertByteAt(loc);
            }
        }

        private void doRemove() {
            int loc = this.getMemoryAddress(Strings.get("deleteBytePrompt"));
            if (loc >= 0) {
                CpuView.this.removeByteAt(loc);
            }
        }

        private int getMemoryAddress(String msg) {
            String val = JOptionPane.showInputDialog(CpuView.this, (Object)msg);
            if (val == null) {
                return -1;
            }
            try {
                int loc = Integer.parseInt(val, 2);
                if (loc >= 0 || loc < 31) {
                    return loc;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            CpuView.this.showError(String.valueOf(Strings.get("badAddressError")) + ": " + val);
            return -1;
        }

        public void doOpen() {
            int val = CpuView.this.chooser.showOpenDialog(CpuView.this);
            if (val != 0) {
                return;
            }
            try {
                MachineFile.load(CpuView.this.chooser.getSelectedFile(), CpuView.this.cpu);
            }
            catch (IOException e) {
                CpuView.this.showError(String.valueOf(Strings.get("openImageError")) + ": " + e.getMessage());
            }
        }

        public void doSave() {
            int val = CpuView.this.chooser.showSaveDialog(CpuView.this);
            if (val != 0) {
                return;
            }
            try {
                MachineFile.save(CpuView.this.chooser.getSelectedFile(), CpuView.this.cpu);
            }
            catch (IOException e) {
                CpuView.this.showError(String.valueOf(Strings.get("saveImageError")) + ": " + e.getMessage());
            }
        }
    }

    private class AssemblerMenu
    extends JMenu
    implements ActionListener,
    ErrorWindow.Listener {
        JMenuItem show_editor = new JMenuItem();
        JMenuItem show_errors = new JMenuItem();
        JMenuItem file = new JMenuItem();

        AssemblerMenu() {
            this.add(this.show_editor);
            this.show_editor.addActionListener(this);
            this.add(this.show_errors);
            this.show_errors.addActionListener(this);
            this.addSeparator();
            this.add(this.file);
            this.file.addActionListener(this);
            CpuView.this.errors.addListener(this);
            this.sourceProgramChanged(null);
        }

        private void renewStrings() {
            this.setText(Strings.get("assemblerMenu"));
            this.show_editor.setText(Strings.get("showEditorMenuItem"));
            this.show_errors.setText(Strings.get("showErrorsMenuItem"));
            this.file.setText(Strings.get("assembleFileMenuItem"));
        }

        public void actionPerformed(ActionEvent evt) {
            Object src = evt.getSource();
            if (src == this.show_editor) {
                CpuView.this.editor.show();
            }
            if (src == this.show_errors) {
                CpuView.this.errors.show();
            }
            if (src == this.file) {
                this.doFile();
            }
        }

        private void doFile() {
            int val = CpuView.this.chooser.showOpenDialog(CpuView.this);
            if (val != 0) {
                return;
            }
            try {
                FileReader reader = new FileReader(CpuView.this.chooser.getSelectedFile());
                CpuView.this.doAssemble(CpuView.this, reader);
                reader.close();
            }
            catch (IOException e) {
                CpuView.this.showError(String.valueOf(Strings.get("openFileError")) + ": " + e.getMessage());
                return;
            }
        }

        public void errorSelected(ErrorWindow.Event evt) {
        }

        public void sourceProgramChanged(ErrorWindow.Event evt) {
            Assembler.Error[] data = CpuView.this.errors.getErrors();
            this.show_errors.setEnabled(data != null && data.length != 0);
        }
    }

    class FontSizeItem
    extends JMenu
    implements ActionListener {
        private int[] sizes = new int[]{12, 14, 16, 18, 20, 24};
        private JRadioButtonMenuItem[] items = new JRadioButtonMenuItem[this.sizes.length];

        FontSizeItem() {
            ButtonGroup bgroup = new ButtonGroup();
            int i = 0;
            while (i < this.items.length) {
                this.items[i] = new JRadioButtonMenuItem();
                bgroup.add(this.items[i]);
                this.items[i].addActionListener(this);
                this.items[i].setSelected(this.sizes[i] == CpuView.this.font_size);
                this.add(this.items[i]);
                ++i;
            }
        }

        private void renewStrings() {
            this.setText(Strings.get("fontSizeMenuItem"));
            int i = 0;
            while (i < this.items.length) {
                this.items[i].setText(String.valueOf(this.sizes[i]) + " " + Strings.get("fontSizeUnits"));
                ++i;
            }
        }

        private void sizeChanged(int value) {
            int i = 0;
            while (i < this.items.length) {
                this.items[i].setSelected(this.sizes[i] == value);
                ++i;
            }
        }

        public void actionPerformed(ActionEvent evt) {
            Object src = evt.getSource();
            int i = 0;
            while (i < this.items.length) {
                int size;
                if (src == this.items[i] && this.items[i].isSelected() && (size = this.sizes[i]) != CpuView.this.font_size) {
                    CpuView.this.setFontSize(size);
                }
                ++i;
            }
        }
    }

    class OptionsMenu
    extends JMenu {
        FontSizeItem size_item;

        OptionsMenu() {
            this.size_item = new FontSizeItem();
            this.add(this.size_item);
            this.add(Strings.createLocaleMenuItem());
        }

        private void renewStrings() {
            this.setText(Strings.get("optionsMenu"));
            this.size_item.renewStrings();
        }
    }

    private class HelpMenu
    extends JMenu
    implements ActionListener {
        JMenuItem help = new JMenuItem();
        JMenuItem about = new JMenuItem();
        URL index = null;

        HelpMenu() {
            this.add(this.help);
            this.help.addActionListener(this);
            this.add(this.about);
            this.about.addActionListener(this);
        }

        private void renewStrings() {
            this.setText(Strings.get("helpMenu"));
            this.help.setText(Strings.get("helpMenuItem"));
            this.about.setText(Strings.get("aboutMenuItem"));
            CpuView.this.help_frame.setTitle(Strings.get("helpTitle"));
            CpuView.this.help_frame.clearContentsItems();
            try {
                this.index = CpuView.this.help_frame.getURL(Strings.get("contentsLoc"));
                CpuView.this.help_frame.setLocation(this.index);
                CpuView.this.help_frame.addContentsItem(Strings.get("contentsItem"), this.index);
            }
            catch (HelpFrame.NotFoundException notFoundException) {
                // empty catch block
            }
        }

        public void actionPerformed(ActionEvent evt) {
            Object src = evt.getSource();
            if (src == this.help) {
                this.doHelp();
            }
            if (src == this.about) {
                this.doAbout();
            }
        }

        private void doHelp() {
            try {
                if (this.index == null) {
                    this.index = CpuView.this.help_frame.getURL(Strings.get("contentsLoc"));
                }
                CpuView.this.help_frame.load(this.index);
                CpuView.this.help_frame.show();
            }
            catch (HelpFrame.NotFoundException e) {
                JOptionPane.showMessageDialog(CpuView.this, String.valueOf(Strings.get("helpNotFoundError")) + ": " + e.getMessage());
            }
        }

        private void doAbout() {
            JOptionPane.showMessageDialog(CpuView.this, Strings.get("aboutMsg"), Strings.get("aboutTitle"), -1);
        }
    }

    private class MemoryLocationMenu
    extends JPopupMenu
    implements ActionListener,
    MouseListener {
        JMenuItem insert = new JMenuItem(Strings.get("insertBytePopupItem"));
        JMenuItem remove = new JMenuItem(Strings.get("deleteBytePopupItem"));
        WordView view;
        int addr;

        MemoryLocationMenu(WordView view, int addr) {
            super(Strings.get("bytePopupMenu"));
            this.view = view;
            this.addr = addr;
            this.add(this.insert);
            this.insert.addActionListener(this);
            this.add(this.remove);
            this.remove.addActionListener(this);
        }

        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            if (source == this.insert) {
                CpuView.this.insertByteAt(this.addr);
            } else if (source == this.remove) {
                CpuView.this.removeByteAt(this.addr);
            }
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            int mods = e.getModifiers();
            int b1 = 24;
            int b2 = 8;
            int b3 = 4;
            if ((mods & b1) == b1 || (mods & b2) == b2 || (mods & b3) == b3) {
                this.show(this.view, e.getX(), e.getY());
            }
        }

        public void mouseReleased(MouseEvent e) {
        }
    }

    private class MemoryPanel
    extends FlowPanel {
        private TypeSelector selector = new TypeSelector();
        private WordView[] locs;
        private int start;

        MemoryPanel(int start, int end) {
            super(1);
            this.start = start;
            this.setAnchor(13);
            this.setBackground(BACKGROUND);
            this.setLetterBox(5);
            this.addSpring(5, 100.0);
            this.add(this.selector);
            this.locs = new WordView[end - start];
            int i = 0;
            while (i < this.locs.length) {
                String label = Integer.toBinaryString(start + i);
                while (label.length() < 5) {
                    label = "0" + label;
                }
                this.locs[i] = new WordView(CpuView.this.cpu.getMem(start + i));
                this.locs[i].setLabel(label);
                this.locs[i].setBackground(BACKGROUND);
                this.locs[i].setTypeSelector(this.selector);
                MemoryLocationMenu l = new MemoryLocationMenu(this.locs[i], start + i);
                this.locs[i].getLabel().addMouseListener(l);
                this.locs[i].getField().addMouseListener(l);
                this.add(this.locs[i]);
                if (i > 0) {
                    this.locs[i - 1].getField().setNextFocusableComponent(this.locs[i].getField());
                }
                ++i;
            }
            this.addSpring(5, 100.0);
        }

        private void renewStrings() {
            this.selector.renewStrings();
        }

        public void mapViews(HashMap map) {
            int i = 0;
            while (i < this.locs.length) {
                map.put(this.locs[i].getSource(), this.locs[i]);
                ++i;
            }
        }

        private void threadTo(MemoryPanel other) {
            this.locs[this.locs.length - 1].getField().setNextFocusableComponent(other.locs[0].getField());
        }

        private void setFontSize(float size) {
            this.selector.setFontSize(size);
            int i = 0;
            while (i < this.locs.length) {
                this.locs[i].setFontSize(size);
                ++i;
            }
        }
    }

    private class TtyPanel
    extends FlowPanel {
        JLabel label = new JLabel();

        TtyPanel(Cpu cpu) {
            super(0);
            this.setAnchor(11);
            this.setBackground(BACKGROUND);
            this.add(this.label);
            this.addSpring(2, 0.0);
            this.add(CpuView.this.io_area);
        }

        private void renewStrings() {
            this.label.setText(Strings.get("ioLabel"));
        }

        private void setFontSize(float size) {
            this.label.setFont(this.label.getFont().deriveFont(size));
            CpuView.this.io_area.setFontSize(size);
        }
    }

    private class WindowCloser
    extends WindowAdapter {
        WindowCloser() {
        }

        public void windowClosing(WindowEvent e) {
            CpuView.this.doQuit();
        }
    }

    class LogListener
    implements EventLog.Listener {
        private Object last_cause = null;
        private ArrayList highlighted = new ArrayList();

        LogListener() {
        }

        public void eventAdded(EventLog.LogEvent log_event) {
            EventLog.Event event = log_event.event;
            if (event instanceof Register.AccessEvent) {
                WordView view;
                if (event.cause != this.last_cause && this.highlighted.size() > 0) {
                    Iterator it = ((AbstractList)this.highlighted).iterator();
                    while (it.hasNext()) {
                        view = (WordView)it.next();
                        view.setHighlighted(false);
                    }
                    this.highlighted.clear();
                }
                if (event.cause instanceof Cpu.StepCause) {
                    Register reg = ((Register.AccessEvent)event).getRegister();
                    view = (WordView)CpuView.this.view_map.get(reg);
                    if (view != null && !view.isHighlighted()) {
                        view.setHighlighted(true);
                        this.highlighted.add(view);
                    }
                    this.last_cause = event.cause;
                }
            }
        }

        public void eventRemoved(EventLog.LogEvent event) {
            this.eventAdded(event);
        }
    }
}

