/*
 * Decompiled with CFR 0.152.
 */
package edu.csbsju.socs.hymn;

import edu.csbsju.socs.hymn.CpuView;
import edu.csbsju.socs.hymn.ErrorWindow;
import edu.csbsju.socs.hymn.Strings;
import edu.csbsju.socs.util.PrintUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PrinterException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;

class Editor
extends JFrame {
    private static final Font FONT = new Font("Monospaced", 0, 12);
    private CpuView cpu_view = null;
    private FileMenu file_menu = new FileMenu();
    private EditMenu edit_menu = new EditMenu();
    private OptionsMenu options_menu = new OptionsMenu();
    private Controls controls = new Controls();
    private JFileChooser chooser = new JFileChooser(".");
    private JTextArea main = new JTextArea(12, 25);
    private JLabel info = new JLabel(" ");
    private boolean changed = false;
    private int font_size;
    private int font_style = 0;
    private Object highlight = null;

    Editor() {
        this.addWindowListener(new WindowCloser());
        JMenuBar menubar = new JMenuBar();
        menubar.add(this.file_menu);
        menubar.add(this.edit_menu);
        menubar.add(this.options_menu);
        this.setJMenuBar(menubar);
        int margin = (int)this.info.getPreferredSize().getHeight();
        Border border = BorderFactory.createEmptyBorder(0, margin, 0, margin);
        this.info.setHorizontalAlignment(2);
        this.info.setBorder(border);
        JPanel center = new JPanel(new BorderLayout());
        center.setBorder(border);
        center.add((Component)new JScrollPane(this.main), "Center");
        Container contents = this.getContentPane();
        contents.add((Component)this.controls, "North");
        contents.add((Component)center, "Center");
        contents.add((Component)this.info, "South");
        this.main.setFont(FONT);
        this.main.getDocument().addDocumentListener(new MyDocumentListener());
        this.setChanged(false);
        this.setCpuView(null);
        this.setFontSize(12);
    }

    void renewStrings() {
        this.setTitle(Strings.get("editorFrameTitle"));
        this.file_menu.renewStrings();
        this.edit_menu.renewStrings();
        this.options_menu.renewStrings();
        this.controls.renewStrings();
        this.pack();
        JFileChooser newch = new JFileChooser();
        File f = this.chooser.getCurrentDirectory();
        if (f != null) {
            newch.setCurrentDirectory(f);
        }
        if ((f = this.chooser.getSelectedFile()) != null) {
            newch.setSelectedFile(f);
        }
        this.chooser = newch;
    }

    void setFontSize(int size) {
        if (size == this.font_size) {
            return;
        }
        float sizef = size;
        this.font_size = size;
        this.main.setFont(this.main.getFont().deriveFont(sizef));
        this.controls.assemble.setFont(this.controls.assemble.getFont().deriveFont(sizef));
        this.controls.close.setFont(this.controls.close.getFont().deriveFont(sizef));
        this.options_menu.size_item.sizeChanged(size);
        this.pack();
    }

    void setFontStyle(int style) {
        if (style == this.font_style) {
            return;
        }
        this.font_style = style;
        this.main.setFont(this.main.getFont().deriveFont(style));
        this.options_menu.boldf_item.setState(style == 1);
        this.pack();
    }

    public void setCpuView(CpuView value) {
        this.cpu_view = value;
        this.controls.assemble.setEnabled(this.cpu_view != null);
        this.controls.assemble.setEnabled(this.cpu_view != null);
    }

    private void setChanged(boolean value) {
        if (value && this.highlight != null) {
            this.main.getHighlighter().removeHighlight(this.highlight);
            this.highlight = null;
        }
        if (value == this.changed) {
            return;
        }
        this.changed = value;
    }

    public void closeWindow() {
        this.toFront();
        int val = JOptionPane.showConfirmDialog(this, Strings.get("confirmClosePrompt"), Strings.get("confirmCloseTitle"), 0);
        if (val == 0) {
            this.doSave();
        }
        this.hide();
    }

    private boolean doSave() {
        int val = this.chooser.showSaveDialog(this);
        if (val != 0) {
            return false;
        }
        try {
            PrintWriter writer = new PrintWriter(new FileWriter(this.chooser.getSelectedFile()));
            writer.print(this.main.getText());
            writer.close();
        }
        catch (IOException e) {
            this.showError(String.valueOf(Strings.get("saveFileError")) + ": " + e.getMessage());
            return false;
        }
        this.setChanged(false);
        return true;
    }

    private boolean confirmLoss(String msg) {
        if (!this.changed) {
            return true;
        }
        this.toFront();
        int val = JOptionPane.showConfirmDialog(this, msg);
        if (val == 2) {
            return false;
        }
        return val != 1 || this.doSave();
    }

    private void showError(String msg) {
        JOptionPane.showMessageDialog(this, msg, Strings.get("errorDlogTitle"), 0);
    }

    class FileMenu
    extends JMenu
    implements ActionListener {
        JMenuItem newi = new JMenuItem();
        JMenuItem open = new JMenuItem();
        JMenuItem save = new JMenuItem();
        JMenuItem print = new JMenuItem();
        JMenuItem close = new JMenuItem();

        FileMenu() {
            this.add(this.newi);
            this.newi.addActionListener(this);
            this.add(this.open);
            this.open.addActionListener(this);
            this.add(this.save);
            this.save.addActionListener(this);
            this.addSeparator();
            this.add(this.print);
            this.print.addActionListener(this);
            this.add(this.close);
            this.close.addActionListener(this);
        }

        private void renewStrings() {
            this.setText(Strings.get("fileMenu"));
            this.newi.setText(Strings.get("newMenuItem"));
            this.open.setText(Strings.get("openMenuItem"));
            this.save.setText(Strings.get("saveMenuItem"));
            this.print.setText(Strings.get("printMenuItem"));
            this.close.setText(Strings.get("closeMenuItem"));
        }

        public void actionPerformed(ActionEvent evt) {
            Object src = evt.getSource();
            if (src == this.newi) {
                this.doNew();
            } else if (src == this.open) {
                this.doOpen();
            } else if (src == this.save) {
                Editor.this.doSave();
            } else if (src == this.print) {
                this.doPrint();
            } else if (src == this.close) {
                Editor.this.closeWindow();
            }
        }

        private void doNew() {
            if (!Editor.this.confirmLoss(Strings.get("confirmReplacePrompt"))) {
                return;
            }
            Editor.this.main.setText("");
            Editor.this.setChanged(false);
        }

        private void doOpen() {
            if (!Editor.this.confirmLoss(Strings.get("confirmReplacePrompt"))) {
                return;
            }
            int val = Editor.this.chooser.showOpenDialog(this);
            if (val != 0) {
                return;
            }
            StringBuffer buffer = new StringBuffer();
            try {
                String line;
                BufferedReader reader = new BufferedReader(new FileReader(Editor.this.chooser.getSelectedFile()));
                while ((line = reader.readLine()) != null) {
                    buffer.append(line);
                    buffer.append("\n");
                }
                reader.close();
            }
            catch (IOException e) {
                Editor.this.showError(String.valueOf(Strings.get("openFileError")) + ": " + e.getMessage());
                return;
            }
            Editor.this.main.setText(buffer.toString());
            Editor.this.setChanged(false);
        }

        private void doPrint() {
            try {
                PrintUtilities.printText(Editor.this.main.getText());
            }
            catch (PrinterException e) {
                Editor.this.showError(String.valueOf(Strings.get("printError")) + ": " + e);
            }
        }
    }

    class EditMenu
    extends JMenu
    implements ActionListener {
        JMenuItem cut = new JMenuItem();
        JMenuItem copy = new JMenuItem();
        JMenuItem paste = new JMenuItem();

        EditMenu() {
            this.add(this.cut);
            this.cut.addActionListener(this);
            this.add(this.copy);
            this.copy.addActionListener(this);
            this.add(this.paste);
            this.paste.addActionListener(this);
        }

        private void renewStrings() {
            this.setText(Strings.get("editMenu"));
            this.cut.setText(Strings.get("cutMenuItem"));
            this.copy.setText(Strings.get("copyMenuItem"));
            this.paste.setText(Strings.get("pasteMenuItem"));
        }

        public void actionPerformed(ActionEvent evt) {
            Object src = evt.getSource();
            if (src == this.cut) {
                Editor.this.main.cut();
            } else if (src == this.copy) {
                Editor.this.main.copy();
            } else if (src == this.paste) {
                Editor.this.main.paste();
            }
        }
    }

    class FontSizeItem
    extends JMenu
    implements ActionListener {
        private int[] sizes = new int[]{12, 14, 16, 18, 20, 24};
        private JRadioButtonMenuItem[] items = new JRadioButtonMenuItem[this.sizes.length];

        FontSizeItem() {
            ButtonGroup bgroup = new ButtonGroup();
            int i = 0;
            while (i < this.items.length) {
                this.items[i] = new JRadioButtonMenuItem();
                bgroup.add(this.items[i]);
                this.items[i].addActionListener(this);
                this.items[i].setSelected(this.sizes[i] == Editor.this.font_size);
                this.add(this.items[i]);
                ++i;
            }
        }

        private void renewStrings() {
            this.setText(Strings.get("fontSizeMenuItem"));
            int i = 0;
            while (i < this.items.length) {
                this.items[i].setText(String.valueOf(this.sizes[i]) + " " + Strings.get("fontSizeUnits"));
                ++i;
            }
        }

        private void sizeChanged(int value) {
            int i = 0;
            while (i < this.items.length) {
                this.items[i].setSelected(this.sizes[i] == value);
                ++i;
            }
        }

        public void actionPerformed(ActionEvent evt) {
            Object src = evt.getSource();
            int i = 0;
            while (i < this.items.length) {
                int size;
                if (src == this.items[i] && this.items[i].isSelected() && (size = this.sizes[i]) != Editor.this.font_size) {
                    Editor.this.setFontSize(size);
                }
                ++i;
            }
        }
    }

    class OptionsMenu
    extends JMenu
    implements ActionListener {
        FontSizeItem size_item;
        JCheckBoxMenuItem boldf_item;

        OptionsMenu() {
            this.size_item = new FontSizeItem();
            this.boldf_item = new JCheckBoxMenuItem("Bold Font");
            this.add(this.size_item);
            this.add(this.boldf_item);
            this.boldf_item.addActionListener(this);
            this.boldf_item.setState(FONT.getStyle() == 1);
        }

        private void renewStrings() {
            this.setText(Strings.get("optionsMenu"));
            this.size_item.renewStrings();
        }

        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            if (src == this.boldf_item) {
                if (this.boldf_item.getState()) {
                    Editor.this.setFontStyle(1);
                } else {
                    Editor.this.setFontStyle(0);
                }
            }
        }
    }

    private class Controls
    extends JPanel
    implements ActionListener,
    ErrorWindow.Listener {
        private JButton assemble = new JButton();
        private JButton close = new JButton();
        private boolean listener_added = false;

        Controls() {
            this.add(this.assemble);
            this.assemble.addActionListener(this);
            this.add(this.close);
            this.close.addActionListener(this);
        }

        private void renewStrings() {
            this.assemble.setText(Strings.get("assembleButton"));
            this.close.setText(Strings.get("closeButton"));
        }

        public void actionPerformed(ActionEvent evt) {
            Object src = evt.getSource();
            if (src == this.assemble) {
                this.doAssemble();
            } else if (src == this.close) {
                Editor.this.closeWindow();
            }
        }

        private void doAssemble() {
            if (Editor.this.cpu_view == null) {
                return;
            }
            StringReader reader = new StringReader(Editor.this.main.getText());
            Editor.this.cpu_view.doAssemble(Editor.this, reader);
            reader.close();
            if (!this.listener_added) {
                this.listener_added = true;
                Editor.this.cpu_view.getErrorWindow().addListener(this);
            }
        }

        public void errorSelected(ErrorWindow.Event evt) {
            int desired = evt.getError().getLineNumber();
            if (desired < 0) {
                return;
            }
            String text = Editor.this.main.getText();
            StringTokenizer toks = new StringTokenizer(text, "\n", true);
            int line_num = 1;
            int pos = 0;
            int start = 0;
            boolean found = line_num == 1;
            while (toks.hasMoreTokens()) {
                String tok = toks.nextToken();
                pos += tok.length();
                if (!tok.equals("\n") || ++line_num < desired) continue;
                if (desired != line_num) break;
                start = pos;
                found = true;
            }
            if (found && pos > 0) {
                if (Editor.this.highlight != null) {
                    Editor.this.main.getHighlighter().removeHighlight(Editor.this.highlight);
                }
                try {
                    Editor.this.highlight = Editor.this.main.getHighlighter().addHighlight(start, pos, DefaultHighlighter.DefaultPainter);
                    Editor.this.info.setText(evt.getError().getMessage());
                    Editor.this.main.requestFocus();
                    Editor.this.show();
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }

        public void sourceProgramChanged(ErrorWindow.Event evt) {
            evt.getSource().removeListener(this);
            this.listener_added = false;
        }
    }

    class WindowCloser
    extends WindowAdapter {
        WindowCloser() {
        }

        public void windowClosing(WindowEvent e) {
            Editor.this.closeWindow();
        }
    }

    class MyDocumentListener
    implements DocumentListener {
        MyDocumentListener() {
        }

        public void insertUpdate(DocumentEvent evt) {
            Editor.this.setChanged(true);
        }

        public void removeUpdate(DocumentEvent evt) {
            Editor.this.setChanged(true);
        }

        public void changedUpdate(DocumentEvent evt) {
            Editor.this.setChanged(true);
        }
    }
}

