/*
 * Decompiled with CFR 0.152.
 */
package edu.csbsju.socs.hymn;

import edu.csbsju.socs.hymn.Assembler;
import edu.csbsju.socs.hymn.Strings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;

class ErrorWindow
extends JFrame {
    private Assembler.Error[] errors;
    private int[] error_pos;
    private LinkedList listeners = new LinkedList();
    private MyListener listen = new MyListener();
    private JTextArea error_text = new JTextArea(10, 40);
    private JLabel label = new JLabel();
    private JButton close = new JButton();
    private Object highlight = null;

    public ErrorWindow() {
        this.error_text.setEditable(false);
        this.error_text.getCaret().setVisible(false);
        this.label.setHorizontalAlignment(2);
        this.label.setBorder(BorderFactory.createEmptyBorder(10, 10, 2, 10));
        JScrollPane scroll_pane = new JScrollPane(this.error_text);
        scroll_pane.setMinimumSize(new Dimension(200, 200));
        JPanel text_pane = new JPanel(new BorderLayout());
        text_pane.add((Component)scroll_pane, "Center");
        text_pane.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        JPanel controls = new JPanel();
        controls.add(this.close);
        Container contents = this.getContentPane();
        contents.add((Component)this.label, "North");
        contents.add((Component)text_pane, "Center");
        contents.add((Component)controls, "South");
        this.setErrors(null);
        this.addWindowListener(this.listen);
        this.close.addActionListener(this.listen);
        this.pack();
    }

    void renewStrings() {
        this.setTitle(Strings.get("errorsFrameTitle"));
        this.close.setText(Strings.get("closeButton"));
        this.label.setText(Strings.get("errorsLabel"));
        this.setErrors(this.errors);
        this.pack();
    }

    public Assembler.Error[] getErrors() {
        return this.errors;
    }

    public void setErrors(Assembler.Error[] errors) {
        this.error_text.removeCaretListener(this.listen);
        if (errors == null || errors.length == 0) {
            this.errors = new Assembler.Error[0];
            this.error_pos = new int[0];
            this.error_text.setText(Strings.get("noErrorsMsg"));
            this.fireSourceProgramChanged(new Event(this));
            return;
        }
        this.errors = errors;
        this.error_pos = new int[errors.length + 1];
        StringBuffer text = new StringBuffer();
        String line_lab = String.valueOf(Strings.get("line")) + " ";
        int i = 0;
        while (i < errors.length) {
            int line = errors[i].getLineNumber();
            String msg = errors[i].getMessage();
            if (i > 0) {
                text.append("\n");
            }
            this.error_pos[i] = text.length();
            if (line >= 0) {
                text.append(String.valueOf(line_lab) + line + ": ");
            }
            text.append(msg);
            ++i;
        }
        this.error_pos[errors.length] = text.length() + 1;
        this.error_text.setText(text.toString());
        if (this.highlight != null) {
            this.error_text.getHighlighter().removeHighlight(this.highlight);
            this.highlight = null;
        }
        this.error_text.addCaretListener(this.listen);
        this.fireSourceProgramChanged(new Event(this));
    }

    public void addListener(Listener l) {
        this.listeners.add(l);
    }

    public void removeListener(Listener l) {
        this.listeners.remove(l);
    }

    private void fireErrorSelected(Event e) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ((Listener)it.next()).errorSelected(e);
        }
    }

    private void fireSourceProgramChanged(Event e) {
        Object[] items = this.listeners.toArray();
        int i = 0;
        while (i < items.length) {
            ((Listener)items[i]).sourceProgramChanged(e);
            ++i;
        }
    }

    public static class Event {
        private final ErrorWindow win;
        private final Assembler.Error error;

        public Event(ErrorWindow win) {
            this(win, null);
        }

        public Event(ErrorWindow win, Assembler.Error error) {
            this.win = win;
            this.error = error;
        }

        public ErrorWindow getSource() {
            return this.win;
        }

        public Assembler.Error getError() {
            return this.error;
        }
    }

    public static interface Listener {
        public void errorSelected(Event var1);

        public void sourceProgramChanged(Event var1);
    }

    private class MyListener
    extends WindowAdapter
    implements ActionListener,
    CaretListener {
        private boolean changing = false;

        MyListener() {
        }

        public void windowClosing(WindowEvent evt) {
            ErrorWindow.this.hide();
        }

        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == ErrorWindow.this.close) {
                ErrorWindow.this.dispose();
            }
        }

        public void caretUpdate(CaretEvent e) {
            if (this.changing || ErrorWindow.this.error_pos == null || ErrorWindow.this.error_pos.length == 0) {
                return;
            }
            int pos = e.getDot();
            int idx = Arrays.binarySearch(ErrorWindow.this.error_pos, pos);
            if (idx < 0) {
                idx = -idx - 2;
            }
            if (idx < 0) {
                return;
            }
            if (idx >= ErrorWindow.this.errors.length) {
                idx = ErrorWindow.this.errors.length - 1;
            }
            int start = ErrorWindow.this.error_pos[idx];
            int end = ErrorWindow.this.error_pos[idx + 1] - 1;
            if (ErrorWindow.this.highlight != null) {
                ErrorWindow.this.error_text.getHighlighter().removeHighlight(ErrorWindow.this.highlight);
            }
            try {
                this.changing = true;
                ErrorWindow.this.error_text.setCaretPosition(start);
                this.changing = false;
                ErrorWindow.this.highlight = ErrorWindow.this.error_text.getHighlighter().addHighlight(start, end, DefaultHighlighter.DefaultPainter);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            ErrorWindow.this.fireErrorSelected(new Event(ErrorWindow.this, ErrorWindow.this.errors[idx]));
        }
    }
}

