/*
 * Decompiled with CFR 0.152.
 */
package edu.csbsju.socs.hymn;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Stack;

class EventLog {
    private Stack past = new Stack();
    private LinkedList listeners = new LinkedList();

    public void addListener(Listener l) {
        this.listeners.add(l);
    }

    public void removeListener(Listener l) {
        this.listeners.remove(l);
    }

    private void fireEventAdded(LogEvent e) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ((Listener)it.next()).eventAdded(e);
        }
    }

    private void fireEventRemoved(LogEvent e) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ((Listener)it.next()).eventRemoved(e);
        }
    }

    public void clear() {
        this.past.clear();
    }

    public void doIt(Event evt) {
        evt.doIt();
        this.add(evt);
    }

    public void add(Event evt) {
        this.past.push(evt);
        this.fireEventAdded(new LogEvent(this, evt));
    }

    public boolean isEmpty() {
        return this.past.size() == 0;
    }

    public void undo() {
        if (this.past.size() == 0) {
            return;
        }
        Event last = (Event)this.past.pop();
        last.undoIt();
        while (this.past.size() > 0) {
            Event next = (Event)this.past.pop();
            if (!next.cause.mergesWith(last.cause)) {
                this.past.push(next);
                break;
            }
            last = next;
            last.undoIt();
        }
        this.fireEventRemoved(new LogEvent(this));
    }

    public static class Cause {
        public boolean mergesWith(Cause other) {
            return this == other;
        }
    }

    public static abstract class Event {
        protected final Cause cause;

        Event(Cause cause) {
            this.cause = cause;
        }

        public Cause getCause() {
            return this.cause;
        }

        public abstract void doIt();

        public abstract void undoIt();
    }

    public static class LogEvent {
        public final EventLog log;
        public final Event event;

        public LogEvent(EventLog log) {
            this(log, null);
        }

        public LogEvent(EventLog log, Event event) {
            this.log = log;
            this.event = event;
        }
    }

    public static interface Listener {
        public void eventAdded(LogEvent var1);

        public void eventRemoved(LogEvent var1);
    }
}

